/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import java.util.Vector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.PolygonFiller;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TrackEditDialog;
import rene.zirkel.structures.Coordinates;

public class TrackObject
extends ConstructionObject
implements PointonObject {
    static Count N = new Count();
    PointObject PM;
    ConstructionObject O;
    ConstructionObject P;
    int PMax = 16;
    int PN;
    ConstructionObject[] PO = new ConstructionObject[this.PMax];
    boolean Filled = false;
    boolean Discrete = false;
    int Type = 0;
    PolygonFiller PF = null;
    Vector V = new Vector();
    Vector[] VO = new Vector[this.PMax];
    double da = 0.0;
    double oldx;
    double oldy;
    double X;
    double Y;
    double DX;
    double DY;
    double[] XO = new double[this.PMax];
    double[] YO = new double[this.PMax];
    double[] DXO = new double[this.PMax];
    double[] DYO = new double[this.PMax];
    int Omit = 1;
    boolean DontProject = false;
    double DMin = 0.001;
    public double StepSize = 5.0;
    boolean Fixed = false;
    boolean StartFix;

    public void setFilled(boolean bl) {
        this.Filled = bl;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public TrackObject(Construction construction, ConstructionObject constructionObject, ConstructionObject[] constructionObjectArray, int n, ConstructionObject constructionObject2, PointObject pointObject) {
        super(construction);
        this.P = constructionObject;
        this.PN = n;
        for (int i = 0; i < this.PN; ++i) {
            this.PO[i] = constructionObjectArray[i];
        }
        this.O = constructionObject2;
        this.PM = pointObject;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Track";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (this.PM != null) {
            this.setText(TrackObject.text3(Zirkel.name("text.track"), this.P.getName(), this.PM.getName(), this.O.getName()));
        } else {
            this.setText(TrackObject.text2(Zirkel.name("text.trackof"), this.P.getName(), this.O.getName()));
        }
    }

    public void validate() {
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        double d5;
        Coordinates coordinates;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        Enumeration enumeration = this.V.elements();
        if (!this.Discrete && this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
            PolygonDrawer polygonDrawer = new PolygonDrawer(myGraphics, this);
            polygonDrawer.useAsMarker();
            if (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d5 = zirkelCanvas.col(coordinates.X);
                d4 = zirkelCanvas.row(coordinates.Y);
                while (enumeration.hasMoreElements()) {
                    coordinates = (Coordinates)enumeration.nextElement();
                    d3 = zirkelCanvas.col(coordinates.X);
                    d2 = zirkelCanvas.row(coordinates.Y);
                    if (Math.abs(d5 - d3) < 100.0 && Math.abs(d4 - d2) < 100.0) {
                        polygonDrawer.drawTo(d3, d2);
                    } else {
                        if (this.isFilled()) {
                            this.PF.finishPolygon();
                        }
                        polygonDrawer.finishPolygon();
                    }
                    d5 = d3;
                    d4 = d2;
                }
                polygonDrawer.finishPolygon();
            }
        }
        enumeration = this.V.elements();
        if (this.indicated()) {
            boolean bl = this.P.indicated();
            this.P.setIndicated(true);
            myGraphics.setColor(this.P);
            this.P.setIndicated(bl);
        } else {
            myGraphics.setColor(this);
        }
        if (this.Discrete) {
            int n = this.getColorIndex();
            int n2 = this.getColorType();
            if (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d5 = zirkelCanvas.col(coordinates.X);
                d4 = zirkelCanvas.row(coordinates.Y);
                while (enumeration.hasMoreElements()) {
                    coordinates = (Coordinates)enumeration.nextElement();
                    d3 = zirkelCanvas.col(coordinates.X);
                    d2 = zirkelCanvas.row(coordinates.Y);
                    if (Math.abs(d5 - d3) < 100.0 && Math.abs(d4 - d2) < 100.0) {
                        if (this.isFilled()) {
                            this.PF.drawTo(d3, d2);
                        }
                    } else if (this.isFilled()) {
                        this.PF.finishPolygon();
                    }
                    if (coordinates.Color >= 0) {
                        this.setColor(coordinates.Color);
                    }
                    if (coordinates.Thickness >= 0) {
                        this.setColorType(coordinates.Thickness);
                    }
                    PointObject.drawPoint(myGraphics, zirkelCanvas, this, coordinates.X, coordinates.Y, this.Type);
                    this.setColor(n);
                    this.setColorType(n2);
                    d5 = d3;
                    d4 = d2;
                }
                if (this.isFilled()) {
                    this.PF.finishPolygon();
                }
            }
            for (int i = 0; i < this.PN; ++i) {
                enumeration = this.VO[i].elements();
                myGraphics.setColor(this.PO[i]);
                if (!enumeration.hasMoreElements()) continue;
                coordinates = (Coordinates)enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    coordinates = (Coordinates)enumeration.nextElement();
                    if (coordinates.Color >= 0) {
                        this.setColor(coordinates.Color);
                    }
                    if (coordinates.Thickness >= 0) {
                        this.setColorType(coordinates.Thickness);
                    }
                    PointObject.drawPoint(myGraphics, zirkelCanvas, this, coordinates.X, coordinates.Y, this.Type);
                    this.setColor(n);
                    this.setColorType(n2);
                }
            }
        } else {
            PolygonDrawer polygonDrawer = new PolygonDrawer(myGraphics, this);
            if (this.isFilled()) {
                if (this.PF == null) {
                    this.PF = new PolygonFiller(myGraphics, this);
                }
                this.PF.start();
                this.PF.setGraphics(myGraphics);
            }
            if (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                d5 = zirkelCanvas.col(coordinates.X);
                d4 = zirkelCanvas.row(coordinates.Y);
                while (enumeration.hasMoreElements()) {
                    coordinates = (Coordinates)enumeration.nextElement();
                    d3 = zirkelCanvas.col(coordinates.X);
                    d2 = zirkelCanvas.row(coordinates.Y);
                    if (Math.abs(d5 - d3) < 100.0 && Math.abs(d4 - d2) < 100.0) {
                        if (this.isFilled()) {
                            this.PF.drawTo(d3, d2);
                        }
                        polygonDrawer.drawTo(d3, d2);
                    } else {
                        if (this.isFilled()) {
                            this.PF.finishPolygon();
                        }
                        polygonDrawer.finishPolygon();
                    }
                    d5 = d3;
                    d4 = d2;
                }
                if (this.isFilled()) {
                    this.PF.finishPolygon();
                }
                polygonDrawer.finishPolygon();
            }
            for (int i = 0; i < this.PN; ++i) {
                enumeration = this.VO[i].elements();
                myGraphics.setColor(this.PO[i]);
                polygonDrawer = new PolygonDrawer(myGraphics, this.PO[i]);
                if (enumeration.hasMoreElements()) {
                    coordinates = (Coordinates)enumeration.nextElement();
                    d5 = zirkelCanvas.col(coordinates.X);
                    d4 = zirkelCanvas.row(coordinates.Y);
                    while (enumeration.hasMoreElements()) {
                        coordinates = (Coordinates)enumeration.nextElement();
                        d3 = zirkelCanvas.col(coordinates.X);
                        d2 = zirkelCanvas.row(coordinates.Y);
                        if (Math.abs(d5 - d3) < 100.0 && Math.abs(d4 - d2) < 100.0) {
                            polygonDrawer.drawTo(d3, d2);
                        } else {
                            polygonDrawer.finishPolygon();
                        }
                        d5 = d3;
                        d4 = d2;
                    }
                }
                polygonDrawer.finishPolygon();
            }
        }
    }

    public double getSum(double d2, double d3) throws ConstructionException {
        if (!this.Valid) {
            throw new ConstructionException("");
        }
        double d4 = 0.0;
        boolean bl = false;
        double d5 = 0.0;
        double d6 = 0.0;
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            if (bl) {
                d4 += (-(coordinates.X - d2) * (d6 - d3) + (coordinates.Y - d3) * (d5 - d2)) / 2.0;
            }
            d5 = coordinates.X;
            d6 = coordinates.Y;
            bl = true;
        }
        return d4;
    }

    public double getSum() throws ConstructionException {
        if (!this.Valid) {
            throw new ConstructionException("");
        }
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            if (bl) {
                d2 += (-(coordinates.X - d5) * (d4 - d6) + (coordinates.Y - d6) * (d3 - d5)) / 2.0;
            } else {
                d5 = coordinates.X;
                d6 = coordinates.Y;
            }
            d3 = coordinates.X;
            d4 = coordinates.Y;
            bl = true;
        }
        return d2;
    }

    public double getLength() throws ConstructionException {
        if (!this.Valid) {
            throw new ConstructionException("");
        }
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            if (bl) {
                d2 += Math.sqrt((coordinates.X - d3) * (coordinates.X - d3) + (coordinates.Y - d4) * (coordinates.Y - d4));
            }
            d3 = coordinates.X;
            d4 = coordinates.Y;
            bl = true;
        }
        return d2;
    }

    public void printArgs(XmlWriter xmlWriter) {
        super.printArgs(xmlWriter);
        if (this.PM != null) {
            xmlWriter.printArg("point", this.PM.getName());
        }
        xmlWriter.printArg("on", this.O.getName());
        xmlWriter.printArg("track", this.P.getName());
        xmlWriter.printArg("dmin", "" + this.DMin);
        for (int i = 0; i < this.PN; ++i) {
            xmlWriter.printArg("track" + i, this.PO[i].getName());
        }
        if (this.Filled) {
            xmlWriter.printArg("filled", "true");
        }
        if (this.Fixed) {
            xmlWriter.printArg("fixed", "true");
        }
        if (this.Discrete) {
            xmlWriter.printArg("discrete", "true");
        }
        this.printType(xmlWriter);
    }

    public void printType(XmlWriter xmlWriter) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xmlWriter.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xmlWriter.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xmlWriter.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xmlWriter.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xmlWriter.printArg("shape", "dcross");
                }
            }
        }
    }

    public Enumeration depending() {
        super.depending();
        if (this.PM != null) {
            DL.add(this.PM);
        }
        DL.add(this.O);
        DL.add(this.P);
        for (int i = 0; i < this.PN; ++i) {
            DL.add(this.PO[i]);
        }
        return DL.elements();
    }

    public boolean equals(ConstructionObject constructionObject) {
        return false;
    }

    public void translate() {
        if (this.PM != null) {
            this.PM = (PointObject)this.PM.getTranslation();
        }
        this.O = this.O.getTranslation();
        this.P = this.P.getTranslation();
    }

    public boolean maybeTransparent() {
        return false;
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        int n3 = (int)zirkelCanvas.selectionSize();
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            double d2 = zirkelCanvas.col(coordinates.X);
            double d3 = zirkelCanvas.row(coordinates.Y);
            if (!(Math.max(Math.abs(d2 - (double)n), Math.abs(d3 - (double)n2)) < (double)n3)) continue;
            return true;
        }
        return false;
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    double mod(double d2) {
        if (d2 >= Math.PI) {
            return d2 - Math.PI * 2;
        }
        if (d2 < -Math.PI) {
            return d2 + Math.PI * 2;
        }
        return d2;
    }

    public synchronized void docompute(ZirkelCanvas zirkelCanvas) {
        block80: {
            boolean bl;
            Object object;
            double d2;
            block81: {
                boolean bl2;
                Object object2;
                double d3;
                block79: {
                    boolean bl3;
                    Object object3;
                    double d4;
                    double d5;
                    double d6;
                    this.V = new Vector();
                    for (int i = 0; i < this.PN; ++i) {
                        this.VO[i] = new Vector();
                    }
                    if (!(this.O instanceof PrimitiveCircleObject)) break block79;
                    zirkelCanvas.getConstruction().shouldSwitch(false);
                    PrimitiveCircleObject primitiveCircleObject = (PrimitiveCircleObject)this.O;
                    double d7 = primitiveCircleObject.getX();
                    double d8 = primitiveCircleObject.getY();
                    double d9 = primitiveCircleObject.getR();
                    this.PM.project(primitiveCircleObject);
                    double d10 = 0.0;
                    double d11 = 0.0;
                    double d12 = 0.0;
                    double d13 = 0.0;
                    double d14 = 0.5;
                    boolean bl4 = false;
                    if (primitiveCircleObject.hasRange()) {
                        bl4 = true;
                        d6 = primitiveCircleObject.getA1();
                        d5 = primitiveCircleObject.getA2();
                        for (d4 = d5 - d6; d4 < 0.0; d4 += Math.PI * 2) {
                        }
                        while (d4 >= Math.PI * 2) {
                            d4 -= Math.PI * 2;
                        }
                        d10 = d12 = -d4 / 2.0;
                        d11 = d4 / 2.0;
                        d13 = (d6 + d5) / 2.0;
                    } else {
                        d12 = -3.141278494324434;
                        d10 = -3.141278494324434;
                        d11 = 3.141278494324434;
                    }
                    d6 = d12;
                    this.PM.move(d7 + d9 * Math.cos(d13 + d6), d8 + d9 * Math.sin(d13 + d6));
                    this.PM.project(primitiveCircleObject);
                    zirkelCanvas.getConstruction().validate(this, this.PM);
                    zirkelCanvas.resetSum();
                    d5 = 0.0;
                    d4 = 0.0;
                    boolean bl5 = false;
                    if (this.P.valid()) {
                        zirkelCanvas.getConstruction().shouldSwitch(true);
                        if (this.P instanceof PointObject) {
                            object3 = (PointObject)this.P;
                            d5 = ((PointObject)object3).getX();
                            d4 = ((PointObject)object3).getY();
                            this.addCoordinates(this.V, this.P, d5, d4);
                            bl5 = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            object3 = (PrimitiveLineObject)this.P;
                            this.X = ((PrimitiveLineObject)object3).getX();
                            this.Y = ((PrimitiveLineObject)object3).getY();
                            this.DX = ((PrimitiveLineObject)object3).getDX();
                            this.DY = ((PrimitiveLineObject)object3).getDY();
                            bl5 = true;
                        }
                    }
                    object3 = new boolean[this.PMax];
                    for (int i = 0; i < this.PN; ++i) {
                        object3[i] = false;
                    }
                    long l = System.currentTimeMillis();
                    this.addSecondary((boolean[])object3);
                    double d15 = this.DMin;
                    if (this.da < 1.0E-10 || this.da > zirkelCanvas.dx(1)) {
                        this.da = zirkelCanvas.dx(1) / 10.0;
                    }
                    double d16 = d6;
                    do {
                        d6 += this.da;
                        bl3 = false;
                        if ((!bl5 || bl4) && d6 >= d11) {
                            d6 = d11;
                            bl3 = true;
                        } else if ((!bl5 || bl4) && d6 <= d10) {
                            d6 = d10;
                            bl3 = true;
                        } else if (bl5 && this.da > 0.0 && this.mod(d16 - d12) < 0.0 && this.mod(d6 - d12) >= 0.0 && !zirkelCanvas.getConstruction().haveSwitched()) {
                            bl3 = true;
                            d6 = d12;
                        }
                        d16 = d6;
                        this.PM.move(d7 + d9 * Math.cos(d13 + d6), d8 + d9 * Math.sin(d13 + d6));
                        this.PM.project(primitiveCircleObject);
                        zirkelCanvas.getConstruction().validate(this, this.PM);
                        if (this.P.valid()) {
                            boolean bl6;
                            double d17;
                            if (!bl5) {
                                zirkelCanvas.getConstruction().shouldSwitch(true);
                                d12 = d6;
                            }
                            double d18 = 0.0;
                            double d19 = 0.0;
                            boolean bl7 = false;
                            if (this.P instanceof PointObject) {
                                PointObject pointObject = (PointObject)this.P;
                                d18 = pointObject.getX();
                                d19 = pointObject.getY();
                                bl7 = true;
                            } else if (this.P instanceof PrimitiveLineObject) {
                                PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.P;
                                if (!bl5) {
                                    this.X = primitiveLineObject.getX();
                                    this.Y = primitiveLineObject.getY();
                                    this.DX = primitiveLineObject.getDX();
                                    this.DY = primitiveLineObject.getDY();
                                } else {
                                    double d20;
                                    double d21 = primitiveLineObject.getX();
                                    d17 = primitiveLineObject.getY();
                                    double d22 = primitiveLineObject.getDX();
                                    double d23 = d22 * this.DY - (d20 = primitiveLineObject.getDY()) * this.DX;
                                    if (Math.sqrt(Math.abs(d23)) > 1.0E-9) {
                                        double d24 = (-(this.X - d21) * this.DY + this.DX * (this.Y - d17)) / -d23;
                                        d18 = d21 + d24 * d22;
                                        d19 = d17 + d24 * d20;
                                        bl7 = true;
                                    }
                                    this.X = d21;
                                    this.Y = d17;
                                    this.DX = d22;
                                    this.DY = d20;
                                }
                            }
                            double d25 = zirkelCanvas.dCenter(d18, d19);
                            boolean bl8 = bl6 = (int)zirkelCanvas.col(d5) != (int)zirkelCanvas.col(d18) || (int)zirkelCanvas.row(d4) != (int)zirkelCanvas.row(d19);
                            if (bl7 && bl6) {
                                this.addCoordinates(this.V, this.P, d18, d19);
                            }
                            d17 = Math.abs(d18 - d5) + Math.abs(d19 - d4);
                            this.da = this.updateDA(this.da, bl7, d25, d17, d15, d14, zirkelCanvas);
                            d5 = d18;
                            d4 = d19;
                            bl5 = true;
                        } else if (bl5) {
                            this.da = -this.da;
                        }
                        this.addSecondary((boolean[])object3);
                    } while (!bl3 && System.currentTimeMillis() - l <= 1000L);
                    break block80;
                }
                if (!(this.O instanceof PrimitiveLineObject)) break block81;
                zirkelCanvas.getConstruction().shouldSwitch(false);
                PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.O;
                this.PM.project(primitiveLineObject);
                double d26 = primitiveLineObject.getX();
                double d27 = primitiveLineObject.getY();
                double d28 = primitiveLineObject.getDX();
                double d29 = primitiveLineObject.getDY();
                double d30 = 0.0;
                double d31 = 0.0;
                double d32 = 0.0;
                double d33 = 0.5;
                boolean bl9 = false;
                if (primitiveLineObject instanceof RayObject) {
                    d32 = 0.0;
                    d30 = 0.0;
                    d31 = 3.141278494324434;
                    bl9 = true;
                } else if (primitiveLineObject instanceof SegmentObject) {
                    d32 = 0.0;
                    d30 = 0.0;
                    d3 = ((SegmentObject)primitiveLineObject).getLength();
                    d33 = d3 / 20.0;
                    d31 = Math.atan(d3) * 2.0;
                    bl9 = true;
                } else {
                    d32 = -3.1415612376632573;
                    d30 = -3.1415612376632573;
                    d31 = 3.141278494324434;
                }
                d3 = d32;
                double d34 = Math.tan(this.mod(d3) / 2.0);
                this.PM.move(d26 + d34 * d28, d27 + d34 * d29);
                this.PM.project(primitiveLineObject);
                zirkelCanvas.getConstruction().validate(this, this.PM);
                zirkelCanvas.resetSum();
                double d35 = 0.0;
                double d36 = 0.0;
                boolean bl10 = false;
                if (this.P.valid()) {
                    zirkelCanvas.getConstruction().shouldSwitch(true);
                    if (this.P instanceof PointObject) {
                        object2 = (PointObject)this.P;
                        d35 = ((PointObject)object2).getX();
                        d36 = ((PointObject)object2).getY();
                        this.addCoordinates(this.V, this.P, d35, d36);
                        bl10 = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        object2 = (PrimitiveLineObject)this.P;
                        this.X = ((PrimitiveLineObject)object2).getX();
                        this.Y = ((PrimitiveLineObject)object2).getY();
                        this.DX = ((PrimitiveLineObject)object2).getDX();
                        this.DY = ((PrimitiveLineObject)object2).getDY();
                        bl10 = true;
                    }
                }
                object2 = new boolean[this.PMax];
                for (int i = 0; i < this.PN; ++i) {
                    object2[i] = false;
                }
                long l = System.currentTimeMillis();
                this.addSecondary((boolean[])object2);
                double d37 = this.DMin;
                if (this.da < 1.0E-10 || this.da > zirkelCanvas.dx(1)) {
                    this.da = zirkelCanvas.dx(1) / 10.0;
                }
                double d38 = d3;
                do {
                    d3 += this.da;
                    bl2 = false;
                    if ((!bl10 || bl9) && d3 >= d31) {
                        d3 = d31;
                        bl2 = true;
                    } else if ((!bl10 || bl9) && d3 <= d30) {
                        d3 = d30;
                        bl2 = true;
                    } else if (bl10 && this.da > 0.0 && this.mod(d38 - d32) < 0.0 && this.mod(d3 - d32) >= 0.0 && !zirkelCanvas.getConstruction().haveSwitched()) {
                        bl2 = true;
                        d3 = d32;
                    }
                    d38 = d3;
                    d34 = Math.tan(this.mod(d3) / 2.0);
                    this.PM.move(d26 + d34 * d28, d27 + d34 * d29);
                    this.PM.project(primitiveLineObject);
                    zirkelCanvas.getConstruction().validate(this, this.PM);
                    if (this.P.valid()) {
                        boolean bl11;
                        double d39;
                        if (!bl10) {
                            zirkelCanvas.getConstruction().shouldSwitch(true);
                            d32 = d3;
                        }
                        double d40 = 0.0;
                        double d41 = 0.0;
                        boolean bl12 = false;
                        if (this.P instanceof PointObject) {
                            PointObject pointObject = (PointObject)this.P;
                            d40 = pointObject.getX();
                            d41 = pointObject.getY();
                            bl12 = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            PrimitiveLineObject primitiveLineObject2 = (PrimitiveLineObject)this.P;
                            if (!bl10) {
                                this.X = primitiveLineObject2.getX();
                                this.Y = primitiveLineObject2.getY();
                                this.DX = primitiveLineObject2.getDX();
                                this.DY = primitiveLineObject2.getDY();
                            } else {
                                double d42;
                                double d43 = primitiveLineObject2.getX();
                                d39 = primitiveLineObject2.getY();
                                double d44 = primitiveLineObject2.getDX();
                                double d45 = d44 * this.DY - (d42 = primitiveLineObject2.getDY()) * this.DX;
                                if (Math.sqrt(Math.abs(d45)) > 1.0E-9) {
                                    double d46 = (-(this.X - d43) * this.DY + this.DX * (this.Y - d39)) / -d45;
                                    d40 = d43 + d46 * d44;
                                    d41 = d39 + d46 * d42;
                                    bl12 = true;
                                }
                                this.X = d43;
                                this.Y = d39;
                                this.DX = d44;
                                this.DY = d42;
                            }
                        }
                        double d47 = zirkelCanvas.dCenter(d40, d41);
                        boolean bl13 = bl11 = (int)zirkelCanvas.col(d35) != (int)zirkelCanvas.col(d40) || (int)zirkelCanvas.row(d36) != (int)zirkelCanvas.row(d41);
                        if (bl12 && bl11) {
                            this.addCoordinates(this.V, this.P, d40, d41);
                        }
                        d39 = Math.abs(d40 - d35) + Math.abs(d41 - d36);
                        this.da = this.updateDA(this.da, bl12, d47, d39, d37, d33, zirkelCanvas);
                        d35 = d40;
                        d36 = d41;
                        bl10 = true;
                    } else if (bl10) {
                        this.da = -this.da;
                    }
                    this.addSecondary((boolean[])object2);
                } while (!bl2 && System.currentTimeMillis() - l <= 1000L);
                break block80;
            }
            if (!(this.O instanceof ExpressionObject)) break block80;
            zirkelCanvas.getConstruction().shouldSwitch(false);
            ExpressionObject expressionObject = (ExpressionObject)this.O;
            if (!expressionObject.isSlider()) {
                return;
            }
            double d48 = 0.0;
            double d49 = 0.0;
            double d50 = 0.0;
            double d51 = 0.5;
            boolean bl14 = false;
            d50 = 0.0;
            d48 = 0.0;
            double d52 = 1.0;
            d51 = d52 / 20.0;
            d49 = d52;
            bl14 = true;
            double d53 = d2 = d50;
            expressionObject.setSliderPosition(0.0);
            zirkelCanvas.getConstruction().validate(this.P, null);
            zirkelCanvas.resetSum();
            double d54 = 0.0;
            double d55 = 0.0;
            boolean bl15 = false;
            if (this.P.valid()) {
                zirkelCanvas.getConstruction().shouldSwitch(true);
                if (this.P instanceof PointObject) {
                    object = (PointObject)this.P;
                    d54 = ((PointObject)object).getX();
                    d55 = ((PointObject)object).getY();
                    this.addCoordinates(this.V, this.P, d54, d55);
                    bl15 = true;
                } else if (this.P instanceof PrimitiveLineObject) {
                    object = (PrimitiveLineObject)this.P;
                    this.X = ((PrimitiveLineObject)object).getX();
                    this.Y = ((PrimitiveLineObject)object).getY();
                    this.DX = ((PrimitiveLineObject)object).getDX();
                    this.DY = ((PrimitiveLineObject)object).getDY();
                    bl15 = true;
                }
            }
            object = new boolean[this.PMax];
            for (int i = 0; i < this.PN; ++i) {
                object[i] = false;
            }
            long l = System.currentTimeMillis();
            this.addSecondary((boolean[])object);
            double d56 = this.DMin;
            if (this.da < 1.0E-10 || this.da > zirkelCanvas.dx(1)) {
                this.da = zirkelCanvas.dx(1) / 10.0;
            }
            double d57 = d2;
            double d58 = 0.0;
            double d59 = 0.0;
            do {
                d2 += this.da;
                bl = false;
                if ((!bl15 || bl14) && d2 >= d49) {
                    d2 = d49;
                    bl = true;
                } else if ((!bl15 || bl14) && d2 <= d48) {
                    d2 = d48;
                    bl = true;
                } else if (bl15 && this.da > 0.0 && this.mod(d57 - d50) < 0.0 && this.mod(d2 - d50) >= 0.0 && !zirkelCanvas.getConstruction().haveSwitched()) {
                    bl = true;
                    d2 = d50;
                }
                d57 = d2;
                d53 = d2;
                expressionObject.setSliderPosition(d53);
                zirkelCanvas.getConstruction().validate(this.P, null);
                if (this.P.valid()) {
                    boolean bl16;
                    double d60;
                    if (!bl15) {
                        zirkelCanvas.getConstruction().shouldSwitch(true);
                        d50 = d2;
                    }
                    boolean bl17 = false;
                    if (this.P instanceof PointObject) {
                        PointObject pointObject = (PointObject)this.P;
                        d58 = pointObject.getX();
                        d59 = pointObject.getY();
                        bl17 = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.P;
                        if (!bl15) {
                            this.X = primitiveLineObject.getX();
                            this.Y = primitiveLineObject.getY();
                            this.DX = primitiveLineObject.getDX();
                            this.DY = primitiveLineObject.getDY();
                        } else {
                            double d61;
                            double d62 = primitiveLineObject.getX();
                            d60 = primitiveLineObject.getY();
                            double d63 = primitiveLineObject.getDX();
                            double d64 = d63 * this.DY - (d61 = primitiveLineObject.getDY()) * this.DX;
                            if (Math.sqrt(Math.abs(d64)) > 1.0E-9) {
                                double d65 = (-(this.X - d62) * this.DY + this.DX * (this.Y - d60)) / -d64;
                                d58 = d62 + d65 * d63;
                                d59 = d60 + d65 * d61;
                                bl17 = true;
                            }
                            this.X = d62;
                            this.Y = d60;
                            this.DX = d63;
                            this.DY = d61;
                        }
                    }
                    double d66 = zirkelCanvas.dCenter(d58, d59);
                    boolean bl18 = bl16 = (int)zirkelCanvas.col(d54) != (int)zirkelCanvas.col(d58) || (int)zirkelCanvas.row(d55) != (int)zirkelCanvas.row(d59);
                    if (bl17 && bl16) {
                        this.addCoordinates(this.V, this.P, d58, d59);
                    }
                    d60 = Math.abs(d58 - d54) + Math.abs(d59 - d55);
                    this.da = this.updateDA(this.da, bl17, d66, d60, d56, d51, zirkelCanvas);
                    d54 = d58;
                    d55 = d59;
                    bl15 = true;
                } else if (bl15) {
                    this.addCoordinates(this.V, this.P, d58, d59);
                    this.da = -this.da;
                }
                this.addSecondary((boolean[])object);
            } while (!bl && System.currentTimeMillis() - l <= 1000L);
        }
    }

    public synchronized void compute(ZirkelCanvas zirkelCanvas) {
        if (this.Fixed && !this.StartFix) {
            return;
        }
        this.StartFix = false;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.PM != null) {
            d2 = this.PM.getX();
            d3 = this.PM.getY();
        } else if (this.O instanceof ExpressionObject && ((ExpressionObject)this.O).isSlider()) {
            d2 = ((ExpressionObject)this.O).getSliderPosition();
        }
        zirkelCanvas.getConstruction().clearSwitches();
        zirkelCanvas.getConstruction().shouldSwitch(true);
        this.DontProject = true;
        this.docompute(zirkelCanvas);
        this.DontProject = false;
        zirkelCanvas.getConstruction().shouldSwitch(false);
        zirkelCanvas.getConstruction().clearSwitches();
        if (this.PM != null) {
            this.PM.move(d2, d3);
        } else if (this.O instanceof ExpressionObject && ((ExpressionObject)this.O).isSlider()) {
            ((ExpressionObject)this.O).setSliderPosition(d2);
        }
        Enumeration enumeration = this.V.elements();
        if (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            d2 = coordinates.X;
            d3 = coordinates.Y;
            double d4 = zirkelCanvas.col(coordinates.X);
            double d5 = zirkelCanvas.row(coordinates.Y);
            while (enumeration.hasMoreElements()) {
                coordinates = (Coordinates)enumeration.nextElement();
                double d6 = zirkelCanvas.col(coordinates.X);
                double d7 = zirkelCanvas.row(coordinates.Y);
                coordinates.flag = Math.abs(d6 - d4) < 100.0 && Math.abs(d7 - d5) < 100.0;
                d5 = d7;
                d4 = d6;
            }
        }
        zirkelCanvas.dovalidate();
    }

    public void addSecondary(boolean[] blArray) {
        for (int i = 0; i < this.PN; ++i) {
            double d2;
            ConstructionObject constructionObject;
            if (!this.PO[i].valid()) continue;
            if (this.PO[i] instanceof PointObject) {
                constructionObject = (PointObject)this.PO[i];
                this.addCoordinates(this.VO[i], constructionObject, ((PointObject)constructionObject).getX(), ((PointObject)constructionObject).getY());
                this.VO[i].addElement(new Coordinates(((PointObject)constructionObject).getX(), ((PointObject)constructionObject).getY()));
                continue;
            }
            if (!(this.PO[i] instanceof PrimitiveLineObject)) continue;
            constructionObject = (PrimitiveLineObject)this.PO[i];
            if (!blArray[i]) {
                this.XO[i] = ((PrimitiveLineObject)constructionObject).getX();
                this.YO[i] = ((PrimitiveLineObject)constructionObject).getY();
                this.DXO[i] = ((PrimitiveLineObject)constructionObject).getDX();
                this.DYO[i] = ((PrimitiveLineObject)constructionObject).getDY();
                blArray[i] = true;
                continue;
            }
            double d3 = ((PrimitiveLineObject)constructionObject).getX();
            double d4 = ((PrimitiveLineObject)constructionObject).getY();
            double d5 = ((PrimitiveLineObject)constructionObject).getDX();
            double d6 = d5 * this.DYO[i] - (d2 = ((PrimitiveLineObject)constructionObject).getDY()) * this.DXO[i];
            if (!(Math.sqrt(Math.abs(d6)) > 1.0E-9)) continue;
            double d7 = (-(this.XO[i] - d3) * this.DYO[i] + this.DXO[i] * (this.YO[i] - d4)) / -d6;
            this.XO[i] = d3;
            this.YO[i] = d4;
            this.DXO[i] = d5;
            this.DYO[i] = d2;
            this.addCoordinates(this.VO[i], this.PO[i], d3 + d7 * d5, d4 + d7 * d2);
        }
    }

    public void addCoordinates(Vector vector, ConstructionObject constructionObject, double d2, double d3) {
        Coordinates coordinates = new Coordinates(d2, d3);
        if (this.Discrete && constructionObject instanceof PointObject) {
            coordinates.Color = constructionObject.getColorIndex();
            coordinates.Thickness = constructionObject.getColorType();
        }
        vector.addElement(coordinates);
    }

    public double updateDA(double d2, boolean bl, double d3, double d4, double d5, double d6, ZirkelCanvas zirkelCanvas) {
        if (this.V.size() > 0 && bl) {
            if (d3 < 1.2) {
                if (d4 > zirkelCanvas.dx(this.StepSize)) {
                    d2 /= 2.0;
                } else if (d4 < zirkelCanvas.dx(this.StepSize / 2.0)) {
                    d2 *= 2.0;
                }
                if (d2 > 0.0 && d2 < d5) {
                    d2 = d5;
                } else if (d2 < 0.0 && d2 > -d5) {
                    d2 = -d5;
                }
                if (d2 > d6) {
                    d2 = d6;
                } else if (d2 < -d6) {
                    d2 = -d6;
                }
            } else {
                if (d4 > zirkelCanvas.dx(this.StepSize * 10.0)) {
                    d2 /= 2.0;
                } else if (d4 < zirkelCanvas.dx(this.StepSize * 5.0)) {
                    d2 *= 2.0;
                }
                if (d2 > 0.0 && d2 < d5) {
                    d2 = d5;
                } else if (d2 < 0.0 && d2 > -d5) {
                    d2 = -d5;
                }
                if (d2 > d6) {
                    d2 = d6;
                } else if (d2 < -d6) {
                    d2 = -d6;
                }
            }
        }
        return d2;
    }

    public boolean hasUnit() {
        return false;
    }

    public synchronized void project(PointObject pointObject) {
        if (this.DontProject) {
            return;
        }
        Enumeration enumeration = this.V.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Coordinates coordinates = (Coordinates)enumeration.nextElement();
            double d7 = coordinates.X;
            double d8 = coordinates.Y;
            if (!bl) {
                d6 = Math.sqrt((pointObject.getX() - d7) * (pointObject.getX() - d7) + (pointObject.getY() - d8) * (pointObject.getY() - d8));
                d4 = d2 = d7;
                d5 = d3 = d8;
                bl = true;
                continue;
            }
            if (coordinates.flag) {
                double d9;
                double d10 = (d7 - d4) * (d7 - d4) + (d8 - d5) * (d8 - d5);
                if (d10 < 1.0E-10) {
                    d10 = 1.0E-10;
                }
                if ((d9 = (pointObject.getX() - d4) * (d7 - d4) + (pointObject.getY() - d5) * (d8 - d5)) < 0.0) {
                    d9 = 0.0;
                }
                if (d9 > d10) {
                    d9 = d10;
                }
                double d11 = d4 + d9 / d10 * (d7 - d4);
                double d12 = d5 + d9 / d10 * (d8 - d5);
                double d13 = Math.sqrt((pointObject.getX() - d11) * (pointObject.getX() - d11) + (pointObject.getY() - d12) * (pointObject.getY() - d12));
                if (d13 < d6) {
                    d6 = d13;
                    d2 = d11;
                    d3 = d12;
                }
            }
            d4 = d7;
            d5 = d8;
        }
        if (bl) {
            pointObject.setXY(d2, d3);
            pointObject.Valid = true;
        } else {
            pointObject.Valid = false;
        }
    }

    public String getDisplayValue() {
        try {
            return "" + this.getSum();
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public void project(PointObject pointObject, double d2) {
        this.project(pointObject);
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        TrackEditDialog trackEditDialog = new TrackEditDialog(zirkelCanvas, this);
        trackEditDialog.setVisible(true);
        zirkelCanvas.repaint();
        this.validate();
        if (trackEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public boolean canDisplayName() {
        return false;
    }

    public boolean isFixed() {
        return this.Fixed;
    }

    public void setFixed(boolean bl) {
        this.Fixed = bl;
        if (this.Fixed) {
            this.StartFix = true;
        }
    }

    public void setDMin(double d2) {
        this.DMin = d2;
    }

    public double getDMin() {
        return this.DMin;
    }

    public int getType() {
        return this.Type;
    }

    public void setType(int n) {
        this.Type = n;
    }

    public boolean isDiscrete() {
        return this.Discrete;
    }

    public void setDiscrete(boolean bl) {
        this.Discrete = bl;
    }

    public boolean canInteresectWith(ConstructionObject constructionObject) {
        return true;
    }
}

