#pragma once
#include "BuiltIn.h"
#include "Code/RefSource.h"

namespace storm {
	STORM_PKG(core.asm);

	/**
	 * A RefSource that refers to a built-in source.
	 */
	class BuiltInSource : public code::RefSource {
		STORM_CLASS;
	public:
		// Create.
		STORM_CTOR BuiltInSource(builtin::BuiltIn ref);
		BuiltInSource(builtin::BuiltIn ref, const void *ptr);

		// Get the reference.
		builtin::BuiltIn which() const { return myRef; }

		// Get the title.
		virtual Str *STORM_FN title() const;

	private:
		// The reference stored here.
		builtin::BuiltIn myRef;
	};

}
