# Modern (Sternenkarten)

## Introduction

### Figures in the sky

People have probably always looked up to the stars. Some of them might wonder, what those little dots of light meant, up there. In their thoughts they connected the stars to form images and thus created their very own constellations.

Each culture had different ideas about what was going on in the night sky. And so each culture painted different figures in the sky. In the western world, a sky culture emerged that, along with other influences, was strongly influenced by Greek mythology. This western sky culture established itself as the standard in modern astronomy.

## Description

### Division of the sky

In 1922 the International Astronomical Union began to define this standard more precisely. 88 constellations were selected that covered the entire sky. The names and the boundaries of the 88 constellations were made binding, but not the historically created shapes of the constellations themselves.

### From image to constellation

Greek mythology is rich in stories about gods and heroes. These stories have not been forgotten until today, among other things through the works of Hesiod and Homer. Atlases were created that showed the starry sky, illustrated with figures from Greek mythology. The stars in these figures were connected by lines, creating constellations. It was clear what these constellations were supposed to represent. But if you looked at the lines alone without the corresponding figures, the connection to the constellation was often no longer immediately understandable

### The stars, a new way to see them

The children's book author H. A. Rey recognized this dilemma. He wondered why it had never occurred to anyone to draw the constellations so, that their shape made sense. He connected stars with lines and thus painted his own constellations. These constellations were intuitively recognizable, because the constellation lines themselves painted the images. H. A. Rey published his work under the title "The Stars. A New Way To See Them".

### The sky culture sternenkarten.com

The sky culture sternenkarten.com is based on the idea of H. A. Rey to paint constellations in such a way, that they can be recognized intuitively. Some of the constellations, it contains, are more or less similar to those of H. A. Rey, others are based on the western standard sky culture. And still others have been completely redesigned.

As far as possible, the following points have been implemented

 - Clear simple shapes
 - Intuitive recognizability
 - Recognizing is more important than the inclusion of many stars
 - Fainter stars are not considered because of the light pollution in the modern world
 - Triangles are easy to spot. That is why the characters wear triangular hats

The following special features were built into the constellation culture:

 - The constellation Lynx uses a star from the constellation Great Bear
 - The constellation Snake is not divided into two parts. A complete snake is drawn
 - The star Alpheratz belongs to both the constellation Pegasus and the constellation Andromeda

### History of the sky culture sternenkarten.com

 - 2015: Photographing the night sky that can be seen from Germany.
 - 2015: Development of the sky culture sternenkarten.com
 - 2015: Drawing the constellations in the photos
 - 2016: Publication of the sky culture on the Internet
 - 2020: Adding to Kstars
 - 2021: Expanding with the constellations of the southern hemisphere

Documentation: [Meine kleinen Sternenkarten](https://sternenkarten.com/die-sternbilder/)

## References

 - [#1]: Kunitzsch, P.; Smart T. (2006). "A Dictionary of Modern star Names: A Short Guide to 254 Star Names and Their Derivations" (2nd rev. ed.). Cambridge, MA: Sky Pub. ISBN 978-1-931559-44-7.
 - [#2]: Allen, R. H. (1963). "Star Names: Their Lore and Meaning" (rep. ed.). New York, NY: Dover Publications Inc. ISBN 0-486-21079-0.
 - [#3]: [2000, A&AS, 143, 9, "The SIMBAD astronomical database", Wenger et al.](http://adsabs.harvard.edu/abs/2000A%26AS..143....9W)
 - [#4]: [Final Results of NameExoWorlds Public Vote Released](http://www.iau.org/news/pressreleases/detail/iau1514/)
 - [#5]: [STARS by Jim Kaler, Prof. Emeritus of Astronomy, University of Illinois](http://stars.astro.illinois.edu/sow/sowlist.html)
 - [#6]: [IAU Catalog of Star Names (IAU-CSN)](http://www.pas.rochester.edu/~emamajek/WGSN/IAU-CSN.txt)
 - [#7]: [Covington, Michael (2002). "Celestial Objects for Modern Telescopes: Practical Amateur Astronomy". Cambridge University Press.](https://books.google.com/books?id=ql7wLq1fP5QC&pg=PA209)
 - [#8]: ["61 Cyg (Piazzi's Flying Star)". Science&Space News. Retrieved June 1, 2015.](http://news.sky-map.org/starview?object_type=1&object_id=2282&object_name=HD+201091&locale=EN)
 - [#9]: [Kruger 60](https://en.wikipedia.org/wiki/Kruger_60)
 - [#10]: [List of Named Stars in Alphabetical Order](http://www.astro.wisc.edu/~dolan/constellations/starname_list.html)
 - [#11]: [Jack W. Rhoads (1971). "Reduced Star Catalog Containing 537 Named Stars", Jet Propulsion Laboratory, California Institute of Technology; November 15, 1971](https://ntrs.nasa.gov/citations/19720005197)
 - [#12]: [IAU Naming Stars](https://www.iau.org/public/themes/naming_stars/)
 - [#13]: [Bright Star Catalogue, 5th Revised Ed. (Hoffleit+, 1991)](http://vizier.u-strasbg.fr/viz-bin/VizieR?-source=V/50)
 - [#14]: Piazzi, G, ed. (1814). "Praecipuarum Stellarum Inerrantium Positiones Mediae Ineunte Saeculo XIX: ex Observationibus Habitis in Specula Panormitana ab anno 1792 ad annum 1813". Palermo. p. 21.
 - [#15]: Kunitzsch, P. (1959). "Arabische Sternnamen in Europa". Wiesbaden: Otto Harrassowitz. p. 155.
 - [#16]: Laffitte, R. (2005). "Héritages arabes: Des noms arabes pour les étoiles" (2éme revue et corrigée ed.). Paris: Librairie Orientaliste Paul Geunthner / Les Cahiers de l'Orient. p. 229.
 - [#17]: Burritt, E. H. (1835). "Atlas, Designed to Illustrate the Geography of the Heavens" (new ed.). New York: F. J. Huntington. plate III.
 - [#18]: Burnham, Robert Jr. (1978, 1979). "Burnham's Celestial Handbook: An Observer's Guide to the Universe Beyond the Solar System", Vol. 1, 2, 3. NY: Dover Publications. ISBN 978-0486235677, 978-0486235684, 978-0486236735
 - [#19]: [Iota Ursae Majoris](https://en.wikipedia.org/wiki/Iota_Ursae_Majoris)
 - [#20]: [Falkner, David E. (2011). "The Mythology of the Night Sky: An Amateur Astronomer's Guide to the Ancient Greek and Roman Legends", Patrick Moore's Practical Astronomy, Springer. ISBN 1-4614-0136-4](https://books.google.com/books?id=tyj8UUE968wC)
 - [#21]: Peters, C. A. F. (1853). "On the Parallax of Argelander's Star". Monthly Notices of the Royal Astronomical Society, Vol. 14, p.49. DOI: 10.1093/mnras/14.2.49
 - [#22]: Maddocks, Hugh C. (1991). "Deep-Sky Name Index 2000.0". Foxon-Maddocks Associates. ISBN 0-9628305-0-X.
 - [#23]: Josef Klepesta, Antonin Rukl (1977). "Constellations: A concise guide in colour". ISBN 0600008932.
 - [#24]: Oswald Thomas (1945). "Atlas der Sternbilder". Salzburg.
 - [#25]: Fred Schaaf (2019). "An Assortment of Asterisms". Sky & Telescope, p.45 (Nov 2019)
 - [#26]: Gary Seronik (2017). "Binocular Highlights Revised & Expanded: 109 Celestial Sights for Binocular Users". F W Publications Inc. ISBN 9781940038445
 - [#27]: Tony Flanders (2019). "Constellation Close-up: Centaurus and Crux". Sky & Telescope, pp.22-27 (Apr 2019).
 - [#28]: Sue French (2019). "Deep-Sky Wonders: Heavenly Hero". Sky & Telescope, pp.54-56 (Jul 2019).
 - [#29]: [Software Bisque: A Complete List of Asterisms](https://www.bisque.com/tom/asterisms/list.asp)
 - [#30]: [University of Northern Iowa, EARTHSCI 1100 - Astronomy, Asterisms.](https://sites.uni.edu/morgans/astro/asterisms.html)
 - [#31]: [Horvatin - Obsolete Constellations, Department of Physics and Astronomy, Michigan State University.](https://web.pa.msu.edu/people/horvatin/Astronomy_Facts/obsolete_pages/triangulum_minor.htm)
 - [#32]: [Donald H. Menzel (1964). A Field Guide to the Stars and Planets by Donald H. Menzel, Collins books - St. James's Place, London. ISBN: 0395934311, ISBN13: 9780395934319](http://www.arvindguptatoys.com/arvindgupta/menzel-fieldguide.pdf)
 - [#33]: [James B. (Jim) Kaler. Professor Emeritus of Astronomy, University of Illinois.](http://stars.astro.illinois.edu/sow/6tri.html)
 - [#34]: [Astronomy Club of Tulsa - Observer, December 2008.](http://www.astrotulsa.com/cms_files/200812.pdf)
 - [#35]: [Baylor University, School of Engineering and Computer Science, Astronomy observing log.](http://cs.baylor.edu/~hamerly/personal/astro/log.html)
 - [#36]: [IAU100 NameExoWorlds](http://nameexoworlds.iau.org/)
 - [#37]: [The Washington Double Star Catalog (Mason+ 2001-2020)](https://vizier.u-strasbg.fr/viz-bin/VizieR?-source=B/wds)
 - [#38]: [Patrick Moore, Paul Doherty, H. J. P. Arnold, The Photographic Atlas of the Stars, CRC Press LLC, 1999. ISBN 0750306548](https://books.google.com/books?id=YjcvJUfnWBAC&pg=PA97#v=onepage&q&f=false)

## Authors

Edgar Scholz

## License

CC BY-ND 4.0 International
