% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-subset-arrange.R
\name{arrange.dtplyr_step}
\alias{arrange.dtplyr_step}
\title{Arrange rows by column values}
\usage{
\method{arrange}{dtplyr_step}(.data, ..., .by_group = FALSE)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\description{
This is a method for dplyr generic \code{\link[dplyr:arrange]{dplyr::arrange()}}. It is translated to
an \code{\link[=order]{order()}} call in the \code{i} argument of \verb{[.data.table}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(mtcars)
dt \%>\% arrange(vs, cyl)
dt \%>\% arrange(desc(vs), cyl)
dt \%>\% arrange(across(mpg:disp))
}
