% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotationFilter.R, R/translate-utils.R
\docType{methods}
\name{AnnotationFilter}
\alias{AnnotationFilter}
\alias{CdsStartFilter}
\alias{CdsEndFilter}
\alias{ExonIdFilter}
\alias{ExonNameFilter}
\alias{ExonStartFilter}
\alias{ExonEndFilter}
\alias{ExonRankFilter}
\alias{GeneIdFilter}
\alias{GeneNameFilter}
\alias{GeneBiotypeFilter}
\alias{GeneStartFilter}
\alias{GeneEndFilter}
\alias{EntrezFilter}
\alias{SymbolFilter}
\alias{TxIdFilter}
\alias{TxNameFilter}
\alias{TxBiotypeFilter}
\alias{TxStartFilter}
\alias{TxEndFilter}
\alias{ProteinIdFilter}
\alias{UniprotFilter}
\alias{SeqNameFilter}
\alias{SeqStrandFilter}
\alias{AnnotationFilter-class}
\alias{CharacterFilter-class}
\alias{DoubleFilter-class}
\alias{IntegerFilter-class}
\alias{CdsStartFilter-class}
\alias{CdsEndFilter-class}
\alias{ExonIdFilter-class}
\alias{ExonNameFilter-class}
\alias{ExonStartFilter-class}
\alias{ExonEndFilter-class}
\alias{ExonRankFilter-class}
\alias{GeneIdFilter-class}
\alias{GeneNameFilter-class}
\alias{GeneBiotypeFilter-class}
\alias{GeneStartFilter-class}
\alias{GeneEndFilter-class}
\alias{EntrezFilter-class}
\alias{SymbolFilter-class}
\alias{TxIdFilter-class}
\alias{TxNameFilter-class}
\alias{TxBiotypeFilter-class}
\alias{TxStartFilter-class}
\alias{TxEndFilter-class}
\alias{ProteinIdFilter-class}
\alias{UniprotFilter-class}
\alias{SeqNameFilter-class}
\alias{SeqStrandFilter-class}
\alias{supportedFilters}
\alias{show,AnnotationFilter-method}
\alias{show,CharacterFilter-method}
\alias{show,IntegerFilter-method}
\alias{show,GRangesFilter-method}
\alias{show,DoubleFilter-method}
\alias{condition,AnnotationFilter-method}
\alias{condition}
\alias{value,AnnotationFilter-method}
\alias{value}
\alias{field,AnnotationFilter-method}
\alias{field}
\alias{not,AnnotationFilter-method}
\alias{GRangesFilter-class}
\alias{.GRangesFilter}
\alias{GRangesFilter}
\alias{feature}
\alias{AnnotationFilter}
\alias{convertFilter,AnnotationFilter,missing-method}
\alias{supportedFilters,missing-method}
\alias{AnnotationFilter}
\title{Filters for annotation objects}
\usage{
CdsStartFilter(value, condition = "==", not = FALSE)
CdsEndFilter(value, condition = "==", not = FALSE)
ExonIdFilter(value, condition = "==", not = FALSE)
ExonNameFilter(value, condition = "==", not = FALSE)
ExonRankFilter(value, condition = "==", not = FALSE)
ExonStartFilter(value, condition = "==", not = FALSE)
ExonEndFilter(value, condition = "==", not = FALSE)
GeneIdFilter(value, condition = "==", not = FALSE)
GeneNameFilter(value, condition = "==", not = FALSE)
GeneBiotypeFilter(value, condition = "==", not = FALSE)
GeneStartFilter(value, condition = "==", not = FALSE)
GeneEndFilter(value, condition = "==", not = FALSE)
EntrezFilter(value, condition = "==", not = FALSE)
SymbolFilter(value, condition = "==", not = FALSE)
TxIdFilter(value, condition = "==", not = FALSE)
TxNameFilter(value, condition = "==", not = FALSE)
TxBiotypeFilter(value, condition = "==", not = FALSE)
TxStartFilter(value, condition = "==", not = FALSE)
TxEndFilter(value, condition = "==", not = FALSE)
ProteinIdFilter(value, condition = "==", not = FALSE)
UniprotFilter(value, condition = "==", not = FALSE)
SeqNameFilter(value, condition = "==", not = FALSE)
SeqStrandFilter(value, condition = "==", not = FALSE)

\S4method{condition}{AnnotationFilter}(object)

\S4method{value}{AnnotationFilter}(object)

\S4method{field}{AnnotationFilter}(object)

\S4method{not}{AnnotationFilter}(object)

GRangesFilter(value, feature = "gene", type = c("any", "start", "end",
  "within", "equal"))

feature(object)

\S4method{convertFilter}{AnnotationFilter,missing}(object)

\S4method{supportedFilters}{missing}(object)

AnnotationFilter(expr)
}
\arguments{
\item{object}{An \code{AnnotationFilter} object.}

\item{value}{\code{character()}, \code{integer()}, or
\code{GRanges()} value for the filter}

\item{feature}{\code{character(1)} defining on what feature the
\code{GRangesFilter} should be applied. Choices could be
\code{"gene"}, \code{"tx"} or \code{"exon"}.}

\item{type}{\code{character(1)} indicating how overlaps are to be
filtered. See \code{findOverlaps} in the IRanges package for a
description of this argument.}

\item{expr}{A filter expression, written as a \code{formula}, to be
converted to an \code{AnnotationFilter} or \code{AnnotationFilterList}
class. See below for examples.}

\item{condition}{\code{character(1)} defining the condition to be
used in the filter. For \code{IntegerFilter} or \code{DoubleFilter},
one of \code{"=="}, \code{"!="}, \code{">"}, \code{"<"}, \code{">="}
or \code{"<="}. For \code{CharacterFilter}, one of \code{"=="},
\code{"!="}, \code{"startsWith"}, \code{"endsWith"} or \code{"contains"}.
Default condition is \code{"=="}.}

\item{not}{\code{logical(1)} whether the \code{AnnotationFilter} is negated.
\code{TRUE} indicates is negated (!). \code{FALSE} indicates not
negated. Default not is \code{FALSE}.}
}
\value{
The constructor function return an object extending
    \code{AnnotationFilter}. For the return value of the other methods see
    the methods' descriptions.

\code{character(1)} that can be used as input to a \code{dplyr} 
     filter.

\code{AnnotationFilter} returns an
    \code{\link{AnnotationFilter}} or an \code{\link{AnnotationFilterList}}.
}
\description{
The filters extending the base \code{AnnotationFilter} class
represent a simple filtering concept for annotation resources.
Each filter object is thought to filter on a single (database)
table column using the provided values and the defined condition.

Filter instances created using the constructor functions (e.g.
\code{GeneIdFilter}).

\code{supportedFilters()} lists all defined filters. It returns a two column
\code{data.frame} with the filter class name and its default field.
Packages using \code{AnnotationFilter} should implement the
\code{supportedFilters} for their annotation resource object (e.g. for
\code{object = "EnsDb"} in the \code{ensembldb} package) to list all
supported filters for the specific resource.

\code{condition()} get the \code{condition} value for
    the filter \code{object}.

\code{value()} get the \code{value} for the filter
    \code{object}.

\code{field()} get the \code{field} for the filter
    \code{object}.

\code{not()} get the \code{not} for the filter \code{object}.

\code{feature()} get the \code{feature} for the
    \code{GRangesFilter} \code{object}.

Converts an \code{AnnotationFilter} object to a 
     \code{character(1)} giving an equation that can be used as input to
     a \code{dplyr} filter.

\code{AnnotationFilter} \emph{translates} a filter
    expression such as \code{~ gene_id == "BCL2"} into a filter object
    extending the \code{\link{AnnotationFilter}} class (in the example a
    \code{\link{GeneIdFilter}} object) or an
    \code{\link{AnnotationFilterList}} if the expression contains multiple
    conditions (see examples below). Filter expressions have to be written
    in the form \code{~ <field> <condition> <value>}, with \code{<field>}
    being the default field of the filter class (use the
    \code{supportedFilter} function to list all fields and filter classes),
    \code{<condition>} the logical expression and \code{<value>} the value
    for the filter.
}
\details{
By default filters are only available for tables containing the
field on which the filter acts (i.e. that contain a column with the
name matching the value of the \code{field} slot of the
object). See the vignette for a description to use filters for
databases in which the database table column name differs from the
default \code{field} of the filter.

Filter expressions for the \code{AnnotationFilter} class have to be
    written as formulas, i.e. starting with a \code{~}.
}
\note{
Translation of nested filter expressions using the
    \code{AnnotationFilter} function is not yet supported.
}
\examples{
## filter by GRanges
GRangesFilter(GenomicRanges::GRanges("chr10:87869000-87876000"))
## Create a SymbolFilter to filter on a gene's symbol.
sf <- SymbolFilter("BCL2")
sf

## Create a GeneStartFilter to filter based on the genes' chromosomal start
## coordinates
gsf <- GeneStartFilter(10000, condition = ">")
gsf

filter <- SymbolFilter("ADA", "==")
result <- convertFilter(filter)
result
supportedFilters()

## Convert a filter expression based on a gene ID to a GeneIdFilter
gnf <- AnnotationFilter(~ gene_id == "BCL2")
gnf

## Same conversion but for two gene IDs.
gnf <- AnnotationFilter(~ gene_id \%in\% c("BCL2", "BCL2L11"))
gnf

## Converting an expression that combines multiple filters. As a result we
## get an AnnotationFilterList containing the corresponding filters.
## Be aware that nesting of expressions/filters does not work.
flt <- AnnotationFilter(~ gene_id \%in\% c("BCL2", "BCL2L11") &
                        tx_biotype == "nonsense_mediated_decay" |
                        seq_name == "Y")
flt

}
\seealso{
\code{\link{AnnotationFilterList}} for combining
    \code{AnnotationFilter} objects.
}
