# Announcing TUF 1.0.0

Python-TUF v1.0.0 is a rewritten stable reference implementation of the TUF
specification, which *currently* includes:
- a modern low-level [*metadata
  API*](https://theupdateframework.readthedocs.io/en/latest/api/tuf.api.html)
- a fully specification-compliant [*updater
  client*](https://theupdateframework.readthedocs.io/en/latest/api/tuf.ngclient.html),
  serving as a more robust and yet more flexible stand-in replacement
  for the legacy client updater

For the reasons outlined in [ADR 10](https://github.com/theupdateframework/python-tuf/blob/develop/docs/adr/0010-repository-library-design.md
), this release *does not yet* include *repository tool*-like functionality.
However, the new *metadata API* makes it easy to replicate the desired
functionality tailored to the specific needs of any given repository (see
*Migration* for details).

As discussed in [ADR 2](https://github.com/theupdateframework/python-tuf/blob/develop/docs/adr/0002-pre-1-0-deprecation-strategy.md), this
release *does not* include any legacy code, as its maintenance has become
infeasible for the python-tuf team. The pre-1.0.0 deprecation strategy from ADR
2 applies as follows:

> *Bugs reported with tuf versions prior to 1.0.0 will likely not be addressed
directly by tuf’s maintainers. Pull Requests to fix bugs in the last release
prior to 1.0.0 will be considered, and merged (subject to normal review
processes). Note that there may be delays due to the lack of developer resources
for reviewing such pull requests.*


## Migration

Given the clean cut with the legacy reference implementation, we provide the
following migration support:

- detailed code documentation on
  [https://theupdateframework.readthedocs.io](https://theupdateframework.readthedocs.io/)
- verbose [code examples](https://github.com/theupdateframework/python-tuf/tree/develop/examples) for *client updater* usage, and
  repository-side operations based on the low-level *metadata API*
- individual migration support upon
  [request](https://github.com/theupdateframework/python-tuf#contact)
- targeted migration support initiative for known users
