# Changes since [4.1.0](./4.1.0.md)

- Breaking changes:

  - Replace `glos.getAuthor()` with `glos.author`
    - This looks for "author" and then "publisher" keys in info/metadata
  - Rename option `apply_css` to `css` for mobi and epub2
  - `glos.getInfo` and `glos.setInfo` only accept `str` as key (or a subclass of `str`)

- Bug fixes:

  - Indirect mode: Fix handling '|' character in words.

    - Escape/unescape `|` in words when converting `entry` \<-> `rawEntry`

  - Escape/unescape `|` in words when writing/reading text-based file formats

  - JSON: Prevent duplicate keys in json output, [#344](https://github.com/ilius/pyglossary/issues/344)

    - Add new method `glos.preventDuplicateWords()`

- Features and improvements

  - Add SQLite mode with `--sqlite` flag for converting to StarDict.

    - Eliminates the need to load all entries into RAM, limiting RAM usage.
    - You can add `--sqlite` to you command, even for running GUI.
      - For example: `python3 main.py --tk --sqlite`
    - See [README.md](../../README.md#sqlite-mode) for more details.

  - Add `--source-lang` and `--target-lang` flags

  - XDXF: support more tags and improvements

  - Add unit tests for `Glossary` class, and some functions in `text_utils.py`

  - Windows: change cache directory to `%LOCALAPPDATA%`

  - Some refactoring and optimization

  - Update, improve and re-format documentations
