#!/usr/bin/python3

#
# This maintenance script updates the content of the "Orthanc" folder
# to match the latest version of the Orthanc source code.
#

import multiprocessing
import os
import stat
import urllib.request

TARGET = os.path.join(os.path.dirname(__file__), 'Orthanc')
PLUGIN_SDK_VERSION = [ '1.12.4' ]
REPOSITORY = 'https://orthanc.uclouvain.be/hg/orthanc/raw-file'

FILES = [
    ('OrthancFramework/Resources/CMake/AutoGeneratedCode.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/Compiler.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/DownloadOrthancFramework.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/DownloadPackage.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/GoogleTestConfiguration.cmake', 'CMake'),
    ('OrthancFramework/Resources/EmbedResources.py', 'CMake'),
    ('OrthancFramework/Resources/Toolchains/LinuxStandardBaseToolchain.cmake', 'Toolchains'),
    ('OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain32.cmake', 'Toolchains'),
    ('OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain64.cmake', 'Toolchains'),
    ('OrthancFramework/Resources/Toolchains/MinGWToolchain.cmake', 'Toolchains'),
    ('OrthancServer/Plugins/Samples/Common/ExportedSymbolsPlugins.list', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.cpp', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.h', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginException.h', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginsExports.cmake', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/VersionScriptPlugins.map', 'Plugins'),

    # Specific to DICOMweb plugin
    ('OrthancServer/Resources/OrthancLogo.png', '.'),
]

SDK = [
    'orthanc/OrthancCPlugin.h',
]


def Download(x):
    branch = x[0]
    source = x[1]
    target = os.path.join(TARGET, x[2])
    print(target)

    try:
        os.makedirs(os.path.dirname(target))
    except:
        pass

    url = '%s/%s/%s' % (REPOSITORY, branch, source)

    with open(target, 'wb') as f:
        try:
            f.write(urllib.request.urlopen(url).read())
        except:
            print('ERROR %s' % url)
            raise


commands = []

for f in FILES:
    commands.append([ 'default',
                      f[0],
                      os.path.join(f[1], os.path.basename(f[0])) ])

for f in SDK:
    for version in PLUGIN_SDK_VERSION:
        commands.append([
            'Orthanc-%s' % version,
            'OrthancServer/Plugins/Include/%s' % f,
            'Sdk-%s/%s' % (version, f)
        ])


pool = multiprocessing.Pool(10)  # simultaneous downloads
pool.map(Download, commands)
