/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_LOONGARCH_UNWIND_HINTS_H
#define _ASM_LOONGARCH_UNWIND_HINTS_H

#include <linux/objtool.h>
#include <asm/orc_types.h>

#ifdef __ASSEMBLER__

.macro UNWIND_HINT_UNDEFINED
	UNWIND_HINT type=UNWIND_HINT_TYPE_UNDEFINED
.endm

.macro UNWIND_HINT_END_OF_STACK
	UNWIND_HINT type=UNWIND_HINT_TYPE_END_OF_STACK
.endm

.macro UNWIND_HINT_REGS
	UNWIND_HINT sp_reg=ORC_REG_SP type=UNWIND_HINT_TYPE_REGS
.endm

.macro UNWIND_HINT_FUNC
	UNWIND_HINT sp_reg=ORC_REG_SP type=UNWIND_HINT_TYPE_CALL
.endm

#else /* !__ASSEMBLER__ */

#define UNWIND_HINT_SAVE \
	UNWIND_HINT(UNWIND_HINT_TYPE_SAVE, 0, 0, 0)

#define UNWIND_HINT_RESTORE \
	UNWIND_HINT(UNWIND_HINT_TYPE_RESTORE, 0, 0, 0)

#endif /* !__ASSEMBLER__ */

#endif /* _ASM_LOONGARCH_UNWIND_HINTS_H */
