C
C
      SUBROUTINE DLAEIG(N, NBAND, NL, NR, A, EIGVAL, LDE,
     1   EIGVEC, BOUND, ATEMP, D, VTEMP, EPS, TMIN, TMAX)
C
C  THIS IS A SPECIALIZED VERSION OF THE SUBROUTINE BNDEIG TAILORED
C  SPECIFICALLY FOR USE BY THE LASO PACKAGE.
C
      INTEGER N, NBAND, NL, NR, LDE
      DOUBLE PRECISION A(NBAND,1), EIGVAL(1),
     1   EIGVEC(LDE,1), BOUND(2,1), ATEMP(1), D(1), VTEMP(1),
     2   EPS, TMIN, TMAX
C
C  LOCAL VARIABLES
C
      INTEGER I, M, NVAL
      DOUBLE PRECISION ARTOL, ATOL
C
C  FUNCTIONS CALLED
C
      DOUBLE PRECISION DMAX1
C
C  SUBROUTINES CALLED
C
C     DLABCM, DLABFC, DLAGER, DCOPY
C
C  SET PARAMETERS
C
      ATOL = DBLE(FLOAT(N))*EPS*DMAX1(TMAX,-TMIN)
      ARTOL = ATOL/DSQRT(EPS)
      NVAL = NR - NL + 1
C
C   CHECK FOR SPECIAL CASE OF N = 1
C
      IF(N .NE. 1) GO TO 30
      EIGVAL(1) = A(1,1)
      EIGVEC(1,1) = 1.0D0
      RETURN
C
C   SET UP INITIAL EIGENVALUE BOUNDS
C
   30 M = NVAL + 1
      DO 50 I = 2, M
         BOUND(1,I) = TMIN
         BOUND(2,I) = TMAX
   50 CONTINUE
      BOUND(2,1) = TMAX
      BOUND(1,NVAL + 2) = TMIN
      IF(NL .EQ. 1) BOUND(2,1) = TMIN
      IF(NR .EQ. N) BOUND(1,NVAL + 2) = TMAX
C
   60 CALL DLABCM(N, NBAND, NL, NR, A, EIGVAL, LDE,
     1  EIGVEC, ATOL, ARTOL, BOUND, ATEMP, D, VTEMP)
      RETURN
      END
