//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatadog

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewCreationSupportedClient creates a new instance of CreationSupportedClient.
func (c *ClientFactory) NewCreationSupportedClient() *CreationSupportedClient {
	subClient, _ := NewCreationSupportedClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMarketplaceAgreementsClient creates a new instance of MarketplaceAgreementsClient.
func (c *ClientFactory) NewMarketplaceAgreementsClient() *MarketplaceAgreementsClient {
	subClient, _ := NewMarketplaceAgreementsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMonitoredSubscriptionsClient creates a new instance of MonitoredSubscriptionsClient.
func (c *ClientFactory) NewMonitoredSubscriptionsClient() *MonitoredSubscriptionsClient {
	subClient, _ := NewMonitoredSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMonitorsClient creates a new instance of MonitorsClient.
func (c *ClientFactory) NewMonitorsClient() *MonitorsClient {
	subClient, _ := NewMonitorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewSingleSignOnConfigurationsClient creates a new instance of SingleSignOnConfigurationsClient.
func (c *ClientFactory) NewSingleSignOnConfigurationsClient() *SingleSignOnConfigurationsClient {
	subClient, _ := NewSingleSignOnConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTagRulesClient creates a new instance of TagRulesClient.
func (c *ClientFactory) NewTagRulesClient() *TagRulesClient {
	subClient, _ := NewTagRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
