//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armdatabricks.ClientFactory type.
type ServerFactory struct {
	AccessConnectorsServer                     AccessConnectorsServer
	OperationsServer                           OperationsServer
	OutboundNetworkDependenciesEndpointsServer OutboundNetworkDependenciesEndpointsServer
	PrivateEndpointConnectionsServer           PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer                 PrivateLinkResourcesServer
	VNetPeeringServer                          VNetPeeringServer
	WorkspacesServer                           WorkspacesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armdatabricks.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armdatabricks.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                          *ServerFactory
	trMu                                         sync.Mutex
	trAccessConnectorsServer                     *AccessConnectorsServerTransport
	trOperationsServer                           *OperationsServerTransport
	trOutboundNetworkDependenciesEndpointsServer *OutboundNetworkDependenciesEndpointsServerTransport
	trPrivateEndpointConnectionsServer           *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer                 *PrivateLinkResourcesServerTransport
	trVNetPeeringServer                          *VNetPeeringServerTransport
	trWorkspacesServer                           *WorkspacesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccessConnectorsClient":
		initServer(s, &s.trAccessConnectorsServer, func() *AccessConnectorsServerTransport {
			return NewAccessConnectorsServerTransport(&s.srv.AccessConnectorsServer)
		})
		resp, err = s.trAccessConnectorsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OutboundNetworkDependenciesEndpointsClient":
		initServer(s, &s.trOutboundNetworkDependenciesEndpointsServer, func() *OutboundNetworkDependenciesEndpointsServerTransport {
			return NewOutboundNetworkDependenciesEndpointsServerTransport(&s.srv.OutboundNetworkDependenciesEndpointsServer)
		})
		resp, err = s.trOutboundNetworkDependenciesEndpointsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "VNetPeeringClient":
		initServer(s, &s.trVNetPeeringServer, func() *VNetPeeringServerTransport { return NewVNetPeeringServerTransport(&s.srv.VNetPeeringServer) })
		resp, err = s.trVNetPeeringServer.Do(req)
	case "WorkspacesClient":
		initServer(s, &s.trWorkspacesServer, func() *WorkspacesServerTransport { return NewWorkspacesServerTransport(&s.srv.WorkspacesServer) })
		resp, err = s.trWorkspacesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
