---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Missing X-Content-Type-Options: nosniff

## Description

The `X-Content-Type-Options` header with the value `nosniff` ensures that user agents do not attempt to
guess the format of the data being received. User Agents such as browsers, commonly attempt to guess
what the resource type being requested is, through a process called MIME type sniffing.

Without this header being sent, the browser may misinterpret the data, leading to MIME confusion attacks.
If an attacker were able to upload files that are accessible by using a browser, they could upload files
that could be interpreted as HTML and execute Cross-Site Scripting (XSS) attacks.

## Remediation

We recommend that the header and value of `X-Content-Type-Options: nosniff` be set server wide.
This ensures any resources that are mistakenly missing a `Content-Type` value are not
misinterpreted.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 693.1 | true | 693 | Passive | Low |

## Links

- [OWASP](https://owasp.org/www-project-secure-headers/#x-content-type-options)
- [CWE](https://cwe.mitre.org/data/definitions/693.html)
- [Mozilla Blog on MIME Confusion attacks](https://blog.mozilla.org/security/2016/08/26/mitigating-mime-confusion-attacks-in-firefox/)
- [Mozilla MDN on X-Content-Type-Options](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options)
