// generated by diplomat-tool
import { DataProvider } from "./DataProvider.mjs"
import { DateTimeFormatter } from "./DateTimeFormatter.mjs"
import { DateTimeFormatterLoadError } from "./DateTimeFormatterLoadError.mjs"
import { DateTimeWriteError } from "./DateTimeWriteError.mjs"
import { IsoDate } from "./IsoDate.mjs"
import { Locale } from "./Locale.mjs"
import { Time } from "./Time.mjs"
import { TimeZoneInfo } from "./TimeZoneInfo.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `DateTimeFormatter`](https://docs.rs/icu/latest/icu/datetime/struct.DateTimeFormatter.html) for more information.
 */
const ZonedDateTimeFormatter_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_ZonedDateTimeFormatter_destroy_mv1(ptr);
});

export class ZonedDateTimeFormatter {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("ZonedDateTimeFormatter is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            ZonedDateTimeFormatter_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificLong.html) for more information.
     */
    static createSpecificLong(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_specific_long_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificLong.html) for more information.
     */
    static createSpecificLongWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_specific_long_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificShort.html) for more information.
     */
    static createSpecificShort(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_specific_short_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `SpecificShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.SpecificShort.html) for more information.
     */
    static createSpecificShortWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_specific_short_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetLong.html) for more information.
     */
    static createLocalizedOffsetLong(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_localized_offset_long_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetLong.html) for more information.
     */
    static createLocalizedOffsetLongWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_localized_offset_long_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetShort.html) for more information.
     */
    static createLocalizedOffsetShort(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_localized_offset_short_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `LocalizedOffsetShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.LocalizedOffsetShort.html) for more information.
     */
    static createLocalizedOffsetShortWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_localized_offset_short_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericLong.html) for more information.
     */
    static createGenericLong(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_generic_long_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericLong`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericLong.html) for more information.
     */
    static createGenericLongWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_generic_long_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericShort.html) for more information.
     */
    static createGenericShort(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_generic_short_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `GenericShort`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.GenericShort.html) for more information.
     */
    static createGenericShortWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_generic_short_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `Location`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.Location.html) for more information.
     */
    static createLocation(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_location_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `Location`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.Location.html) for more information.
     */
    static createLocationWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_location_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `ExemplarCity`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.ExemplarCity.html) for more information.
     */
    static createExemplarCity(locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_exemplar_city_mv1(diplomatReceive.buffer, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a zoned formatter based on a non-zoned formatter.
     *
     * Caution: The locale provided here must match the locale used to construct the non-zoned formatter,
     * or else unexpected behavior may occur!
     *
     * See the [Rust documentation for `ExemplarCity`](https://docs.rs/icu/latest/icu/datetime/fieldsets/zone/struct.ExemplarCity.html) for more information.
     */
    static createExemplarCityWithProvider(provider, locale, formatter) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_ZonedDateTimeFormatter_create_exemplar_city_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue, locale.ffiValue, formatter.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeFormatterLoadError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeFormatterLoadError: ' + cause.value, { cause });
            }
            return new ZonedDateTimeFormatter(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * See the [Rust documentation for `format`](https://docs.rs/icu/latest/icu/datetime/struct.DateTimeFormatter.html#method.format) for more information.
     */
    formatIso(date, time, zone) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);

        const write = new diplomatRuntime.DiplomatWriteBuf(wasm);


        const result = wasm.icu4x_ZonedDateTimeFormatter_format_iso_mv1(diplomatReceive.buffer, this.ffiValue, date.ffiValue, time.ffiValue, zone.ffiValue, write.buffer);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DateTimeWriteError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DateTimeWriteError: ' + cause.value, { cause });
            }
            return write.readString8();
        }

        finally {
            diplomatReceive.free();
            write.free();
        }
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}