#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

# Prevent too broad fallback values for localisation packages.
test_localisation_packages_properties_leak() {
	local \
		PKG_L10N_PROVIDES='baldurs-gate-3-l10n' \
		package_provides_french \
		package_provides_common

	package_provides_french=$(package_provides 'PKG_L10N_FR')
	assertEquals \
		'Failed to fetch a fallback value for localisation package PKG_xxx_PROVIDES.' \
		'baldurs-gate-3-l10n' "$package_provides_french"
	package_provides_common=$(package_provides 'PKG_L10N_COMMON')
	assertNull \
		'A fallback value for localisation package PKG_xxx_PROVIDES has been fetched by accident.' \
		"$package_provides_common"

	local \
		PKG_L10N_DEPENDENCIES_SIBLINGS='
PKG_L10N_COMMON
PKG_L10N_VOICES' \
		package_dependencies_french \
		package_dependencies_common

	package_dependencies_french=$(dependencies_siblings_list 'PKG_L10N_FR')
	assertEquals \
		'Failed to fetch a fallback value for localisation package PKG_xxx_DEPENDENCIES_SIBLINGS.' \
		'PKG_L10N_COMMON
PKG_L10N_VOICES' "$package_dependencies_french"
	package_dependencies_common=$(dependencies_siblings_list 'PKG_L10N_COMMON')
	assertNull \
		'A fallback value for localisation package PKG_xxx_DEPENDENCIES_SIBLINGS has been fetched by accident.' \
		"$package_dependencies_common"
}
