/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.util.StringTokenizer;
import rene.dialogs.ItemEditorElement;
import rene.gui.Global;
import rene.gui.Keyboard;
import rene.util.sort.SortObject;

public class KeyboardItem
implements ItemEditorElement,
SortObject {
    boolean Shift;
    boolean Control;
    boolean Alt;
    String CharKey;
    String MenuString;
    String ActionName;
    int CommandType = 0;

    public KeyboardItem(KeyboardItem keyboardItem) {
        this.Shift = keyboardItem.Shift;
        this.Control = keyboardItem.Control;
        this.Alt = keyboardItem.Alt;
        this.CharKey = keyboardItem.CharKey;
        this.MenuString = keyboardItem.MenuString;
        this.ActionName = keyboardItem.ActionName;
        this.CommandType = keyboardItem.CommandType;
    }

    public KeyboardItem(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n) {
        this.Shift = bl;
        this.Control = bl2;
        this.Alt = bl3;
        this.CharKey = string.toLowerCase();
        this.MenuString = string2;
        this.ActionName = string3;
        this.CommandType = n;
    }

    public KeyboardItem(String string, String string2) {
        this.MenuString = string;
        this.Alt = false;
        this.Control = false;
        this.Shift = false;
        this.CommandType = 0;
        this.CharKey = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                if (string3.equals("control")) {
                    this.Control = true;
                    continue;
                }
                if (string3.equals("shift")) {
                    this.Shift = true;
                    continue;
                }
                if (string3.equals("alt")) {
                    this.Alt = true;
                    continue;
                }
                if (string3.startsWith("esc")) {
                    try {
                        this.CommandType = Integer.parseInt(string3.substring(3));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return;
            }
            if (string2.equals("")) {
                return;
            }
            this.CharKey = string3.toLowerCase();
        }
        this.ActionName = Global.name(this.getStrippedMenuString());
    }

    public String getMenuString() {
        return this.MenuString;
    }

    public String getActionName() {
        return this.ActionName;
    }

    public String getCharKey() {
        return this.CharKey;
    }

    public boolean isShift() {
        return this.Shift;
    }

    public boolean isControl() {
        return this.Control;
    }

    public boolean isAlt() {
        return this.Alt;
    }

    public int getCommandType() {
        return this.CommandType;
    }

    public String getStrippedMenuString() {
        String string = this.MenuString;
        while (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String shortcut() {
        if (this.CharKey.equals("none")) {
            return "";
        }
        String string = this.CharKey.toUpperCase();
        if (this.Alt) {
            string = Global.name("shortcut.alt") + " " + string;
        }
        if (this.Control) {
            string = Global.name("shortcut.control") + " " + string;
        }
        if (this.Shift) {
            string = Global.name("shortcut.shift") + " " + string;
        }
        if (this.CommandType > 0) {
            string = Keyboard.commandShortcut(this.CommandType) + " " + string;
        }
        return string;
    }

    public String getName() {
        return this.MenuString;
    }

    public int compare(SortObject sortObject) {
        return this.getName().compareTo(((KeyboardItem)sortObject).getName());
    }

    public String keyDescription() {
        String string = this.CharKey.toLowerCase();
        if (string.equals("none") || string.equals("default")) {
            return string;
        }
        if (this.Alt) {
            string = "alt." + string;
        }
        if (this.Control) {
            string = "control." + string;
        }
        if (this.Shift) {
            string = "shift." + string;
        }
        if (this.CommandType > 0) {
            string = "esc" + this.CommandType + "." + string;
        }
        return string;
    }
}

