
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Ax2.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Circ.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Cone.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Trsf.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Cylinder.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Elips.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <gp_Ax1.hxx>
#include <gp_Ax2.hxx>
#include <gp_Vec.hxx>
#include <gp_Trsf.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Hypr.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Lin.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Parab.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pln.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <gp_Trsf.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Sphere.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Trsf.hxx>
#include <gp_GTrsf2d.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_GTrsf2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Torus.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <gp_Trsf.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Geom_Axis1Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <Geom_AxisPlacement.hxx>
#include <Geom_BezierCurve.hxx>
#include <Geom_BezierSurface.hxx>
#include <Geom_BoundedCurve.hxx>
#include <Geom_BoundedSurface.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Geom_CartesianPoint.hxx>
#include <Geom_Circle.hxx>
#include <Geom_Conic.hxx>
#include <Geom_ConicalSurface.hxx>
#include <Geom_Curve.hxx>
#include <Geom_CylindricalSurface.hxx>
#include <Geom_Direction.hxx>
#include <Geom_ElementarySurface.hxx>
#include <Geom_Ellipse.hxx>
#include <Geom_Geometry.hxx>
#include <Geom_HSequenceOfBSplineSurface.hxx>
#include <Geom_Hyperbola.hxx>
#include <Geom_Line.hxx>
#include <Geom_OffsetCurve.hxx>
#include <Geom_OffsetSurface.hxx>
#include <Geom_OsculatingSurface.hxx>
#include <Geom_Parabola.hxx>
#include <Geom_Plane.hxx>
#include <Geom_Point.hxx>
#include <Geom_RectangularTrimmedSurface.hxx>
#include <Geom_SequenceOfBSplineSurface.hxx>
#include <Geom_SphericalSurface.hxx>
#include <Geom_Surface.hxx>
#include <Geom_SurfaceOfLinearExtrusion.hxx>
#include <Geom_SurfaceOfRevolution.hxx>
#include <Geom_SweptSurface.hxx>
#include <Geom_ToroidalSurface.hxx>
#include <Geom_Transformation.hxx>
#include <Geom_TrimmedCurve.hxx>
#include <Geom_UndefinedDerivative.hxx>
#include <Geom_UndefinedValue.hxx>
#include <Geom_Vector.hxx>
#include <Geom_VectorWithMagnitude.hxx>

// template related includes

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Geom_enums(py::module &main_module) {


py::module m = main_module.def_submodule("Geom", R"#()#");

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_Geom_Geometry : public Geom_Geometry{
    public:
        using Geom_Geometry::Geom_Geometry;


        // public pure virtual
        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_AxisPlacement : public Geom_AxisPlacement{
    public:
        using Geom_AxisPlacement::Geom_AxisPlacement;


        // public pure virtual
        void SetDirection(const gp_Dir & V) override { PYBIND11_OVERLOAD_PURE(void,Geom_AxisPlacement,SetDirection,V) };

        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_Curve : public Geom_Curve{
    public:
        using Geom_Curve::Geom_Curve;


        // public pure virtual
        void Reverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,Reverse,) };
        Standard_Real ReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,ReversedParameter,U) };
        Standard_Real FirstParameter() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,FirstParameter,) };
        Standard_Real LastParameter() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,LastParameter,) };
        Standard_Boolean IsClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsClosed,) };
        Standard_Boolean IsPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsPeriodic,) };
        GeomAbs_Shape Continuity() const  override { PYBIND11_OVERLOAD_PURE(GeomAbs_Shape,Geom_Curve,Continuity,) };
        Standard_Boolean IsCN(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsCN,N) };
        void D0(const Standard_Real U,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D0,U,P) };
        void D1(const Standard_Real U,gp_Pnt & P,gp_Vec & V1) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D1,U,P,V1) };
        void D2(const Standard_Real U,gp_Pnt & P,gp_Vec & V1,gp_Vec & V2) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D2,U,P,V1,V2) };
        void D3(const Standard_Real U,gp_Pnt & P,gp_Vec & V1,gp_Vec & V2,gp_Vec & V3) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D3,U,P,V1,V2,V3) };
        gp_Vec DN(const Standard_Real U,const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Curve,DN,U,N) };

        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_Point : public Geom_Point{
    public:
        using Geom_Point::Geom_Point;


        // public pure virtual
        gp_Pnt Pnt() const  override { PYBIND11_OVERLOAD_PURE(gp_Pnt,Geom_Point,Pnt,) };
        Standard_Real X() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Point,X,) };
        Standard_Real Y() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Point,Y,) };
        Standard_Real Z() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Point,Z,) };
        void Coord(Standard_Real & X,Standard_Real & Y,Standard_Real & Z) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Point,Coord,X,Y,Z) };

        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_Surface : public Geom_Surface{
    public:
        using Geom_Surface::Geom_Surface;


        // public pure virtual
        void UReverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,UReverse,) };
        Standard_Real UReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Surface,UReversedParameter,U) };
        void VReverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,VReverse,) };
        Standard_Real VReversedParameter(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Surface,VReversedParameter,V) };
        Standard_Boolean IsUClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUClosed,) };
        Standard_Boolean IsVClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVClosed,) };
        Standard_Boolean IsUPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUPeriodic,) };
        Standard_Boolean IsVPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVPeriodic,) };
        opencascade::handle<Geom_Curve> UIso(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,UIso,U) };
        opencascade::handle<Geom_Curve> VIso(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,VIso,V) };
        GeomAbs_Shape Continuity() const  override { PYBIND11_OVERLOAD_PURE(GeomAbs_Shape,Geom_Surface,Continuity,) };
        Standard_Boolean IsCNu(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsCNu,N) };
        Standard_Boolean IsCNv(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsCNv,N) };
        void D0(const Standard_Real U,const Standard_Real V,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D0,U,V,P) };
        void D1(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D1,U,V,P,D1U,D1V) };
        void D2(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D2,U,V,P,D1U,D1V,D2U,D2V,D2UV) };
        void D3(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV,gp_Vec & D3U,gp_Vec & D3V,gp_Vec & D3UUV,gp_Vec & D3UVV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D3,U,V,P,D1U,D1V,D2U,D2V,D2UV,D3U,D3V,D3UUV,D3UVV) };
        gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Surface,DN,U,V,Nu,Nv) };
        void Bounds(Standard_Real & U1,Standard_Real & U2,Standard_Real & V1,Standard_Real & V2) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,Bounds,U1,U2,V1,V2) };

        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_Vector : public Geom_Vector{
    public:
        using Geom_Vector::Geom_Vector;


        // public pure virtual
        Standard_Real Magnitude() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Vector,Magnitude,) };
        Standard_Real SquareMagnitude() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Vector,SquareMagnitude,) };
        void Cross(const opencascade::handle<Geom_Vector> & Other) override { PYBIND11_OVERLOAD_PURE(void,Geom_Vector,Cross,Other) };
        opencascade::handle<Geom_Vector> Crossed(const opencascade::handle<Geom_Vector> & Other) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Vector>,Geom_Vector,Crossed,Other) };
        void CrossCross(const opencascade::handle<Geom_Vector> & V1,const opencascade::handle<Geom_Vector> & V2) override { PYBIND11_OVERLOAD_PURE(void,Geom_Vector,CrossCross,V1,V2) };
        opencascade::handle<Geom_Vector> CrossCrossed(const opencascade::handle<Geom_Vector> & V1,const opencascade::handle<Geom_Vector> & V2) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Vector>,Geom_Vector,CrossCrossed,V1,V2) };

        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_BoundedCurve : public Geom_BoundedCurve{
    public:
        using Geom_BoundedCurve::Geom_BoundedCurve;


        // public pure virtual
        gp_Pnt EndPoint() const  override { PYBIND11_OVERLOAD_PURE(gp_Pnt,Geom_BoundedCurve,EndPoint,) };
        gp_Pnt StartPoint() const  override { PYBIND11_OVERLOAD_PURE(gp_Pnt,Geom_BoundedCurve,StartPoint,) };

        void Reverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,Reverse,) };
        Standard_Real ReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,ReversedParameter,U) };
        Standard_Real FirstParameter() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,FirstParameter,) };
        Standard_Real LastParameter() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,LastParameter,) };
        Standard_Boolean IsClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsClosed,) };
        Standard_Boolean IsPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsPeriodic,) };
        GeomAbs_Shape Continuity() const  override { PYBIND11_OVERLOAD_PURE(GeomAbs_Shape,Geom_Curve,Continuity,) };
        Standard_Boolean IsCN(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsCN,N) };
        void D0(const Standard_Real U,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D0,U,P) };
        void D1(const Standard_Real U,gp_Pnt & P,gp_Vec & V1) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D1,U,P,V1) };
        void D2(const Standard_Real U,gp_Pnt & P,gp_Vec & V1,gp_Vec & V2) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D2,U,P,V1,V2) };
        void D3(const Standard_Real U,gp_Pnt & P,gp_Vec & V1,gp_Vec & V2,gp_Vec & V3) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D3,U,P,V1,V2,V3) };
        gp_Vec DN(const Standard_Real U,const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Curve,DN,U,N) };
        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_BoundedSurface : public Geom_BoundedSurface{
    public:
        using Geom_BoundedSurface::Geom_BoundedSurface;


        // public pure virtual

        void UReverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,UReverse,) };
        Standard_Real UReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Surface,UReversedParameter,U) };
        void VReverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,VReverse,) };
        Standard_Real VReversedParameter(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Surface,VReversedParameter,V) };
        Standard_Boolean IsUClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUClosed,) };
        Standard_Boolean IsVClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVClosed,) };
        Standard_Boolean IsUPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUPeriodic,) };
        Standard_Boolean IsVPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVPeriodic,) };
        opencascade::handle<Geom_Curve> UIso(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,UIso,U) };
        opencascade::handle<Geom_Curve> VIso(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,VIso,V) };
        GeomAbs_Shape Continuity() const  override { PYBIND11_OVERLOAD_PURE(GeomAbs_Shape,Geom_Surface,Continuity,) };
        Standard_Boolean IsCNu(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsCNu,N) };
        Standard_Boolean IsCNv(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsCNv,N) };
        void D0(const Standard_Real U,const Standard_Real V,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D0,U,V,P) };
        void D1(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D1,U,V,P,D1U,D1V) };
        void D2(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D2,U,V,P,D1U,D1V,D2U,D2V,D2UV) };
        void D3(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV,gp_Vec & D3U,gp_Vec & D3V,gp_Vec & D3UUV,gp_Vec & D3UVV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D3,U,V,P,D1U,D1V,D2U,D2V,D2UV,D3U,D3V,D3UUV,D3UVV) };
        gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Surface,DN,U,V,Nu,Nv) };
        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_Conic : public Geom_Conic{
    public:
        using Geom_Conic::Geom_Conic;


        // public pure virtual
        Standard_Real Eccentricity() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Conic,Eccentricity,) };
        Standard_Real ReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Conic,ReversedParameter,U) };

        Standard_Real FirstParameter() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,FirstParameter,) };
        Standard_Real LastParameter() const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Curve,LastParameter,) };
        Standard_Boolean IsClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsClosed,) };
        Standard_Boolean IsPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Curve,IsPeriodic,) };
        void D0(const Standard_Real U,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D0,U,P) };
        void D1(const Standard_Real U,gp_Pnt & P,gp_Vec & V1) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D1,U,P,V1) };
        void D2(const Standard_Real U,gp_Pnt & P,gp_Vec & V1,gp_Vec & V2) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D2,U,P,V1,V2) };
        void D3(const Standard_Real U,gp_Pnt & P,gp_Vec & V1,gp_Vec & V2,gp_Vec & V3) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Curve,D3,U,P,V1,V2,V3) };
        gp_Vec DN(const Standard_Real U,const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Curve,DN,U,N) };
        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_ElementarySurface : public Geom_ElementarySurface{
    public:
        using Geom_ElementarySurface::Geom_ElementarySurface;


        // public pure virtual
        Standard_Real UReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_ElementarySurface,UReversedParameter,U) };
        Standard_Real VReversedParameter(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_ElementarySurface,VReversedParameter,V) };

        Standard_Boolean IsUClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUClosed,) };
        Standard_Boolean IsVClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVClosed,) };
        Standard_Boolean IsUPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUPeriodic,) };
        Standard_Boolean IsVPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVPeriodic,) };
        opencascade::handle<Geom_Curve> UIso(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,UIso,U) };
        opencascade::handle<Geom_Curve> VIso(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,VIso,V) };
        void D0(const Standard_Real U,const Standard_Real V,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D0,U,V,P) };
        void D1(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D1,U,V,P,D1U,D1V) };
        void D2(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D2,U,V,P,D1U,D1V,D2U,D2V,D2UV) };
        void D3(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV,gp_Vec & D3U,gp_Vec & D3V,gp_Vec & D3UUV,gp_Vec & D3UVV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D3,U,V,P,D1U,D1V,D2U,D2V,D2UV,D3U,D3V,D3UUV,D3UVV) };
        gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Surface,DN,U,V,Nu,Nv) };
        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };
    class Py_Geom_SweptSurface : public Geom_SweptSurface{
    public:
        using Geom_SweptSurface::Geom_SweptSurface;


        // public pure virtual

        void UReverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,UReverse,) };
        Standard_Real UReversedParameter(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Surface,UReversedParameter,U) };
        void VReverse() override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,VReverse,) };
        Standard_Real VReversedParameter(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(Standard_Real,Geom_Surface,VReversedParameter,V) };
        Standard_Boolean IsUClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUClosed,) };
        Standard_Boolean IsVClosed() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVClosed,) };
        Standard_Boolean IsUPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsUPeriodic,) };
        Standard_Boolean IsVPeriodic() const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsVPeriodic,) };
        opencascade::handle<Geom_Curve> UIso(const Standard_Real U) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,UIso,U) };
        opencascade::handle<Geom_Curve> VIso(const Standard_Real V) const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Curve>,Geom_Surface,VIso,V) };
        Standard_Boolean IsCNu(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsCNu,N) };
        Standard_Boolean IsCNv(const Standard_Integer N) const  override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,Geom_Surface,IsCNv,N) };
        void D0(const Standard_Real U,const Standard_Real V,gp_Pnt & P) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D0,U,V,P) };
        void D1(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D1,U,V,P,D1U,D1V) };
        void D2(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D2,U,V,P,D1U,D1V,D2U,D2V,D2UV) };
        void D3(const Standard_Real U,const Standard_Real V,gp_Pnt & P,gp_Vec & D1U,gp_Vec & D1V,gp_Vec & D2U,gp_Vec & D2V,gp_Vec & D2UV,gp_Vec & D3U,gp_Vec & D3V,gp_Vec & D3UUV,gp_Vec & D3UVV) const  override { PYBIND11_OVERLOAD_PURE(void,Geom_Surface,D3,U,V,P,D1U,D1V,D2U,D2V,D2UV,D3U,D3V,D3UUV,D3UVV) };
        gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const  override { PYBIND11_OVERLOAD_PURE(gp_Vec,Geom_Surface,DN,U,V,Nu,Nv) };
        void Transform(const gp_Trsf & T) override { PYBIND11_OVERLOAD_PURE(void,Geom_Geometry,Transform,T) };
        opencascade::handle<Geom_Geometry> Copy() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<Geom_Geometry>,Geom_Geometry,Copy,) };

        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<Geom_Geometry ,opencascade::handle<Geom_Geometry> ,Py_Geom_Geometry , Standard_Transient >(m,"Geom_Geometry",R"#(The abstract class Geometry for 3D space is the root class of all geometric objects from the Geom package. It describes the common behavior of these objects when: - applying geometric transformations to objects, and - constructing objects by geometric transformation (including copying). Warning Only transformations which do not modify the nature of the geometry can be applied to Geom objects: this is the case with translations, rotations, symmetries and scales; this is also the case with gp_Trsf composite transformations which are used to define the geometric transformations applied using the Transform or Transformed functions. Note: Geometry defines the "prototype" of the abstract method Transform which is defined for each concrete type of derived object. All other transformations are implemented using the Transform method.The abstract class Geometry for 3D space is the root class of all geometric objects from the Geom package. It describes the common behavior of these objects when: - applying geometric transformations to objects, and - constructing objects by geometric transformation (including copying). Warning Only transformations which do not modify the nature of the geometry can be applied to Geom objects: this is the case with translations, rotations, symmetries and scales; this is also the case with gp_Trsf composite transformations which are used to define the geometric transformations applied using the Transform or Transformed functions. Note: Geometry defines the "prototype" of the abstract method Transform which is defined for each concrete type of derived object. All other transformations are implemented using the Transform method.The abstract class Geometry for 3D space is the root class of all geometric objects from the Geom package. It describes the common behavior of these objects when: - applying geometric transformations to objects, and - constructing objects by geometric transformation (including copying). Warning Only transformations which do not modify the nature of the geometry can be applied to Geom objects: this is the case with translations, rotations, symmetries and scales; this is also the case with gp_Trsf composite transformations which are used to define the geometric transformations applied using the Transform or Transformed functions. Note: Geometry defines the "prototype" of the abstract method Transform which is defined for each concrete type of derived object. All other transformations are implemented using the Transform method.)#");
    py::class_<Geom_OsculatingSurface ,opencascade::handle<Geom_OsculatingSurface>  , Standard_Transient >(m,"Geom_OsculatingSurface",R"#()#");
    preregister_template_NCollection_Sequence<opencascade::handle<Geom_BSplineSurface>>(m,"Geom_SequenceOfBSplineSurface");
    py::class_<Geom_Transformation ,opencascade::handle<Geom_Transformation>  , Standard_Transient >(m,"Geom_Transformation",R"#(Describes how to construct the following elementary transformations - translations, - rotations, - symmetries, - scales. The Transformation class can also be used to construct complex transformations by combining these elementary transformations. However, these transformations can never change the type of an object. For example, the projection transformation can change a circle into an ellipse, and therefore change the real type of the object. Such a transformation is forbidden in this environment and cannot be a Geom_Transformation. The transformation can be represented as follow :Describes how to construct the following elementary transformations - translations, - rotations, - symmetries, - scales. The Transformation class can also be used to construct complex transformations by combining these elementary transformations. However, these transformations can never change the type of an object. For example, the projection transformation can change a circle into an ellipse, and therefore change the real type of the object. Such a transformation is forbidden in this environment and cannot be a Geom_Transformation. The transformation can be represented as follow :)#");
    py::class_<Geom_AxisPlacement ,opencascade::handle<Geom_AxisPlacement> ,Py_Geom_AxisPlacement , Geom_Geometry >(m,"Geom_AxisPlacement",R"#(The abstract class AxisPlacement describes the common behavior of positioning systems in 3D space, such as axis or coordinate systems. The Geom package provides two implementations of 3D positioning systems: - the axis (Geom_Axis1Placement class), which is defined by: - its origin, also termed the "Location point" of the axis, - its unit vector, termed the "Direction" or "main Direction" of the axis; - the right-handed coordinate system (Geom_Axis2Placement class), which is defined by: - its origin, also termed the "Location point" of the coordinate system, - three orthogonal unit vectors, termed respectively the "X Direction", the "Y Direction" and the "Direction" of the coordinate system. As the coordinate system is right-handed, these unit vectors have the following relation: "Direction" = "X Direction" ^ "Y Direction". The "Direction" is also called the "main Direction" because, when the unit vector is modified, the "X Direction" and "Y Direction" are recomputed, whereas when the "X Direction" or "Y Direction" is modified, the "main Direction" does not change. The axis whose origin is the origin of the positioning system and whose unit vector is its "main Direction" is also called the "Axis" or "main Axis" of the positioning system.The abstract class AxisPlacement describes the common behavior of positioning systems in 3D space, such as axis or coordinate systems. The Geom package provides two implementations of 3D positioning systems: - the axis (Geom_Axis1Placement class), which is defined by: - its origin, also termed the "Location point" of the axis, - its unit vector, termed the "Direction" or "main Direction" of the axis; - the right-handed coordinate system (Geom_Axis2Placement class), which is defined by: - its origin, also termed the "Location point" of the coordinate system, - three orthogonal unit vectors, termed respectively the "X Direction", the "Y Direction" and the "Direction" of the coordinate system. As the coordinate system is right-handed, these unit vectors have the following relation: "Direction" = "X Direction" ^ "Y Direction". The "Direction" is also called the "main Direction" because, when the unit vector is modified, the "X Direction" and "Y Direction" are recomputed, whereas when the "X Direction" or "Y Direction" is modified, the "main Direction" does not change. The axis whose origin is the origin of the positioning system and whose unit vector is its "main Direction" is also called the "Axis" or "main Axis" of the positioning system.The abstract class AxisPlacement describes the common behavior of positioning systems in 3D space, such as axis or coordinate systems. The Geom package provides two implementations of 3D positioning systems: - the axis (Geom_Axis1Placement class), which is defined by: - its origin, also termed the "Location point" of the axis, - its unit vector, termed the "Direction" or "main Direction" of the axis; - the right-handed coordinate system (Geom_Axis2Placement class), which is defined by: - its origin, also termed the "Location point" of the coordinate system, - three orthogonal unit vectors, termed respectively the "X Direction", the "Y Direction" and the "Direction" of the coordinate system. As the coordinate system is right-handed, these unit vectors have the following relation: "Direction" = "X Direction" ^ "Y Direction". The "Direction" is also called the "main Direction" because, when the unit vector is modified, the "X Direction" and "Y Direction" are recomputed, whereas when the "X Direction" or "Y Direction" is modified, the "main Direction" does not change. The axis whose origin is the origin of the positioning system and whose unit vector is its "main Direction" is also called the "Axis" or "main Axis" of the positioning system.)#");
    py::class_<Geom_Curve ,opencascade::handle<Geom_Curve> ,Py_Geom_Curve , Geom_Geometry >(m,"Geom_Curve",R"#(The abstract class Curve describes the common behavior of curves in 3D space. The Geom package provides numerous concrete classes of derived curves, including lines, circles, conics, Bezier or BSpline curves, etc. The main characteristic of these curves is that they are parameterized. The Geom_Curve class shows: - how to work with the parametric equation of a curve in order to calculate the point of parameter u, together with the vector tangent and the derivative vectors of order 2, 3,..., N at this point; - how to obtain general information about the curve (for example, level of continuity, closed characteristics, periodicity, bounds of the parameter field); - how the parameter changes when a geometric transformation is applied to the curve or when the orientation of the curve is inverted. All curves must have a geometric continuity: a curve is at least "C0". Generally, this property is checked at the time of construction or when the curve is edited. Where this is not the case, the documentation states so explicitly. Warning The Geom package does not prevent the construction of curves with null length or curves which self-intersect.The abstract class Curve describes the common behavior of curves in 3D space. The Geom package provides numerous concrete classes of derived curves, including lines, circles, conics, Bezier or BSpline curves, etc. The main characteristic of these curves is that they are parameterized. The Geom_Curve class shows: - how to work with the parametric equation of a curve in order to calculate the point of parameter u, together with the vector tangent and the derivative vectors of order 2, 3,..., N at this point; - how to obtain general information about the curve (for example, level of continuity, closed characteristics, periodicity, bounds of the parameter field); - how the parameter changes when a geometric transformation is applied to the curve or when the orientation of the curve is inverted. All curves must have a geometric continuity: a curve is at least "C0". Generally, this property is checked at the time of construction or when the curve is edited. Where this is not the case, the documentation states so explicitly. Warning The Geom package does not prevent the construction of curves with null length or curves which self-intersect.The abstract class Curve describes the common behavior of curves in 3D space. The Geom package provides numerous concrete classes of derived curves, including lines, circles, conics, Bezier or BSpline curves, etc. The main characteristic of these curves is that they are parameterized. The Geom_Curve class shows: - how to work with the parametric equation of a curve in order to calculate the point of parameter u, together with the vector tangent and the derivative vectors of order 2, 3,..., N at this point; - how to obtain general information about the curve (for example, level of continuity, closed characteristics, periodicity, bounds of the parameter field); - how the parameter changes when a geometric transformation is applied to the curve or when the orientation of the curve is inverted. All curves must have a geometric continuity: a curve is at least "C0". Generally, this property is checked at the time of construction or when the curve is edited. Where this is not the case, the documentation states so explicitly. Warning The Geom package does not prevent the construction of curves with null length or curves which self-intersect.)#");
    py::class_<Geom_HSequenceOfBSplineSurface ,opencascade::handle<Geom_HSequenceOfBSplineSurface>  , Geom_SequenceOfBSplineSurface , Standard_Transient >(m,"Geom_HSequenceOfBSplineSurface",R"#()#");
    py::class_<Geom_Point ,opencascade::handle<Geom_Point> ,Py_Geom_Point , Geom_Geometry >(m,"Geom_Point",R"#(The abstract class Point describes the common behavior of geometric points in 3D space. The Geom package also provides the concrete class Geom_CartesianPoint.The abstract class Point describes the common behavior of geometric points in 3D space. The Geom package also provides the concrete class Geom_CartesianPoint.The abstract class Point describes the common behavior of geometric points in 3D space. The Geom package also provides the concrete class Geom_CartesianPoint.)#");
    py::class_<Geom_Surface ,opencascade::handle<Geom_Surface> ,Py_Geom_Surface , Geom_Geometry >(m,"Geom_Surface",R"#(Describes the common behavior of surfaces in 3D space. The Geom package provides many implementations of concrete derived surfaces, such as planes, cylinders, cones, spheres and tori, surfaces of linear extrusion, surfaces of revolution, Bezier and BSpline surfaces, and so on. The key characteristic of these surfaces is that they are parameterized. Geom_Surface demonstrates: - how to work with the parametric equation of a surface to compute the point of parameters (u, v), and, at this point, the 1st, 2nd ... Nth derivative; - how to find global information about a surface in each parametric direction (for example, level of continuity, whether the surface is closed, its periodicity, the bounds of the parameters and so on); - how the parameters change when geometric transformations are applied to the surface, or the orientation is modified.Describes the common behavior of surfaces in 3D space. The Geom package provides many implementations of concrete derived surfaces, such as planes, cylinders, cones, spheres and tori, surfaces of linear extrusion, surfaces of revolution, Bezier and BSpline surfaces, and so on. The key characteristic of these surfaces is that they are parameterized. Geom_Surface demonstrates: - how to work with the parametric equation of a surface to compute the point of parameters (u, v), and, at this point, the 1st, 2nd ... Nth derivative; - how to find global information about a surface in each parametric direction (for example, level of continuity, whether the surface is closed, its periodicity, the bounds of the parameters and so on); - how the parameters change when geometric transformations are applied to the surface, or the orientation is modified.Describes the common behavior of surfaces in 3D space. The Geom package provides many implementations of concrete derived surfaces, such as planes, cylinders, cones, spheres and tori, surfaces of linear extrusion, surfaces of revolution, Bezier and BSpline surfaces, and so on. The key characteristic of these surfaces is that they are parameterized. Geom_Surface demonstrates: - how to work with the parametric equation of a surface to compute the point of parameters (u, v), and, at this point, the 1st, 2nd ... Nth derivative; - how to find global information about a surface in each parametric direction (for example, level of continuity, whether the surface is closed, its periodicity, the bounds of the parameters and so on); - how the parameters change when geometric transformations are applied to the surface, or the orientation is modified.)#");
    py::class_<Geom_Vector ,opencascade::handle<Geom_Vector> ,Py_Geom_Vector , Geom_Geometry >(m,"Geom_Vector",R"#(The abstract class Vector describes the common behavior of vectors in 3D space. The Geom package provides two concrete classes of vectors: Geom_Direction (unit vector) and Geom_VectorWithMagnitude.The abstract class Vector describes the common behavior of vectors in 3D space. The Geom package provides two concrete classes of vectors: Geom_Direction (unit vector) and Geom_VectorWithMagnitude.The abstract class Vector describes the common behavior of vectors in 3D space. The Geom package provides two concrete classes of vectors: Geom_Direction (unit vector) and Geom_VectorWithMagnitude.)#");
    py::class_<Geom_Axis1Placement ,opencascade::handle<Geom_Axis1Placement>  , Geom_AxisPlacement >(m,"Geom_Axis1Placement",R"#(Describes an axis in 3D space. An axis is defined by: - its origin, also termed the "Location point" of the axis, - its unit vector, termed the "Direction" of the axis. Note: Geom_Axis1Placement axes provide the same kind of "geometric" services as gp_Ax1 axes but have more complex data structures. The geometric objects provided by the Geom package use gp_Ax1 objects to include axes in their data structures, or to define an axis of symmetry or axis of rotation. Geom_Axis1Placement axes are used in a context where they can be shared by several objects contained inside a common data structure.Describes an axis in 3D space. An axis is defined by: - its origin, also termed the "Location point" of the axis, - its unit vector, termed the "Direction" of the axis. Note: Geom_Axis1Placement axes provide the same kind of "geometric" services as gp_Ax1 axes but have more complex data structures. The geometric objects provided by the Geom package use gp_Ax1 objects to include axes in their data structures, or to define an axis of symmetry or axis of rotation. Geom_Axis1Placement axes are used in a context where they can be shared by several objects contained inside a common data structure.Describes an axis in 3D space. An axis is defined by: - its origin, also termed the "Location point" of the axis, - its unit vector, termed the "Direction" of the axis. Note: Geom_Axis1Placement axes provide the same kind of "geometric" services as gp_Ax1 axes but have more complex data structures. The geometric objects provided by the Geom package use gp_Ax1 objects to include axes in their data structures, or to define an axis of symmetry or axis of rotation. Geom_Axis1Placement axes are used in a context where they can be shared by several objects contained inside a common data structure.)#");
    py::class_<Geom_Axis2Placement ,opencascade::handle<Geom_Axis2Placement>  , Geom_AxisPlacement >(m,"Geom_Axis2Placement",R"#(Describes a right-handed coordinate system in 3D space. A coordinate system is defined by: - its origin, also termed the "Location point" of the coordinate system, - three orthogonal unit vectors, termed respectively the "X Direction", "Y Direction" and "Direction" (or "main Direction") of the coordinate system. As a Geom_Axis2Placement coordinate system is right-handed, its "Direction" is always equal to the cross product of its "X Direction" and "Y Direction". The "Direction" of a coordinate system is called the "main Direction" because when this unit vector is modified, the "X Direction" and "Y Direction" are recomputed, whereas when the "X Direction" or "Y Direction" is changed, the "main Direction" is retained. The "main Direction" is also the "Z Direction". Note: Geom_Axis2Placement coordinate systems provide the same kind of "geometric" services as gp_Ax2 coordinate systems but have more complex data structures. The geometric objects provided by the Geom package use gp_Ax2 objects to include coordinate systems in their data structures, or to define the geometric transformations, which are applied to them. Geom_Axis2Placement coordinate systems are used in a context where they can be shared by several objects contained inside a common data structure.Describes a right-handed coordinate system in 3D space. A coordinate system is defined by: - its origin, also termed the "Location point" of the coordinate system, - three orthogonal unit vectors, termed respectively the "X Direction", "Y Direction" and "Direction" (or "main Direction") of the coordinate system. As a Geom_Axis2Placement coordinate system is right-handed, its "Direction" is always equal to the cross product of its "X Direction" and "Y Direction". The "Direction" of a coordinate system is called the "main Direction" because when this unit vector is modified, the "X Direction" and "Y Direction" are recomputed, whereas when the "X Direction" or "Y Direction" is changed, the "main Direction" is retained. The "main Direction" is also the "Z Direction". Note: Geom_Axis2Placement coordinate systems provide the same kind of "geometric" services as gp_Ax2 coordinate systems but have more complex data structures. The geometric objects provided by the Geom package use gp_Ax2 objects to include coordinate systems in their data structures, or to define the geometric transformations, which are applied to them. Geom_Axis2Placement coordinate systems are used in a context where they can be shared by several objects contained inside a common data structure.Describes a right-handed coordinate system in 3D space. A coordinate system is defined by: - its origin, also termed the "Location point" of the coordinate system, - three orthogonal unit vectors, termed respectively the "X Direction", "Y Direction" and "Direction" (or "main Direction") of the coordinate system. As a Geom_Axis2Placement coordinate system is right-handed, its "Direction" is always equal to the cross product of its "X Direction" and "Y Direction". The "Direction" of a coordinate system is called the "main Direction" because when this unit vector is modified, the "X Direction" and "Y Direction" are recomputed, whereas when the "X Direction" or "Y Direction" is changed, the "main Direction" is retained. The "main Direction" is also the "Z Direction". Note: Geom_Axis2Placement coordinate systems provide the same kind of "geometric" services as gp_Ax2 coordinate systems but have more complex data structures. The geometric objects provided by the Geom package use gp_Ax2 objects to include coordinate systems in their data structures, or to define the geometric transformations, which are applied to them. Geom_Axis2Placement coordinate systems are used in a context where they can be shared by several objects contained inside a common data structure.)#");
    py::class_<Geom_BoundedCurve ,opencascade::handle<Geom_BoundedCurve> ,Py_Geom_BoundedCurve , Geom_Curve >(m,"Geom_BoundedCurve",R"#(The abstract class BoundedCurve describes the common behavior of bounded curves in 3D space. A bounded curve is limited by two finite values of the parameter, termed respectively "first parameter" and "last parameter". The "first parameter" gives the "start point" of the bounded curve, and the "last parameter" gives the "end point" of the bounded curve. The length of a bounded curve is finite. The Geom package provides three concrete classes of bounded curves: - two frequently used mathematical formulations of complex curves: - Geom_BezierCurve, - Geom_BSplineCurve, and - Geom_TrimmedCurve to trim a curve, i.e. to only take part of the curve limited by two values of the parameter of the basis curve.The abstract class BoundedCurve describes the common behavior of bounded curves in 3D space. A bounded curve is limited by two finite values of the parameter, termed respectively "first parameter" and "last parameter". The "first parameter" gives the "start point" of the bounded curve, and the "last parameter" gives the "end point" of the bounded curve. The length of a bounded curve is finite. The Geom package provides three concrete classes of bounded curves: - two frequently used mathematical formulations of complex curves: - Geom_BezierCurve, - Geom_BSplineCurve, and - Geom_TrimmedCurve to trim a curve, i.e. to only take part of the curve limited by two values of the parameter of the basis curve.The abstract class BoundedCurve describes the common behavior of bounded curves in 3D space. A bounded curve is limited by two finite values of the parameter, termed respectively "first parameter" and "last parameter". The "first parameter" gives the "start point" of the bounded curve, and the "last parameter" gives the "end point" of the bounded curve. The length of a bounded curve is finite. The Geom package provides three concrete classes of bounded curves: - two frequently used mathematical formulations of complex curves: - Geom_BezierCurve, - Geom_BSplineCurve, and - Geom_TrimmedCurve to trim a curve, i.e. to only take part of the curve limited by two values of the parameter of the basis curve.)#");
    py::class_<Geom_BoundedSurface ,opencascade::handle<Geom_BoundedSurface> ,Py_Geom_BoundedSurface , Geom_Surface >(m,"Geom_BoundedSurface",R"#(The root class for bounded surfaces in 3D space. A bounded surface is defined by a rectangle in its 2D parametric space, i.e. - its u parameter, which ranges between two finite values u0 and u1, referred to as "First u parameter" and "Last u parameter" respectively, and - its v parameter, which ranges between two finite values v0 and v1, referred to as "First v parameter" and the "Last v parameter" respectively. The surface is limited by four curves which are the boundaries of the surface: - its u0 and u1 isoparametric curves in the u parametric direction, and - its v0 and v1 isoparametric curves in the v parametric direction. A bounded surface is finite. The common behavior of all bounded surfaces is described by the Geom_Surface class. The Geom package provides three concrete implementations of bounded surfaces: - Geom_BezierSurface, - Geom_BSplineSurface, and - Geom_RectangularTrimmedSurface. The first two of these implement well known mathematical definitions of complex surfaces, the third trims a surface using four isoparametric curves, i.e. it limits the variation of its parameters to a rectangle in 2D parametric space.The root class for bounded surfaces in 3D space. A bounded surface is defined by a rectangle in its 2D parametric space, i.e. - its u parameter, which ranges between two finite values u0 and u1, referred to as "First u parameter" and "Last u parameter" respectively, and - its v parameter, which ranges between two finite values v0 and v1, referred to as "First v parameter" and the "Last v parameter" respectively. The surface is limited by four curves which are the boundaries of the surface: - its u0 and u1 isoparametric curves in the u parametric direction, and - its v0 and v1 isoparametric curves in the v parametric direction. A bounded surface is finite. The common behavior of all bounded surfaces is described by the Geom_Surface class. The Geom package provides three concrete implementations of bounded surfaces: - Geom_BezierSurface, - Geom_BSplineSurface, and - Geom_RectangularTrimmedSurface. The first two of these implement well known mathematical definitions of complex surfaces, the third trims a surface using four isoparametric curves, i.e. it limits the variation of its parameters to a rectangle in 2D parametric space.The root class for bounded surfaces in 3D space. A bounded surface is defined by a rectangle in its 2D parametric space, i.e. - its u parameter, which ranges between two finite values u0 and u1, referred to as "First u parameter" and "Last u parameter" respectively, and - its v parameter, which ranges between two finite values v0 and v1, referred to as "First v parameter" and the "Last v parameter" respectively. The surface is limited by four curves which are the boundaries of the surface: - its u0 and u1 isoparametric curves in the u parametric direction, and - its v0 and v1 isoparametric curves in the v parametric direction. A bounded surface is finite. The common behavior of all bounded surfaces is described by the Geom_Surface class. The Geom package provides three concrete implementations of bounded surfaces: - Geom_BezierSurface, - Geom_BSplineSurface, and - Geom_RectangularTrimmedSurface. The first two of these implement well known mathematical definitions of complex surfaces, the third trims a surface using four isoparametric curves, i.e. it limits the variation of its parameters to a rectangle in 2D parametric space.)#");
    py::class_<Geom_CartesianPoint ,opencascade::handle<Geom_CartesianPoint>  , Geom_Point >(m,"Geom_CartesianPoint",R"#(Describes a point in 3D space. A Geom_CartesianPoint is defined by a gp_Pnt point, with its three Cartesian coordinates X, Y and Z.Describes a point in 3D space. A Geom_CartesianPoint is defined by a gp_Pnt point, with its three Cartesian coordinates X, Y and Z.Describes a point in 3D space. A Geom_CartesianPoint is defined by a gp_Pnt point, with its three Cartesian coordinates X, Y and Z.)#");
    py::class_<Geom_Conic ,opencascade::handle<Geom_Conic> ,Py_Geom_Conic , Geom_Curve >(m,"Geom_Conic",R"#(The abstract class Conic describes the common behavior of conic curves in 3D space and, in particular, their general characteristics. The Geom package provides four concrete classes of conics: Geom_Circle, Geom_Ellipse, Geom_Hyperbola and Geom_Parabola. A conic is positioned in space with a right-handed coordinate system (gp_Ax2 object), where: - the origin is the center of the conic (or the apex in the case of a parabola), - the origin, "X Direction" and "Y Direction" define the plane of the conic. This coordinate system is the local coordinate system of the conic. The "main Direction" of this coordinate system is the vector normal to the plane of the conic. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the conic. The "main Direction" of the local coordinate system gives an explicit orientation to the conic, determining the direction in which the parameter increases along the conic. The "X Axis" of the local coordinate system also defines the origin of the parameter of the conic.The abstract class Conic describes the common behavior of conic curves in 3D space and, in particular, their general characteristics. The Geom package provides four concrete classes of conics: Geom_Circle, Geom_Ellipse, Geom_Hyperbola and Geom_Parabola. A conic is positioned in space with a right-handed coordinate system (gp_Ax2 object), where: - the origin is the center of the conic (or the apex in the case of a parabola), - the origin, "X Direction" and "Y Direction" define the plane of the conic. This coordinate system is the local coordinate system of the conic. The "main Direction" of this coordinate system is the vector normal to the plane of the conic. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the conic. The "main Direction" of the local coordinate system gives an explicit orientation to the conic, determining the direction in which the parameter increases along the conic. The "X Axis" of the local coordinate system also defines the origin of the parameter of the conic.The abstract class Conic describes the common behavior of conic curves in 3D space and, in particular, their general characteristics. The Geom package provides four concrete classes of conics: Geom_Circle, Geom_Ellipse, Geom_Hyperbola and Geom_Parabola. A conic is positioned in space with a right-handed coordinate system (gp_Ax2 object), where: - the origin is the center of the conic (or the apex in the case of a parabola), - the origin, "X Direction" and "Y Direction" define the plane of the conic. This coordinate system is the local coordinate system of the conic. The "main Direction" of this coordinate system is the vector normal to the plane of the conic. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the conic. The "main Direction" of the local coordinate system gives an explicit orientation to the conic, determining the direction in which the parameter increases along the conic. The "X Axis" of the local coordinate system also defines the origin of the parameter of the conic.)#");
    py::class_<Geom_Direction ,opencascade::handle<Geom_Direction>  , Geom_Vector >(m,"Geom_Direction",R"#(The class Direction specifies a vector that is never null. It is a unit vector.The class Direction specifies a vector that is never null. It is a unit vector.The class Direction specifies a vector that is never null. It is a unit vector.)#");
    py::class_<Geom_ElementarySurface ,opencascade::handle<Geom_ElementarySurface> ,Py_Geom_ElementarySurface , Geom_Surface >(m,"Geom_ElementarySurface",R"#(Describes the common behavior of surfaces which have a simple parametric equation in a local coordinate system. The Geom package provides several implementations of concrete elementary surfaces: - the plane, and - four simple surfaces of revolution: the cylinder, the cone, the sphere and the torus. An elementary surface inherits the common behavior of Geom_Surface surfaces. Furthermore, it is located in 3D space by a coordinate system (a gp_Ax3 object) which is also its local coordinate system. Any elementary surface is oriented, i.e. the normal vector is always defined, and gives the same orientation to the surface, at any point on the surface. In topology this property is referred to as the "outside region of the surface". This orientation is related to the two parametric directions of the surface. Rotation of a surface around the "main Axis" of its coordinate system, in the trigonometric sense given by the "X Direction" and the "Y Direction" of the coordinate system, defines the u parametric direction of that elementary surface of revolution. This is the default construction mode. It is also possible, however, to change the orientation of a surface by reversing one of the two parametric directions: use the UReverse or VReverse functions to change the orientation of the normal at any point on the surface. Warning The local coordinate system of an elementary surface is not necessarily direct: - if it is direct, the trigonometric sense defined by its "main Direction" is the same as the trigonometric sense defined by its two vectors "X Direction" and "Y Direction": "main Direction" = "X Direction" ^ "Y Direction" - if it is indirect, the two definitions of trigonometric sense are opposite: "main Direction" = - "X Direction" ^ "Y Direction"Describes the common behavior of surfaces which have a simple parametric equation in a local coordinate system. The Geom package provides several implementations of concrete elementary surfaces: - the plane, and - four simple surfaces of revolution: the cylinder, the cone, the sphere and the torus. An elementary surface inherits the common behavior of Geom_Surface surfaces. Furthermore, it is located in 3D space by a coordinate system (a gp_Ax3 object) which is also its local coordinate system. Any elementary surface is oriented, i.e. the normal vector is always defined, and gives the same orientation to the surface, at any point on the surface. In topology this property is referred to as the "outside region of the surface". This orientation is related to the two parametric directions of the surface. Rotation of a surface around the "main Axis" of its coordinate system, in the trigonometric sense given by the "X Direction" and the "Y Direction" of the coordinate system, defines the u parametric direction of that elementary surface of revolution. This is the default construction mode. It is also possible, however, to change the orientation of a surface by reversing one of the two parametric directions: use the UReverse or VReverse functions to change the orientation of the normal at any point on the surface. Warning The local coordinate system of an elementary surface is not necessarily direct: - if it is direct, the trigonometric sense defined by its "main Direction" is the same as the trigonometric sense defined by its two vectors "X Direction" and "Y Direction": "main Direction" = "X Direction" ^ "Y Direction" - if it is indirect, the two definitions of trigonometric sense are opposite: "main Direction" = - "X Direction" ^ "Y Direction"Describes the common behavior of surfaces which have a simple parametric equation in a local coordinate system. The Geom package provides several implementations of concrete elementary surfaces: - the plane, and - four simple surfaces of revolution: the cylinder, the cone, the sphere and the torus. An elementary surface inherits the common behavior of Geom_Surface surfaces. Furthermore, it is located in 3D space by a coordinate system (a gp_Ax3 object) which is also its local coordinate system. Any elementary surface is oriented, i.e. the normal vector is always defined, and gives the same orientation to the surface, at any point on the surface. In topology this property is referred to as the "outside region of the surface". This orientation is related to the two parametric directions of the surface. Rotation of a surface around the "main Axis" of its coordinate system, in the trigonometric sense given by the "X Direction" and the "Y Direction" of the coordinate system, defines the u parametric direction of that elementary surface of revolution. This is the default construction mode. It is also possible, however, to change the orientation of a surface by reversing one of the two parametric directions: use the UReverse or VReverse functions to change the orientation of the normal at any point on the surface. Warning The local coordinate system of an elementary surface is not necessarily direct: - if it is direct, the trigonometric sense defined by its "main Direction" is the same as the trigonometric sense defined by its two vectors "X Direction" and "Y Direction": "main Direction" = "X Direction" ^ "Y Direction" - if it is indirect, the two definitions of trigonometric sense are opposite: "main Direction" = - "X Direction" ^ "Y Direction")#");
    py::class_<Geom_Line ,opencascade::handle<Geom_Line>  , Geom_Curve >(m,"Geom_Line",R"#(Describes an infinite line. A line is defined and positioned in space with an axis (gp_Ax1 object) which gives it an origin and a unit vector. The Geom_Line line is parameterized: P (U) = O + U*Dir, where: - P is the point of parameter U, - O is the origin and Dir the unit vector of its positioning axis. The parameter range is ] -infinite, +infinite [. The orientation of the line is given by the unit vector of its positioning axis.Describes an infinite line. A line is defined and positioned in space with an axis (gp_Ax1 object) which gives it an origin and a unit vector. The Geom_Line line is parameterized: P (U) = O + U*Dir, where: - P is the point of parameter U, - O is the origin and Dir the unit vector of its positioning axis. The parameter range is ] -infinite, +infinite [. The orientation of the line is given by the unit vector of its positioning axis.Describes an infinite line. A line is defined and positioned in space with an axis (gp_Ax1 object) which gives it an origin and a unit vector. The Geom_Line line is parameterized: P (U) = O + U*Dir, where: - P is the point of parameter U, - O is the origin and Dir the unit vector of its positioning axis. The parameter range is ] -infinite, +infinite [. The orientation of the line is given by the unit vector of its positioning axis.)#");
    py::class_<Geom_OffsetCurve ,opencascade::handle<Geom_OffsetCurve>  , Geom_Curve >(m,"Geom_OffsetCurve",R"#(This class implements the basis services for an offset curve in 3D space. The Offset curve in this package can be a self intersecting curve even if the basis curve does not self-intersect. The self intersecting portions are not deleted at the construction time. An offset curve is a curve at constant distance (Offset) from a basis curve in a reference direction V. The offset curve takes its parametrization from the basis curve. The Offset curve is in the direction of the normal N defined with the cross product T^V, where the vector T is given by the first derivative on the basis curve with non zero length. The distance offset may be positive or negative to indicate the preferred side of the curve : . distance offset >0 => the curve is in the direction of N . distance offset <0 => the curve is in the direction of - NThis class implements the basis services for an offset curve in 3D space. The Offset curve in this package can be a self intersecting curve even if the basis curve does not self-intersect. The self intersecting portions are not deleted at the construction time. An offset curve is a curve at constant distance (Offset) from a basis curve in a reference direction V. The offset curve takes its parametrization from the basis curve. The Offset curve is in the direction of the normal N defined with the cross product T^V, where the vector T is given by the first derivative on the basis curve with non zero length. The distance offset may be positive or negative to indicate the preferred side of the curve : . distance offset >0 => the curve is in the direction of N . distance offset <0 => the curve is in the direction of - NThis class implements the basis services for an offset curve in 3D space. The Offset curve in this package can be a self intersecting curve even if the basis curve does not self-intersect. The self intersecting portions are not deleted at the construction time. An offset curve is a curve at constant distance (Offset) from a basis curve in a reference direction V. The offset curve takes its parametrization from the basis curve. The Offset curve is in the direction of the normal N defined with the cross product T^V, where the vector T is given by the first derivative on the basis curve with non zero length. The distance offset may be positive or negative to indicate the preferred side of the curve : . distance offset >0 => the curve is in the direction of N . distance offset <0 => the curve is in the direction of - N)#");
    py::class_<Geom_OffsetSurface ,opencascade::handle<Geom_OffsetSurface>  , Geom_Surface >(m,"Geom_OffsetSurface",R"#(Describes an offset surface in 3D space. An offset surface is defined by: - the basis surface to which it is parallel, and - the distance between the offset surface and its basis surface. A point on the offset surface is built by measuring the offset value along the normal vector at a point on the basis surface. This normal vector is given by the cross product D1u^D1v, where D1u and D1v are the vectors tangential to the basis surface in the u and v parametric directions at this point. The side of the basis surface on which the offset is measured depends on the sign of the offset value. A Geom_OffsetSurface surface can be self-intersecting, even if the basis surface does not self-intersect. The self-intersecting portions are not deleted at the time of construction. Warning There must be only one normal vector defined at any point on the basis surface. This must be verified by the user as no check is made at the time of construction to detect points with multiple possible normal directions (for example, the top of a conical surface).Describes an offset surface in 3D space. An offset surface is defined by: - the basis surface to which it is parallel, and - the distance between the offset surface and its basis surface. A point on the offset surface is built by measuring the offset value along the normal vector at a point on the basis surface. This normal vector is given by the cross product D1u^D1v, where D1u and D1v are the vectors tangential to the basis surface in the u and v parametric directions at this point. The side of the basis surface on which the offset is measured depends on the sign of the offset value. A Geom_OffsetSurface surface can be self-intersecting, even if the basis surface does not self-intersect. The self-intersecting portions are not deleted at the time of construction. Warning There must be only one normal vector defined at any point on the basis surface. This must be verified by the user as no check is made at the time of construction to detect points with multiple possible normal directions (for example, the top of a conical surface).Describes an offset surface in 3D space. An offset surface is defined by: - the basis surface to which it is parallel, and - the distance between the offset surface and its basis surface. A point on the offset surface is built by measuring the offset value along the normal vector at a point on the basis surface. This normal vector is given by the cross product D1u^D1v, where D1u and D1v are the vectors tangential to the basis surface in the u and v parametric directions at this point. The side of the basis surface on which the offset is measured depends on the sign of the offset value. A Geom_OffsetSurface surface can be self-intersecting, even if the basis surface does not self-intersect. The self-intersecting portions are not deleted at the time of construction. Warning There must be only one normal vector defined at any point on the basis surface. This must be verified by the user as no check is made at the time of construction to detect points with multiple possible normal directions (for example, the top of a conical surface).)#");
    py::class_<Geom_SweptSurface ,opencascade::handle<Geom_SweptSurface> ,Py_Geom_SweptSurface , Geom_Surface >(m,"Geom_SweptSurface",R"#(Describes the common behavior for surfaces constructed by sweeping a curve with another curve. The Geom package provides two concrete derived surfaces: surface of revolution (a revolved surface), and surface of linear extrusion (an extruded surface).Describes the common behavior for surfaces constructed by sweeping a curve with another curve. The Geom package provides two concrete derived surfaces: surface of revolution (a revolved surface), and surface of linear extrusion (an extruded surface).Describes the common behavior for surfaces constructed by sweeping a curve with another curve. The Geom package provides two concrete derived surfaces: surface of revolution (a revolved surface), and surface of linear extrusion (an extruded surface).)#");
    py::class_<Geom_VectorWithMagnitude ,opencascade::handle<Geom_VectorWithMagnitude>  , Geom_Vector >(m,"Geom_VectorWithMagnitude",R"#(Defines a vector with magnitude. A vector with magnitude can have a zero length.Defines a vector with magnitude. A vector with magnitude can have a zero length.Defines a vector with magnitude. A vector with magnitude can have a zero length.)#");
    py::class_<Geom_BSplineCurve ,opencascade::handle<Geom_BSplineCurve>  , Geom_BoundedCurve >(m,"Geom_BSplineCurve",R"#(Definition of the B_spline curve. A B-spline curve can be Uniform or non-uniform Rational or non-rational Periodic or non-periodicDefinition of the B_spline curve. A B-spline curve can be Uniform or non-uniform Rational or non-rational Periodic or non-periodicDefinition of the B_spline curve. A B-spline curve can be Uniform or non-uniform Rational or non-rational Periodic or non-periodic)#");
    py::class_<Geom_BSplineSurface ,opencascade::handle<Geom_BSplineSurface>  , Geom_BoundedSurface >(m,"Geom_BSplineSurface",R"#(Describes a BSpline surface. In each parametric direction, a BSpline surface can be: - uniform or non-uniform, - rational or non-rational, - periodic or non-periodic. A BSpline surface is defined by: - its degrees, in the u and v parametric directions, - its periodic characteristic, in the u and v parametric directions, - a table of poles, also called control points (together with the associated weights if the surface is rational), and - a table of knots, together with the associated multiplicities. The degree of a Geom_BSplineSurface is limited to a value (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. Poles and Weights Poles and Weights are manipulated using two associative double arrays: - the poles table, which is a double array of gp_Pnt points, and - the weights table, which is a double array of reals. The bounds of the poles and weights arrays are: - 1 and NbUPoles for the row bounds (provided that the BSpline surface is not periodic in the u parametric direction), where NbUPoles is the number of poles of the surface in the u parametric direction, and - 1 and NbVPoles for the column bounds (provided that the BSpline surface is not periodic in the v parametric direction), where NbVPoles is the number of poles of the surface in the v parametric direction. The poles of the surface are the points used to shape and reshape the surface. They comprise a rectangular network. If the surface is not periodic: - The points (1, 1), (NbUPoles, 1), (1, NbVPoles), and (NbUPoles, NbVPoles) are the four parametric "corners" of the surface. - The first column of poles and the last column of poles define two BSpline curves which delimit the surface in the v parametric direction. These are the v isoparametric curves corresponding to the two bounds of the v parameter. - The first row of poles and the last row of poles define two BSpline curves which delimit the surface in the u parametric direction. These are the u isoparametric curves corresponding to the two bounds of the u parameter. If the surface is periodic, these geometric properties are not verified. It is more difficult to define a geometrical significance for the weights. However they are useful for representing a quadric surface precisely. Moreover, if the weights of all the poles are equal, the surface has a polynomial equation, and hence is a "non-rational surface". The non-rational surface is a special, but frequently used, case, where all poles have identical weights. The weights are defined and used only in the case of a rational surface. The rational characteristic is defined in each parametric direction. A surface can be rational in the u parametric direction, and non-rational in the v parametric direction. Knots and Multiplicities For a Geom_BSplineSurface the table of knots is made up of two increasing sequences of reals, without repetition, one for each parametric direction. The multiplicities define the repetition of the knots. A BSpline surface comprises multiple contiguous patches, which are themselves polynomial or rational surfaces. The knots are the parameters of the isoparametric curves which limit these contiguous patches. The multiplicity of a knot on a BSpline surface (in a given parametric direction) is related to the degree of continuity of the surface at that knot in that parametric direction: Degree of continuity at knot(i) = Degree - Multi(i) where: - Degree is the degree of the BSpline surface in the given parametric direction, and - Multi(i) is the multiplicity of knot number i in the given parametric direction. There are some special cases, where the knots are regularly spaced in one parametric direction (i.e. the difference between two consecutive knots is a constant). - "Uniform": all the multiplicities are equal to 1. - "Quasi-uniform": all the multiplicities are equal to 1, except for the first and last knots in this parametric direction, and these are equal to Degree + 1. - "Piecewise Bezier": all the multiplicities are equal to Degree except for the first and last knots, which are equal to Degree + 1. This surface is a concatenation of Bezier patches in the given parametric direction. If the BSpline surface is not periodic in a given parametric direction, the bounds of the knots and multiplicities tables are 1 and NbKnots, where NbKnots is the number of knots of the BSpline surface in that parametric direction. If the BSpline surface is periodic in a given parametric direction, and there are k periodic knots and p periodic poles in that parametric direction: - the period is such that: period = Knot(k+1) - Knot(1), and - the poles and knots tables in that parametric direction can be considered as infinite tables, such that: Knot(i+k) = Knot(i) + period, and Pole(i+p) = Pole(i) Note: The data structure tables for a periodic BSpline surface are more complex than those of a non-periodic one. References : . A survey of curve and surface methods in CADG Wolfgang BOHM CAGD 1 (1984) . On de Boor-like algorithms and blossoming Wolfgang BOEHM cagd 5 (1988) . Blossoming and knot insertion algorithms for B-spline curves Ronald N. GOLDMAN . Modelisation des surfaces en CAO, Henri GIAUME Peugeot SA . Curves and Surfaces for Computer Aided Geometric Design, a practical guide Gerald FarinDescribes a BSpline surface. In each parametric direction, a BSpline surface can be: - uniform or non-uniform, - rational or non-rational, - periodic or non-periodic. A BSpline surface is defined by: - its degrees, in the u and v parametric directions, - its periodic characteristic, in the u and v parametric directions, - a table of poles, also called control points (together with the associated weights if the surface is rational), and - a table of knots, together with the associated multiplicities. The degree of a Geom_BSplineSurface is limited to a value (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. Poles and Weights Poles and Weights are manipulated using two associative double arrays: - the poles table, which is a double array of gp_Pnt points, and - the weights table, which is a double array of reals. The bounds of the poles and weights arrays are: - 1 and NbUPoles for the row bounds (provided that the BSpline surface is not periodic in the u parametric direction), where NbUPoles is the number of poles of the surface in the u parametric direction, and - 1 and NbVPoles for the column bounds (provided that the BSpline surface is not periodic in the v parametric direction), where NbVPoles is the number of poles of the surface in the v parametric direction. The poles of the surface are the points used to shape and reshape the surface. They comprise a rectangular network. If the surface is not periodic: - The points (1, 1), (NbUPoles, 1), (1, NbVPoles), and (NbUPoles, NbVPoles) are the four parametric "corners" of the surface. - The first column of poles and the last column of poles define two BSpline curves which delimit the surface in the v parametric direction. These are the v isoparametric curves corresponding to the two bounds of the v parameter. - The first row of poles and the last row of poles define two BSpline curves which delimit the surface in the u parametric direction. These are the u isoparametric curves corresponding to the two bounds of the u parameter. If the surface is periodic, these geometric properties are not verified. It is more difficult to define a geometrical significance for the weights. However they are useful for representing a quadric surface precisely. Moreover, if the weights of all the poles are equal, the surface has a polynomial equation, and hence is a "non-rational surface". The non-rational surface is a special, but frequently used, case, where all poles have identical weights. The weights are defined and used only in the case of a rational surface. The rational characteristic is defined in each parametric direction. A surface can be rational in the u parametric direction, and non-rational in the v parametric direction. Knots and Multiplicities For a Geom_BSplineSurface the table of knots is made up of two increasing sequences of reals, without repetition, one for each parametric direction. The multiplicities define the repetition of the knots. A BSpline surface comprises multiple contiguous patches, which are themselves polynomial or rational surfaces. The knots are the parameters of the isoparametric curves which limit these contiguous patches. The multiplicity of a knot on a BSpline surface (in a given parametric direction) is related to the degree of continuity of the surface at that knot in that parametric direction: Degree of continuity at knot(i) = Degree - Multi(i) where: - Degree is the degree of the BSpline surface in the given parametric direction, and - Multi(i) is the multiplicity of knot number i in the given parametric direction. There are some special cases, where the knots are regularly spaced in one parametric direction (i.e. the difference between two consecutive knots is a constant). - "Uniform": all the multiplicities are equal to 1. - "Quasi-uniform": all the multiplicities are equal to 1, except for the first and last knots in this parametric direction, and these are equal to Degree + 1. - "Piecewise Bezier": all the multiplicities are equal to Degree except for the first and last knots, which are equal to Degree + 1. This surface is a concatenation of Bezier patches in the given parametric direction. If the BSpline surface is not periodic in a given parametric direction, the bounds of the knots and multiplicities tables are 1 and NbKnots, where NbKnots is the number of knots of the BSpline surface in that parametric direction. If the BSpline surface is periodic in a given parametric direction, and there are k periodic knots and p periodic poles in that parametric direction: - the period is such that: period = Knot(k+1) - Knot(1), and - the poles and knots tables in that parametric direction can be considered as infinite tables, such that: Knot(i+k) = Knot(i) + period, and Pole(i+p) = Pole(i) Note: The data structure tables for a periodic BSpline surface are more complex than those of a non-periodic one. References : . A survey of curve and surface methods in CADG Wolfgang BOHM CAGD 1 (1984) . On de Boor-like algorithms and blossoming Wolfgang BOEHM cagd 5 (1988) . Blossoming and knot insertion algorithms for B-spline curves Ronald N. GOLDMAN . Modelisation des surfaces en CAO, Henri GIAUME Peugeot SA . Curves and Surfaces for Computer Aided Geometric Design, a practical guide Gerald FarinDescribes a BSpline surface. In each parametric direction, a BSpline surface can be: - uniform or non-uniform, - rational or non-rational, - periodic or non-periodic. A BSpline surface is defined by: - its degrees, in the u and v parametric directions, - its periodic characteristic, in the u and v parametric directions, - a table of poles, also called control points (together with the associated weights if the surface is rational), and - a table of knots, together with the associated multiplicities. The degree of a Geom_BSplineSurface is limited to a value (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. Poles and Weights Poles and Weights are manipulated using two associative double arrays: - the poles table, which is a double array of gp_Pnt points, and - the weights table, which is a double array of reals. The bounds of the poles and weights arrays are: - 1 and NbUPoles for the row bounds (provided that the BSpline surface is not periodic in the u parametric direction), where NbUPoles is the number of poles of the surface in the u parametric direction, and - 1 and NbVPoles for the column bounds (provided that the BSpline surface is not periodic in the v parametric direction), where NbVPoles is the number of poles of the surface in the v parametric direction. The poles of the surface are the points used to shape and reshape the surface. They comprise a rectangular network. If the surface is not periodic: - The points (1, 1), (NbUPoles, 1), (1, NbVPoles), and (NbUPoles, NbVPoles) are the four parametric "corners" of the surface. - The first column of poles and the last column of poles define two BSpline curves which delimit the surface in the v parametric direction. These are the v isoparametric curves corresponding to the two bounds of the v parameter. - The first row of poles and the last row of poles define two BSpline curves which delimit the surface in the u parametric direction. These are the u isoparametric curves corresponding to the two bounds of the u parameter. If the surface is periodic, these geometric properties are not verified. It is more difficult to define a geometrical significance for the weights. However they are useful for representing a quadric surface precisely. Moreover, if the weights of all the poles are equal, the surface has a polynomial equation, and hence is a "non-rational surface". The non-rational surface is a special, but frequently used, case, where all poles have identical weights. The weights are defined and used only in the case of a rational surface. The rational characteristic is defined in each parametric direction. A surface can be rational in the u parametric direction, and non-rational in the v parametric direction. Knots and Multiplicities For a Geom_BSplineSurface the table of knots is made up of two increasing sequences of reals, without repetition, one for each parametric direction. The multiplicities define the repetition of the knots. A BSpline surface comprises multiple contiguous patches, which are themselves polynomial or rational surfaces. The knots are the parameters of the isoparametric curves which limit these contiguous patches. The multiplicity of a knot on a BSpline surface (in a given parametric direction) is related to the degree of continuity of the surface at that knot in that parametric direction: Degree of continuity at knot(i) = Degree - Multi(i) where: - Degree is the degree of the BSpline surface in the given parametric direction, and - Multi(i) is the multiplicity of knot number i in the given parametric direction. There are some special cases, where the knots are regularly spaced in one parametric direction (i.e. the difference between two consecutive knots is a constant). - "Uniform": all the multiplicities are equal to 1. - "Quasi-uniform": all the multiplicities are equal to 1, except for the first and last knots in this parametric direction, and these are equal to Degree + 1. - "Piecewise Bezier": all the multiplicities are equal to Degree except for the first and last knots, which are equal to Degree + 1. This surface is a concatenation of Bezier patches in the given parametric direction. If the BSpline surface is not periodic in a given parametric direction, the bounds of the knots and multiplicities tables are 1 and NbKnots, where NbKnots is the number of knots of the BSpline surface in that parametric direction. If the BSpline surface is periodic in a given parametric direction, and there are k periodic knots and p periodic poles in that parametric direction: - the period is such that: period = Knot(k+1) - Knot(1), and - the poles and knots tables in that parametric direction can be considered as infinite tables, such that: Knot(i+k) = Knot(i) + period, and Pole(i+p) = Pole(i) Note: The data structure tables for a periodic BSpline surface are more complex than those of a non-periodic one. References : . A survey of curve and surface methods in CADG Wolfgang BOHM CAGD 1 (1984) . On de Boor-like algorithms and blossoming Wolfgang BOEHM cagd 5 (1988) . Blossoming and knot insertion algorithms for B-spline curves Ronald N. GOLDMAN . Modelisation des surfaces en CAO, Henri GIAUME Peugeot SA . Curves and Surfaces for Computer Aided Geometric Design, a practical guide Gerald Farin)#");
    py::class_<Geom_BezierCurve ,opencascade::handle<Geom_BezierCurve>  , Geom_BoundedCurve >(m,"Geom_BezierCurve",R"#(Describes a rational or non-rational Bezier curve - a non-rational Bezier curve is defined by a table of poles (also called control points), - a rational Bezier curve is defined by a table of poles with varying weights. These data are manipulated by two parallel arrays: - the poles table, which is an array of gp_Pnt points, and - the weights table, which is an array of reals. The bounds of these arrays are 1 and "the number of "poles" of the curve. The poles of the curve are "control points" used to deform the curve. The first pole is the start point of the curve, and the last pole is the end point of the curve. The segment that joins the first pole to the second pole is the tangent to the curve at its start point, and the segment that joins the last pole to the second-from-last pole is the tangent to the curve at its end point. It is more difficult to give a geometric signification to the weights but they are useful for providing the exact representations of arcs of a circle or ellipse. Moreover, if the weights of all poles are equal, the curve is polynomial; it is therefore a non-rational curve. The non-rational curve is a special and frequently used case. The weights are defined and used only in the case of a rational curve. The degree of a Bezier curve is equal to the number of poles, minus 1. It must be greater than or equal to 1. However, the degree of a Geom_BezierCurve curve is limited to a value (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. The parameter range for a Bezier curve is [ 0, 1 ]. If the first and last control points of the Bezier curve are the same point then the curve is closed. For example, to create a closed Bezier curve with four control points, you have to give the set of control points P1, P2, P3 and P1. The continuity of a Bezier curve is infinite. It is not possible to build a Bezier curve with negative weights. We consider that a weight value is zero if it is less than or equal to gp::Resolution(). We also consider that two weight values W1 and W2 are equal if: |W2 - W1| <= gp::Resolution(). Warning - When considering the continuity of a closed Bezier curve at the junction point, remember that a curve of this type is never periodic. This means that the derivatives for the parameter u = 0 have no reason to be the same as the derivatives for the parameter u = 1 even if the curve is closed. - The length of a Bezier curve can be null.Describes a rational or non-rational Bezier curve - a non-rational Bezier curve is defined by a table of poles (also called control points), - a rational Bezier curve is defined by a table of poles with varying weights. These data are manipulated by two parallel arrays: - the poles table, which is an array of gp_Pnt points, and - the weights table, which is an array of reals. The bounds of these arrays are 1 and "the number of "poles" of the curve. The poles of the curve are "control points" used to deform the curve. The first pole is the start point of the curve, and the last pole is the end point of the curve. The segment that joins the first pole to the second pole is the tangent to the curve at its start point, and the segment that joins the last pole to the second-from-last pole is the tangent to the curve at its end point. It is more difficult to give a geometric signification to the weights but they are useful for providing the exact representations of arcs of a circle or ellipse. Moreover, if the weights of all poles are equal, the curve is polynomial; it is therefore a non-rational curve. The non-rational curve is a special and frequently used case. The weights are defined and used only in the case of a rational curve. The degree of a Bezier curve is equal to the number of poles, minus 1. It must be greater than or equal to 1. However, the degree of a Geom_BezierCurve curve is limited to a value (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. The parameter range for a Bezier curve is [ 0, 1 ]. If the first and last control points of the Bezier curve are the same point then the curve is closed. For example, to create a closed Bezier curve with four control points, you have to give the set of control points P1, P2, P3 and P1. The continuity of a Bezier curve is infinite. It is not possible to build a Bezier curve with negative weights. We consider that a weight value is zero if it is less than or equal to gp::Resolution(). We also consider that two weight values W1 and W2 are equal if: |W2 - W1| <= gp::Resolution(). Warning - When considering the continuity of a closed Bezier curve at the junction point, remember that a curve of this type is never periodic. This means that the derivatives for the parameter u = 0 have no reason to be the same as the derivatives for the parameter u = 1 even if the curve is closed. - The length of a Bezier curve can be null.Describes a rational or non-rational Bezier curve - a non-rational Bezier curve is defined by a table of poles (also called control points), - a rational Bezier curve is defined by a table of poles with varying weights. These data are manipulated by two parallel arrays: - the poles table, which is an array of gp_Pnt points, and - the weights table, which is an array of reals. The bounds of these arrays are 1 and "the number of "poles" of the curve. The poles of the curve are "control points" used to deform the curve. The first pole is the start point of the curve, and the last pole is the end point of the curve. The segment that joins the first pole to the second pole is the tangent to the curve at its start point, and the segment that joins the last pole to the second-from-last pole is the tangent to the curve at its end point. It is more difficult to give a geometric signification to the weights but they are useful for providing the exact representations of arcs of a circle or ellipse. Moreover, if the weights of all poles are equal, the curve is polynomial; it is therefore a non-rational curve. The non-rational curve is a special and frequently used case. The weights are defined and used only in the case of a rational curve. The degree of a Bezier curve is equal to the number of poles, minus 1. It must be greater than or equal to 1. However, the degree of a Geom_BezierCurve curve is limited to a value (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. The parameter range for a Bezier curve is [ 0, 1 ]. If the first and last control points of the Bezier curve are the same point then the curve is closed. For example, to create a closed Bezier curve with four control points, you have to give the set of control points P1, P2, P3 and P1. The continuity of a Bezier curve is infinite. It is not possible to build a Bezier curve with negative weights. We consider that a weight value is zero if it is less than or equal to gp::Resolution(). We also consider that two weight values W1 and W2 are equal if: |W2 - W1| <= gp::Resolution(). Warning - When considering the continuity of a closed Bezier curve at the junction point, remember that a curve of this type is never periodic. This means that the derivatives for the parameter u = 0 have no reason to be the same as the derivatives for the parameter u = 1 even if the curve is closed. - The length of a Bezier curve can be null.)#");
    py::class_<Geom_BezierSurface ,opencascade::handle<Geom_BezierSurface>  , Geom_BoundedSurface >(m,"Geom_BezierSurface",R"#(Describes a rational or non-rational Bezier surface. - A non-rational Bezier surface is defined by a table of poles (also known as control points). - A rational Bezier surface is defined by a table of poles with varying associated weights. This data is manipulated using two associative 2D arrays: - the poles table, which is a 2D array of gp_Pnt, and - the weights table, which is a 2D array of reals. The bounds of these arrays are: - 1 and NbUPoles for the row bounds, where NbUPoles is the number of poles of the surface in the u parametric direction, and - 1 and NbVPoles for the column bounds, where NbVPoles is the number of poles of the surface in the v parametric direction. The poles of the surface, the "control points", are the points used to shape and reshape the surface. They comprise a rectangular network of points: - The points (1, 1), (NbUPoles, 1), (1, NbVPoles) and (NbUPoles, NbVPoles) are the four parametric "corners" of the surface. - The first column of poles and the last column of poles define two Bezier curves which delimit the surface in the v parametric direction. These are the v isoparametric curves corresponding to values 0 and 1 of the v parameter. - The first row of poles and the last row of poles define two Bezier curves which delimit the surface in the u parametric direction. These are the u isoparametric curves corresponding to values 0 and 1 of the u parameter. It is more difficult to define a geometrical significance for the weights. However they are useful for representing a quadric surface precisely. Moreover, if the weights of all the poles are equal, the surface has a polynomial equation, and hence is a "non-rational surface". The non-rational surface is a special, but frequently used, case, where all poles have identical weights. The weights are defined and used only in the case of a rational surface. This rational characteristic is defined in each parametric direction. Hence, a surface can be rational in the u parametric direction, and non-rational in the v parametric direction. Likewise, the degree of a surface is defined in each parametric direction. The degree of a Bezier surface in a given parametric direction is equal to the number of poles of the surface in that parametric direction, minus 1. This must be greater than or equal to 1. However, the degree for a Geom_BezierSurface is limited to a value of (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. The parameter range for a Bezier surface is [ 0, 1 ] in the two parametric directions. A Bezier surface can also be closed, or open, in each parametric direction. If the first row of poles is identical to the last row of poles, the surface is closed in the u parametric direction. If the first column of poles is identical to the last column of poles, the surface is closed in the v parametric direction. The continuity of a Bezier surface is infinite in the u parametric direction and the in v parametric direction. Note: It is not possible to build a Bezier surface with negative weights. Any weight value that is less than, or equal to, gp::Resolution() is considered to be zero. Two weight values, W1 and W2, are considered equal if: |W2-W1| <= gp::Resolution()Describes a rational or non-rational Bezier surface. - A non-rational Bezier surface is defined by a table of poles (also known as control points). - A rational Bezier surface is defined by a table of poles with varying associated weights. This data is manipulated using two associative 2D arrays: - the poles table, which is a 2D array of gp_Pnt, and - the weights table, which is a 2D array of reals. The bounds of these arrays are: - 1 and NbUPoles for the row bounds, where NbUPoles is the number of poles of the surface in the u parametric direction, and - 1 and NbVPoles for the column bounds, where NbVPoles is the number of poles of the surface in the v parametric direction. The poles of the surface, the "control points", are the points used to shape and reshape the surface. They comprise a rectangular network of points: - The points (1, 1), (NbUPoles, 1), (1, NbVPoles) and (NbUPoles, NbVPoles) are the four parametric "corners" of the surface. - The first column of poles and the last column of poles define two Bezier curves which delimit the surface in the v parametric direction. These are the v isoparametric curves corresponding to values 0 and 1 of the v parameter. - The first row of poles and the last row of poles define two Bezier curves which delimit the surface in the u parametric direction. These are the u isoparametric curves corresponding to values 0 and 1 of the u parameter. It is more difficult to define a geometrical significance for the weights. However they are useful for representing a quadric surface precisely. Moreover, if the weights of all the poles are equal, the surface has a polynomial equation, and hence is a "non-rational surface". The non-rational surface is a special, but frequently used, case, where all poles have identical weights. The weights are defined and used only in the case of a rational surface. This rational characteristic is defined in each parametric direction. Hence, a surface can be rational in the u parametric direction, and non-rational in the v parametric direction. Likewise, the degree of a surface is defined in each parametric direction. The degree of a Bezier surface in a given parametric direction is equal to the number of poles of the surface in that parametric direction, minus 1. This must be greater than or equal to 1. However, the degree for a Geom_BezierSurface is limited to a value of (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. The parameter range for a Bezier surface is [ 0, 1 ] in the two parametric directions. A Bezier surface can also be closed, or open, in each parametric direction. If the first row of poles is identical to the last row of poles, the surface is closed in the u parametric direction. If the first column of poles is identical to the last column of poles, the surface is closed in the v parametric direction. The continuity of a Bezier surface is infinite in the u parametric direction and the in v parametric direction. Note: It is not possible to build a Bezier surface with negative weights. Any weight value that is less than, or equal to, gp::Resolution() is considered to be zero. Two weight values, W1 and W2, are considered equal if: |W2-W1| <= gp::Resolution()Describes a rational or non-rational Bezier surface. - A non-rational Bezier surface is defined by a table of poles (also known as control points). - A rational Bezier surface is defined by a table of poles with varying associated weights. This data is manipulated using two associative 2D arrays: - the poles table, which is a 2D array of gp_Pnt, and - the weights table, which is a 2D array of reals. The bounds of these arrays are: - 1 and NbUPoles for the row bounds, where NbUPoles is the number of poles of the surface in the u parametric direction, and - 1 and NbVPoles for the column bounds, where NbVPoles is the number of poles of the surface in the v parametric direction. The poles of the surface, the "control points", are the points used to shape and reshape the surface. They comprise a rectangular network of points: - The points (1, 1), (NbUPoles, 1), (1, NbVPoles) and (NbUPoles, NbVPoles) are the four parametric "corners" of the surface. - The first column of poles and the last column of poles define two Bezier curves which delimit the surface in the v parametric direction. These are the v isoparametric curves corresponding to values 0 and 1 of the v parameter. - The first row of poles and the last row of poles define two Bezier curves which delimit the surface in the u parametric direction. These are the u isoparametric curves corresponding to values 0 and 1 of the u parameter. It is more difficult to define a geometrical significance for the weights. However they are useful for representing a quadric surface precisely. Moreover, if the weights of all the poles are equal, the surface has a polynomial equation, and hence is a "non-rational surface". The non-rational surface is a special, but frequently used, case, where all poles have identical weights. The weights are defined and used only in the case of a rational surface. This rational characteristic is defined in each parametric direction. Hence, a surface can be rational in the u parametric direction, and non-rational in the v parametric direction. Likewise, the degree of a surface is defined in each parametric direction. The degree of a Bezier surface in a given parametric direction is equal to the number of poles of the surface in that parametric direction, minus 1. This must be greater than or equal to 1. However, the degree for a Geom_BezierSurface is limited to a value of (25) which is defined and controlled by the system. This value is returned by the function MaxDegree. The parameter range for a Bezier surface is [ 0, 1 ] in the two parametric directions. A Bezier surface can also be closed, or open, in each parametric direction. If the first row of poles is identical to the last row of poles, the surface is closed in the u parametric direction. If the first column of poles is identical to the last column of poles, the surface is closed in the v parametric direction. The continuity of a Bezier surface is infinite in the u parametric direction and the in v parametric direction. Note: It is not possible to build a Bezier surface with negative weights. Any weight value that is less than, or equal to, gp::Resolution() is considered to be zero. Two weight values, W1 and W2, are considered equal if: |W2-W1| <= gp::Resolution())#");
    py::class_<Geom_Circle ,opencascade::handle<Geom_Circle>  , Geom_Conic >(m,"Geom_Circle",R"#(Describes a circle in 3D space. A circle is defined by its radius and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the circle, and - the origin, "X Direction" and "Y Direction" define the plane of the circle. This coordinate system is the local coordinate system of the circle. The "main Direction" of this coordinate system is the vector normal to the plane of the circle. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the circle. The "main Direction" of the local coordinate system gives an explicit orientation to the circle (definition of the trigonometric sense), determining the direction in which the parameter increases along the circle. The Geom_Circle circle is parameterized by an angle: P(U) = O + R*Cos(U)*XDir + R*Sin(U)*YDir, where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - R is the radius of the circle. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the circle. The parameter is the angle with this "X Direction". A circle is a closed and periodic curve. The period is 2.*Pi and the parameter range is [ 0, 2.*Pi [.Describes a circle in 3D space. A circle is defined by its radius and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the circle, and - the origin, "X Direction" and "Y Direction" define the plane of the circle. This coordinate system is the local coordinate system of the circle. The "main Direction" of this coordinate system is the vector normal to the plane of the circle. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the circle. The "main Direction" of the local coordinate system gives an explicit orientation to the circle (definition of the trigonometric sense), determining the direction in which the parameter increases along the circle. The Geom_Circle circle is parameterized by an angle: P(U) = O + R*Cos(U)*XDir + R*Sin(U)*YDir, where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - R is the radius of the circle. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the circle. The parameter is the angle with this "X Direction". A circle is a closed and periodic curve. The period is 2.*Pi and the parameter range is [ 0, 2.*Pi [.Describes a circle in 3D space. A circle is defined by its radius and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the circle, and - the origin, "X Direction" and "Y Direction" define the plane of the circle. This coordinate system is the local coordinate system of the circle. The "main Direction" of this coordinate system is the vector normal to the plane of the circle. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the circle. The "main Direction" of the local coordinate system gives an explicit orientation to the circle (definition of the trigonometric sense), determining the direction in which the parameter increases along the circle. The Geom_Circle circle is parameterized by an angle: P(U) = O + R*Cos(U)*XDir + R*Sin(U)*YDir, where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - R is the radius of the circle. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the circle. The parameter is the angle with this "X Direction". A circle is a closed and periodic curve. The period is 2.*Pi and the parameter range is [ 0, 2.*Pi [.)#");
    py::class_<Geom_ConicalSurface ,opencascade::handle<Geom_ConicalSurface>  , Geom_ElementarySurface >(m,"Geom_ConicalSurface",R"#(Describes a cone. A cone is defined by the half-angle (can be negative) at its apex, and is positioned in space by a coordinate system (a gp_Ax3 object) and a reference radius as follows: - The "main Axis" of the coordinate system is the axis of revolution of the cone. - The plane defined by the origin, the "X Direction" and the "Y Direction" of the coordinate system is the reference plane of the cone. The intersection of the cone with this reference plane is a circle of radius equal to the reference radius. - The apex of the cone is on the negative side of the "main Axis" of the coordinate system if the half-angle is positive, and on the positive side if the half-angle is negative. This coordinate system is the "local coordinate system" of the cone. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by the "X Direction" and the "Y Direction", defines the u parametric direction. - Its "X Axis" gives the origin for the u parameter. - Its "main Direction" is the v parametric direction of the cone. - Its origin is the origin of the v parameter. The parametric range of the two parameters is: The parametric equation of the cone is: where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of the cone's local coordinate system, - Ang is the half-angle at the apex of the cone, and - R is the reference radius.Describes a cone. A cone is defined by the half-angle (can be negative) at its apex, and is positioned in space by a coordinate system (a gp_Ax3 object) and a reference radius as follows: - The "main Axis" of the coordinate system is the axis of revolution of the cone. - The plane defined by the origin, the "X Direction" and the "Y Direction" of the coordinate system is the reference plane of the cone. The intersection of the cone with this reference plane is a circle of radius equal to the reference radius. - The apex of the cone is on the negative side of the "main Axis" of the coordinate system if the half-angle is positive, and on the positive side if the half-angle is negative. This coordinate system is the "local coordinate system" of the cone. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by the "X Direction" and the "Y Direction", defines the u parametric direction. - Its "X Axis" gives the origin for the u parameter. - Its "main Direction" is the v parametric direction of the cone. - Its origin is the origin of the v parameter. The parametric range of the two parameters is: The parametric equation of the cone is: where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of the cone's local coordinate system, - Ang is the half-angle at the apex of the cone, and - R is the reference radius.Describes a cone. A cone is defined by the half-angle (can be negative) at its apex, and is positioned in space by a coordinate system (a gp_Ax3 object) and a reference radius as follows: - The "main Axis" of the coordinate system is the axis of revolution of the cone. - The plane defined by the origin, the "X Direction" and the "Y Direction" of the coordinate system is the reference plane of the cone. The intersection of the cone with this reference plane is a circle of radius equal to the reference radius. - The apex of the cone is on the negative side of the "main Axis" of the coordinate system if the half-angle is positive, and on the positive side if the half-angle is negative. This coordinate system is the "local coordinate system" of the cone. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by the "X Direction" and the "Y Direction", defines the u parametric direction. - Its "X Axis" gives the origin for the u parameter. - Its "main Direction" is the v parametric direction of the cone. - Its origin is the origin of the v parameter. The parametric range of the two parameters is: The parametric equation of the cone is: where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of the cone's local coordinate system, - Ang is the half-angle at the apex of the cone, and - R is the reference radius.)#");
    py::class_<Geom_CylindricalSurface ,opencascade::handle<Geom_CylindricalSurface>  , Geom_ElementarySurface >(m,"Geom_CylindricalSurface",R"#(This class defines the infinite cylindrical surface.This class defines the infinite cylindrical surface.This class defines the infinite cylindrical surface.)#");
    py::class_<Geom_Ellipse ,opencascade::handle<Geom_Ellipse>  , Geom_Conic >(m,"Geom_Ellipse",R"#(Describes an ellipse in 3D space. An ellipse is defined by its major and minor radii and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the ellipse, - the "X Direction" defines the major axis, and - the "Y Direction" defines the minor axis. The origin, "X Direction" and "Y Direction" of this coordinate system define the plane of the ellipse. The coordinate system is the local coordinate system of the ellipse. The "main Direction" of this coordinate system is the vector normal to the plane of the ellipse. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the ellipse. The "main Direction" of the local coordinate system gives an explicit orientation to the ellipse (definition of the trigonometric sense), determining the direction in which the parameter increases along the ellipse. The Geom_Ellipse ellipse is parameterized by an angle: P(U) = O + MajorRad*Cos(U)*XDir + MinorRad*Sin(U)*YDir where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - MajorRad and MinorRad are the major and minor radii of the ellipse. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the ellipse. An ellipse is a closed and periodic curve. The period is 2.*Pi and the parameter range is [ 0, 2.*Pi [.Describes an ellipse in 3D space. An ellipse is defined by its major and minor radii and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the ellipse, - the "X Direction" defines the major axis, and - the "Y Direction" defines the minor axis. The origin, "X Direction" and "Y Direction" of this coordinate system define the plane of the ellipse. The coordinate system is the local coordinate system of the ellipse. The "main Direction" of this coordinate system is the vector normal to the plane of the ellipse. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the ellipse. The "main Direction" of the local coordinate system gives an explicit orientation to the ellipse (definition of the trigonometric sense), determining the direction in which the parameter increases along the ellipse. The Geom_Ellipse ellipse is parameterized by an angle: P(U) = O + MajorRad*Cos(U)*XDir + MinorRad*Sin(U)*YDir where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - MajorRad and MinorRad are the major and minor radii of the ellipse. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the ellipse. An ellipse is a closed and periodic curve. The period is 2.*Pi and the parameter range is [ 0, 2.*Pi [.Describes an ellipse in 3D space. An ellipse is defined by its major and minor radii and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the ellipse, - the "X Direction" defines the major axis, and - the "Y Direction" defines the minor axis. The origin, "X Direction" and "Y Direction" of this coordinate system define the plane of the ellipse. The coordinate system is the local coordinate system of the ellipse. The "main Direction" of this coordinate system is the vector normal to the plane of the ellipse. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the ellipse. The "main Direction" of the local coordinate system gives an explicit orientation to the ellipse (definition of the trigonometric sense), determining the direction in which the parameter increases along the ellipse. The Geom_Ellipse ellipse is parameterized by an angle: P(U) = O + MajorRad*Cos(U)*XDir + MinorRad*Sin(U)*YDir where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - MajorRad and MinorRad are the major and minor radii of the ellipse. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the ellipse. An ellipse is a closed and periodic curve. The period is 2.*Pi and the parameter range is [ 0, 2.*Pi [.)#");
    py::class_<Geom_Hyperbola ,opencascade::handle<Geom_Hyperbola>  , Geom_Conic >(m,"Geom_Hyperbola",R"#(Describes a branch of a hyperbola in 3D space. A hyperbola is defined by its major and minor radii and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the hyperbola, - the "X Direction" defines the major axis, and - the "Y Direction" defines the minor axis. The origin, "X Direction" and "Y Direction" of this coordinate system define the plane of the hyperbola. The coordinate system is the local coordinate system of the hyperbola. The branch of the hyperbola described is the one located on the positive side of the major axis. The "main Direction" of the local coordinate system is a vector normal to the plane of the hyperbola. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the hyperbola. The "main Direction" of the local coordinate system gives an explicit orientation to the hyperbola, determining the direction in which the parameter increases along the hyperbola. The Geom_Hyperbola hyperbola is parameterized as follows: P(U) = O + MajRad*Cosh(U)*XDir + MinRad*Sinh(U)*YDir, where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - MajRad and MinRad are the major and minor radii of the hyperbola. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the hyperbola. The parameter range is ] -infinite, +infinite [. The following diagram illustrates the respective positions, in the plane of the hyperbola, of the three branches of hyperbolas constructed using the functions OtherBranch, ConjugateBranch1 and ConjugateBranch2: Defines the main branch of an hyperbola. ^YAxis | FirstConjugateBranch | Other | Main --------------------- C ------------------------------>XAxis Branch | Branch | SecondConjugateBranch | Warning The value of the major radius (on the major axis) can be less than the value of the minor radius (on the minor axis).Describes a branch of a hyperbola in 3D space. A hyperbola is defined by its major and minor radii and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the hyperbola, - the "X Direction" defines the major axis, and - the "Y Direction" defines the minor axis. The origin, "X Direction" and "Y Direction" of this coordinate system define the plane of the hyperbola. The coordinate system is the local coordinate system of the hyperbola. The branch of the hyperbola described is the one located on the positive side of the major axis. The "main Direction" of the local coordinate system is a vector normal to the plane of the hyperbola. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the hyperbola. The "main Direction" of the local coordinate system gives an explicit orientation to the hyperbola, determining the direction in which the parameter increases along the hyperbola. The Geom_Hyperbola hyperbola is parameterized as follows: P(U) = O + MajRad*Cosh(U)*XDir + MinRad*Sinh(U)*YDir, where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - MajRad and MinRad are the major and minor radii of the hyperbola. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the hyperbola. The parameter range is ] -infinite, +infinite [. The following diagram illustrates the respective positions, in the plane of the hyperbola, of the three branches of hyperbolas constructed using the functions OtherBranch, ConjugateBranch1 and ConjugateBranch2: Defines the main branch of an hyperbola. ^YAxis | FirstConjugateBranch | Other | Main --------------------- C ------------------------------>XAxis Branch | Branch | SecondConjugateBranch | Warning The value of the major radius (on the major axis) can be less than the value of the minor radius (on the minor axis).Describes a branch of a hyperbola in 3D space. A hyperbola is defined by its major and minor radii and, as with any conic curve, is positioned in space with a right-handed coordinate system (gp_Ax2 object) where: - the origin is the center of the hyperbola, - the "X Direction" defines the major axis, and - the "Y Direction" defines the minor axis. The origin, "X Direction" and "Y Direction" of this coordinate system define the plane of the hyperbola. The coordinate system is the local coordinate system of the hyperbola. The branch of the hyperbola described is the one located on the positive side of the major axis. The "main Direction" of the local coordinate system is a vector normal to the plane of the hyperbola. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the hyperbola. The "main Direction" of the local coordinate system gives an explicit orientation to the hyperbola, determining the direction in which the parameter increases along the hyperbola. The Geom_Hyperbola hyperbola is parameterized as follows: P(U) = O + MajRad*Cosh(U)*XDir + MinRad*Sinh(U)*YDir, where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - MajRad and MinRad are the major and minor radii of the hyperbola. The "X Axis" of the local coordinate system therefore defines the origin of the parameter of the hyperbola. The parameter range is ] -infinite, +infinite [. The following diagram illustrates the respective positions, in the plane of the hyperbola, of the three branches of hyperbolas constructed using the functions OtherBranch, ConjugateBranch1 and ConjugateBranch2: Defines the main branch of an hyperbola. ^YAxis | FirstConjugateBranch | Other | Main --------------------- C ------------------------------>XAxis Branch | Branch | SecondConjugateBranch | Warning The value of the major radius (on the major axis) can be less than the value of the minor radius (on the minor axis).)#");
    py::class_<Geom_Parabola ,opencascade::handle<Geom_Parabola>  , Geom_Conic >(m,"Geom_Parabola",R"#(Describes a parabola in 3D space. A parabola is defined by its focal length (i.e. the distance between its focus and its apex) and is positioned in space with a coordinate system (gp_Ax2 object) where: - the origin is the apex of the parabola, - the "X Axis" defines the axis of symmetry; the parabola is on the positive side of this axis, - the origin, "X Direction" and "Y Direction" define the plane of the parabola. This coordinate system is the local coordinate system of the parabola. The "main Direction" of this coordinate system is a vector normal to the plane of the parabola. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the parabola. The "main Direction" of the local coordinate system gives an explicit orientation to the parabola, determining the direction in which the parameter increases along the parabola. The Geom_Parabola parabola is parameterized as follows: P(U) = O + U*U/(4.*F)*XDir + U*YDir where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - F is the focal length of the parabola. The parameter of the parabola is therefore its Y coordinate in the local coordinate system, with the "X Axis" of the local coordinate system defining the origin of the parameter. The parameter range is ] -infinite, +infinite [.Describes a parabola in 3D space. A parabola is defined by its focal length (i.e. the distance between its focus and its apex) and is positioned in space with a coordinate system (gp_Ax2 object) where: - the origin is the apex of the parabola, - the "X Axis" defines the axis of symmetry; the parabola is on the positive side of this axis, - the origin, "X Direction" and "Y Direction" define the plane of the parabola. This coordinate system is the local coordinate system of the parabola. The "main Direction" of this coordinate system is a vector normal to the plane of the parabola. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the parabola. The "main Direction" of the local coordinate system gives an explicit orientation to the parabola, determining the direction in which the parameter increases along the parabola. The Geom_Parabola parabola is parameterized as follows: P(U) = O + U*U/(4.*F)*XDir + U*YDir where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - F is the focal length of the parabola. The parameter of the parabola is therefore its Y coordinate in the local coordinate system, with the "X Axis" of the local coordinate system defining the origin of the parameter. The parameter range is ] -infinite, +infinite [.Describes a parabola in 3D space. A parabola is defined by its focal length (i.e. the distance between its focus and its apex) and is positioned in space with a coordinate system (gp_Ax2 object) where: - the origin is the apex of the parabola, - the "X Axis" defines the axis of symmetry; the parabola is on the positive side of this axis, - the origin, "X Direction" and "Y Direction" define the plane of the parabola. This coordinate system is the local coordinate system of the parabola. The "main Direction" of this coordinate system is a vector normal to the plane of the parabola. The axis, of which the origin and unit vector are respectively the origin and "main Direction" of the local coordinate system, is termed the "Axis" or "main Axis" of the parabola. The "main Direction" of the local coordinate system gives an explicit orientation to the parabola, determining the direction in which the parameter increases along the parabola. The Geom_Parabola parabola is parameterized as follows: P(U) = O + U*U/(4.*F)*XDir + U*YDir where: - P is the point of parameter U, - O, XDir and YDir are respectively the origin, "X Direction" and "Y Direction" of its local coordinate system, - F is the focal length of the parabola. The parameter of the parabola is therefore its Y coordinate in the local coordinate system, with the "X Axis" of the local coordinate system defining the origin of the parameter. The parameter range is ] -infinite, +infinite [.)#");
    py::class_<Geom_Plane ,opencascade::handle<Geom_Plane>  , Geom_ElementarySurface >(m,"Geom_Plane",R"#(Describes a plane in 3D space. A plane is positioned in space by a coordinate system (a gp_Ax3 object) such that the plane is defined by the origin, "X Direction" and "Y Direction" of this coordinate system. This coordinate system is the "local coordinate system" of the plane. The following apply: - Its "X Direction" and "Y Direction" are respectively the u and v parametric directions of the plane. - Its origin is the origin of the u and v parameters (also called the "origin" of the plane). - Its "main Direction" is a vector normal to the plane. This normal vector gives the orientation of the plane only if the local coordinate system is "direct". (The orientation of the plane is always defined by the "X Direction" and the "Y Direction" of its local coordinate system.) The parametric equation of the plane is: where O, XDir and YDir are respectively the origin, the "X Direction" and the "Y Direction" of the local coordinate system of the plane. The parametric range of the two parameters u and v is ] -infinity, +infinity [.Describes a plane in 3D space. A plane is positioned in space by a coordinate system (a gp_Ax3 object) such that the plane is defined by the origin, "X Direction" and "Y Direction" of this coordinate system. This coordinate system is the "local coordinate system" of the plane. The following apply: - Its "X Direction" and "Y Direction" are respectively the u and v parametric directions of the plane. - Its origin is the origin of the u and v parameters (also called the "origin" of the plane). - Its "main Direction" is a vector normal to the plane. This normal vector gives the orientation of the plane only if the local coordinate system is "direct". (The orientation of the plane is always defined by the "X Direction" and the "Y Direction" of its local coordinate system.) The parametric equation of the plane is: where O, XDir and YDir are respectively the origin, the "X Direction" and the "Y Direction" of the local coordinate system of the plane. The parametric range of the two parameters u and v is ] -infinity, +infinity [.Describes a plane in 3D space. A plane is positioned in space by a coordinate system (a gp_Ax3 object) such that the plane is defined by the origin, "X Direction" and "Y Direction" of this coordinate system. This coordinate system is the "local coordinate system" of the plane. The following apply: - Its "X Direction" and "Y Direction" are respectively the u and v parametric directions of the plane. - Its origin is the origin of the u and v parameters (also called the "origin" of the plane). - Its "main Direction" is a vector normal to the plane. This normal vector gives the orientation of the plane only if the local coordinate system is "direct". (The orientation of the plane is always defined by the "X Direction" and the "Y Direction" of its local coordinate system.) The parametric equation of the plane is: where O, XDir and YDir are respectively the origin, the "X Direction" and the "Y Direction" of the local coordinate system of the plane. The parametric range of the two parameters u and v is ] -infinity, +infinity [.)#");
    py::class_<Geom_RectangularTrimmedSurface ,opencascade::handle<Geom_RectangularTrimmedSurface>  , Geom_BoundedSurface >(m,"Geom_RectangularTrimmedSurface",R"#(Describes a portion of a surface (a patch) limited by two values of the u parameter in the u parametric direction, and two values of the v parameter in the v parametric direction. The domain of the trimmed surface must be within the domain of the surface being trimmed. The trimmed surface is defined by: - the basis surface, and - the values (umin, umax) and (vmin, vmax) which limit it in the u and v parametric directions. The trimmed surface is built from a copy of the basis surface. Therefore, when the basis surface is modified the trimmed surface is not changed. Consequently, the trimmed surface does not necessarily have the same orientation as the basis surface. Warning: The case of surface being trimmed is periodic and parametrics values are outside the domain is possible. But, domain of the trimmed surface can be translated by (n X) the period.Describes a portion of a surface (a patch) limited by two values of the u parameter in the u parametric direction, and two values of the v parameter in the v parametric direction. The domain of the trimmed surface must be within the domain of the surface being trimmed. The trimmed surface is defined by: - the basis surface, and - the values (umin, umax) and (vmin, vmax) which limit it in the u and v parametric directions. The trimmed surface is built from a copy of the basis surface. Therefore, when the basis surface is modified the trimmed surface is not changed. Consequently, the trimmed surface does not necessarily have the same orientation as the basis surface. Warning: The case of surface being trimmed is periodic and parametrics values are outside the domain is possible. But, domain of the trimmed surface can be translated by (n X) the period.Describes a portion of a surface (a patch) limited by two values of the u parameter in the u parametric direction, and two values of the v parameter in the v parametric direction. The domain of the trimmed surface must be within the domain of the surface being trimmed. The trimmed surface is defined by: - the basis surface, and - the values (umin, umax) and (vmin, vmax) which limit it in the u and v parametric directions. The trimmed surface is built from a copy of the basis surface. Therefore, when the basis surface is modified the trimmed surface is not changed. Consequently, the trimmed surface does not necessarily have the same orientation as the basis surface. Warning: The case of surface being trimmed is periodic and parametrics values are outside the domain is possible. But, domain of the trimmed surface can be translated by (n X) the period.)#");
    py::class_<Geom_SphericalSurface ,opencascade::handle<Geom_SphericalSurface>  , Geom_ElementarySurface >(m,"Geom_SphericalSurface",R"#(Describes a sphere. A sphere is defined by its radius, and is positioned in space by a coordinate system (a gp_Ax3 object), the origin of which is the center of the sphere. This coordinate system is the "local coordinate system" of the sphere. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by the "X Direction" and the "Y Direction", defines the u parametric direction. - Its "X Axis" gives the origin for the u parameter. - The "reference meridian" of the sphere is a half-circle, of radius equal to the radius of the sphere. It is located in the plane defined by the origin, "X Direction" and "main Direction", centered on the origin, and positioned on the positive side of the "X Axis". - Rotation around the "Y Axis" gives the v parameter on the reference meridian. - The "X Axis" gives the origin of the v parameter on the reference meridian. - The v parametric direction is oriented by the "main Direction", i.e. when v increases, the Z coordinate increases. (This implies that the "Y Direction" orients the reference meridian only when the local coordinate system is indirect.) - The u isoparametric curve is a half-circle obtained by rotating the reference meridian of the sphere through an angle u around the "main Axis", in the trigonometric sense defined by the "X Direction" and the "Y Direction". The parametric equation of the sphere is: P(u,v) = O + R*cos(v)*(cos(u)*XDir + sin(u)*YDir)+R*sin(v)*ZDir where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of its local coordinate system, and - R is the radius of the sphere. The parametric range of the two parameters is: - [ 0, 2.*Pi ] for u, and - [ - Pi/2., + Pi/2. ] for v.Describes a sphere. A sphere is defined by its radius, and is positioned in space by a coordinate system (a gp_Ax3 object), the origin of which is the center of the sphere. This coordinate system is the "local coordinate system" of the sphere. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by the "X Direction" and the "Y Direction", defines the u parametric direction. - Its "X Axis" gives the origin for the u parameter. - The "reference meridian" of the sphere is a half-circle, of radius equal to the radius of the sphere. It is located in the plane defined by the origin, "X Direction" and "main Direction", centered on the origin, and positioned on the positive side of the "X Axis". - Rotation around the "Y Axis" gives the v parameter on the reference meridian. - The "X Axis" gives the origin of the v parameter on the reference meridian. - The v parametric direction is oriented by the "main Direction", i.e. when v increases, the Z coordinate increases. (This implies that the "Y Direction" orients the reference meridian only when the local coordinate system is indirect.) - The u isoparametric curve is a half-circle obtained by rotating the reference meridian of the sphere through an angle u around the "main Axis", in the trigonometric sense defined by the "X Direction" and the "Y Direction". The parametric equation of the sphere is: P(u,v) = O + R*cos(v)*(cos(u)*XDir + sin(u)*YDir)+R*sin(v)*ZDir where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of its local coordinate system, and - R is the radius of the sphere. The parametric range of the two parameters is: - [ 0, 2.*Pi ] for u, and - [ - Pi/2., + Pi/2. ] for v.Describes a sphere. A sphere is defined by its radius, and is positioned in space by a coordinate system (a gp_Ax3 object), the origin of which is the center of the sphere. This coordinate system is the "local coordinate system" of the sphere. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by the "X Direction" and the "Y Direction", defines the u parametric direction. - Its "X Axis" gives the origin for the u parameter. - The "reference meridian" of the sphere is a half-circle, of radius equal to the radius of the sphere. It is located in the plane defined by the origin, "X Direction" and "main Direction", centered on the origin, and positioned on the positive side of the "X Axis". - Rotation around the "Y Axis" gives the v parameter on the reference meridian. - The "X Axis" gives the origin of the v parameter on the reference meridian. - The v parametric direction is oriented by the "main Direction", i.e. when v increases, the Z coordinate increases. (This implies that the "Y Direction" orients the reference meridian only when the local coordinate system is indirect.) - The u isoparametric curve is a half-circle obtained by rotating the reference meridian of the sphere through an angle u around the "main Axis", in the trigonometric sense defined by the "X Direction" and the "Y Direction". The parametric equation of the sphere is: P(u,v) = O + R*cos(v)*(cos(u)*XDir + sin(u)*YDir)+R*sin(v)*ZDir where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of its local coordinate system, and - R is the radius of the sphere. The parametric range of the two parameters is: - [ 0, 2.*Pi ] for u, and - [ - Pi/2., + Pi/2. ] for v.)#");
    py::class_<Geom_SurfaceOfLinearExtrusion ,opencascade::handle<Geom_SurfaceOfLinearExtrusion>  , Geom_SweptSurface >(m,"Geom_SurfaceOfLinearExtrusion",R"#(Describes a surface of linear extrusion ("extruded surface"), e.g. a generalized cylinder. Such a surface is obtained by sweeping a curve (called the "extruded curve" or "basis") in a given direction (referred to as the "direction of extrusion" and defined by a unit vector). The u parameter is along the extruded curve. The v parameter is along the direction of extrusion. The parameter range for the u parameter is defined by the reference curve. The parameter range for the v parameter is ] - infinity, + infinity [. The position of the curve gives the origin of the v parameter. The surface is "CN" in the v parametric direction. The form of a surface of linear extrusion is generally a ruled surface (GeomAbs_RuledForm). It can be: - a cylindrical surface, if the extruded curve is a circle, or a trimmed circle, with an axis parallel to the direction of extrusion (GeomAbs_CylindricalForm), or - a planar surface, if the extruded curve is a line (GeomAbs_PlanarForm). Note: The surface of extrusion is built from a copy of the original basis curve, so the original curve is not modified when the surface is modified. Warning Degenerate surfaces are not detected. A degenerate surface is obtained, for example, when the extruded curve is a line and the direction of extrusion is parallel to that line.Describes a surface of linear extrusion ("extruded surface"), e.g. a generalized cylinder. Such a surface is obtained by sweeping a curve (called the "extruded curve" or "basis") in a given direction (referred to as the "direction of extrusion" and defined by a unit vector). The u parameter is along the extruded curve. The v parameter is along the direction of extrusion. The parameter range for the u parameter is defined by the reference curve. The parameter range for the v parameter is ] - infinity, + infinity [. The position of the curve gives the origin of the v parameter. The surface is "CN" in the v parametric direction. The form of a surface of linear extrusion is generally a ruled surface (GeomAbs_RuledForm). It can be: - a cylindrical surface, if the extruded curve is a circle, or a trimmed circle, with an axis parallel to the direction of extrusion (GeomAbs_CylindricalForm), or - a planar surface, if the extruded curve is a line (GeomAbs_PlanarForm). Note: The surface of extrusion is built from a copy of the original basis curve, so the original curve is not modified when the surface is modified. Warning Degenerate surfaces are not detected. A degenerate surface is obtained, for example, when the extruded curve is a line and the direction of extrusion is parallel to that line.Describes a surface of linear extrusion ("extruded surface"), e.g. a generalized cylinder. Such a surface is obtained by sweeping a curve (called the "extruded curve" or "basis") in a given direction (referred to as the "direction of extrusion" and defined by a unit vector). The u parameter is along the extruded curve. The v parameter is along the direction of extrusion. The parameter range for the u parameter is defined by the reference curve. The parameter range for the v parameter is ] - infinity, + infinity [. The position of the curve gives the origin of the v parameter. The surface is "CN" in the v parametric direction. The form of a surface of linear extrusion is generally a ruled surface (GeomAbs_RuledForm). It can be: - a cylindrical surface, if the extruded curve is a circle, or a trimmed circle, with an axis parallel to the direction of extrusion (GeomAbs_CylindricalForm), or - a planar surface, if the extruded curve is a line (GeomAbs_PlanarForm). Note: The surface of extrusion is built from a copy of the original basis curve, so the original curve is not modified when the surface is modified. Warning Degenerate surfaces are not detected. A degenerate surface is obtained, for example, when the extruded curve is a line and the direction of extrusion is parallel to that line.)#");
    py::class_<Geom_SurfaceOfRevolution ,opencascade::handle<Geom_SurfaceOfRevolution>  , Geom_SweptSurface >(m,"Geom_SurfaceOfRevolution",R"#(Describes a surface of revolution (revolved surface). Such a surface is obtained by rotating a curve (called the "meridian") through a complete revolution about an axis (referred to as the "axis of revolution"). The curve and the axis must be in the same plane (the "reference plane" of the surface). Rotation around the axis of revolution in the trigonometric sense defines the u parametric direction. So the u parameter is an angle, and its origin is given by the position of the meridian on the surface. The parametric range for the u parameter is: [ 0, 2.*Pi ] The v parameter is that of the meridian. Note: A surface of revolution is built from a copy of the original meridian. As a result the original meridian is not modified when the surface is modified. The form of a surface of revolution is typically a general revolution surface (GeomAbs_RevolutionForm). It can be: - a conical surface, if the meridian is a line or a trimmed line (GeomAbs_ConicalForm), - a cylindrical surface, if the meridian is a line or a trimmed line parallel to the axis of revolution (GeomAbs_CylindricalForm), - a planar surface if the meridian is a line or a trimmed line perpendicular to the axis of revolution of the surface (GeomAbs_PlanarForm), - a toroidal surface, if the meridian is a circle or a trimmed circle (GeomAbs_ToroidalForm), or - a spherical surface, if the meridian is a circle, the center of which is located on the axis of the revolved surface (GeomAbs_SphericalForm). Warning Be careful not to construct a surface of revolution where the curve and the axis or revolution are not defined in the same plane. If you do not have a correct configuration, you can correct your initial curve, using a cylindrical projection in the reference plane.Describes a surface of revolution (revolved surface). Such a surface is obtained by rotating a curve (called the "meridian") through a complete revolution about an axis (referred to as the "axis of revolution"). The curve and the axis must be in the same plane (the "reference plane" of the surface). Rotation around the axis of revolution in the trigonometric sense defines the u parametric direction. So the u parameter is an angle, and its origin is given by the position of the meridian on the surface. The parametric range for the u parameter is: [ 0, 2.*Pi ] The v parameter is that of the meridian. Note: A surface of revolution is built from a copy of the original meridian. As a result the original meridian is not modified when the surface is modified. The form of a surface of revolution is typically a general revolution surface (GeomAbs_RevolutionForm). It can be: - a conical surface, if the meridian is a line or a trimmed line (GeomAbs_ConicalForm), - a cylindrical surface, if the meridian is a line or a trimmed line parallel to the axis of revolution (GeomAbs_CylindricalForm), - a planar surface if the meridian is a line or a trimmed line perpendicular to the axis of revolution of the surface (GeomAbs_PlanarForm), - a toroidal surface, if the meridian is a circle or a trimmed circle (GeomAbs_ToroidalForm), or - a spherical surface, if the meridian is a circle, the center of which is located on the axis of the revolved surface (GeomAbs_SphericalForm). Warning Be careful not to construct a surface of revolution where the curve and the axis or revolution are not defined in the same plane. If you do not have a correct configuration, you can correct your initial curve, using a cylindrical projection in the reference plane.Describes a surface of revolution (revolved surface). Such a surface is obtained by rotating a curve (called the "meridian") through a complete revolution about an axis (referred to as the "axis of revolution"). The curve and the axis must be in the same plane (the "reference plane" of the surface). Rotation around the axis of revolution in the trigonometric sense defines the u parametric direction. So the u parameter is an angle, and its origin is given by the position of the meridian on the surface. The parametric range for the u parameter is: [ 0, 2.*Pi ] The v parameter is that of the meridian. Note: A surface of revolution is built from a copy of the original meridian. As a result the original meridian is not modified when the surface is modified. The form of a surface of revolution is typically a general revolution surface (GeomAbs_RevolutionForm). It can be: - a conical surface, if the meridian is a line or a trimmed line (GeomAbs_ConicalForm), - a cylindrical surface, if the meridian is a line or a trimmed line parallel to the axis of revolution (GeomAbs_CylindricalForm), - a planar surface if the meridian is a line or a trimmed line perpendicular to the axis of revolution of the surface (GeomAbs_PlanarForm), - a toroidal surface, if the meridian is a circle or a trimmed circle (GeomAbs_ToroidalForm), or - a spherical surface, if the meridian is a circle, the center of which is located on the axis of the revolved surface (GeomAbs_SphericalForm). Warning Be careful not to construct a surface of revolution where the curve and the axis or revolution are not defined in the same plane. If you do not have a correct configuration, you can correct your initial curve, using a cylindrical projection in the reference plane.)#");
    py::class_<Geom_ToroidalSurface ,opencascade::handle<Geom_ToroidalSurface>  , Geom_ElementarySurface >(m,"Geom_ToroidalSurface",R"#(Describes a torus. A torus is defined by its major and minor radii, and positioned in space with a coordinate system (a gp_Ax3 object) as follows: - The origin is the center of the torus. - The surface is obtained by rotating a circle around the "main Direction". This circle has a radius equal to the minor radius, and is located in the plane defined by the origin, "X Direction" and "main Direction". It is centered on the "X Axis", on its positive side, and positioned at a distance from the origin equal to the major radius. This circle is the "reference circle" of the torus. - The plane defined by the origin, the "X Direction" and the "Y Direction" is called the "reference plane" of the torus. This coordinate system is the "local coordinate system" of the torus. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by "X Direction" and "Y Direction", defines the u parametric direction. - The "X Axis" gives the origin for the u parameter. - Rotation around an axis parallel to the "Y Axis" and passing through the center of the "reference circle" gives the v parameter on the "reference circle". - The "X Axis" gives the origin of the v parameter on the "reference circle". - The v parametric direction is oriented by the inverse of the "main Direction", i.e. near 0, as v increases, the Z coordinate decreases. (This implies that the "Y Direction" orients the reference circle only when the local coordinate system is direct.) - The u isoparametric curve is a circle obtained by rotating the "reference circle" of the torus through an angle u about the "main Axis". The parametric equation of the torus is : P(u, v) = O + (R + r*cos(v)) * (cos(u)*XDir + sin(u)*YDir ) + r*sin(v)*ZDir, where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of the local coordinate system, - r and R are, respectively, the minor and major radius. The parametric range of the two parameters is: - [ 0, 2.*Pi ] for u - [ 0, 2.*Pi ] for vDescribes a torus. A torus is defined by its major and minor radii, and positioned in space with a coordinate system (a gp_Ax3 object) as follows: - The origin is the center of the torus. - The surface is obtained by rotating a circle around the "main Direction". This circle has a radius equal to the minor radius, and is located in the plane defined by the origin, "X Direction" and "main Direction". It is centered on the "X Axis", on its positive side, and positioned at a distance from the origin equal to the major radius. This circle is the "reference circle" of the torus. - The plane defined by the origin, the "X Direction" and the "Y Direction" is called the "reference plane" of the torus. This coordinate system is the "local coordinate system" of the torus. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by "X Direction" and "Y Direction", defines the u parametric direction. - The "X Axis" gives the origin for the u parameter. - Rotation around an axis parallel to the "Y Axis" and passing through the center of the "reference circle" gives the v parameter on the "reference circle". - The "X Axis" gives the origin of the v parameter on the "reference circle". - The v parametric direction is oriented by the inverse of the "main Direction", i.e. near 0, as v increases, the Z coordinate decreases. (This implies that the "Y Direction" orients the reference circle only when the local coordinate system is direct.) - The u isoparametric curve is a circle obtained by rotating the "reference circle" of the torus through an angle u about the "main Axis". The parametric equation of the torus is : P(u, v) = O + (R + r*cos(v)) * (cos(u)*XDir + sin(u)*YDir ) + r*sin(v)*ZDir, where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of the local coordinate system, - r and R are, respectively, the minor and major radius. The parametric range of the two parameters is: - [ 0, 2.*Pi ] for u - [ 0, 2.*Pi ] for vDescribes a torus. A torus is defined by its major and minor radii, and positioned in space with a coordinate system (a gp_Ax3 object) as follows: - The origin is the center of the torus. - The surface is obtained by rotating a circle around the "main Direction". This circle has a radius equal to the minor radius, and is located in the plane defined by the origin, "X Direction" and "main Direction". It is centered on the "X Axis", on its positive side, and positioned at a distance from the origin equal to the major radius. This circle is the "reference circle" of the torus. - The plane defined by the origin, the "X Direction" and the "Y Direction" is called the "reference plane" of the torus. This coordinate system is the "local coordinate system" of the torus. The following apply: - Rotation around its "main Axis", in the trigonometric sense given by "X Direction" and "Y Direction", defines the u parametric direction. - The "X Axis" gives the origin for the u parameter. - Rotation around an axis parallel to the "Y Axis" and passing through the center of the "reference circle" gives the v parameter on the "reference circle". - The "X Axis" gives the origin of the v parameter on the "reference circle". - The v parametric direction is oriented by the inverse of the "main Direction", i.e. near 0, as v increases, the Z coordinate decreases. (This implies that the "Y Direction" orients the reference circle only when the local coordinate system is direct.) - The u isoparametric curve is a circle obtained by rotating the "reference circle" of the torus through an angle u about the "main Axis". The parametric equation of the torus is : P(u, v) = O + (R + r*cos(v)) * (cos(u)*XDir + sin(u)*YDir ) + r*sin(v)*ZDir, where: - O, XDir, YDir and ZDir are respectively the origin, the "X Direction", the "Y Direction" and the "Z Direction" of the local coordinate system, - r and R are, respectively, the minor and major radius. The parametric range of the two parameters is: - [ 0, 2.*Pi ] for u - [ 0, 2.*Pi ] for v)#");
    py::class_<Geom_TrimmedCurve ,opencascade::handle<Geom_TrimmedCurve>  , Geom_BoundedCurve >(m,"Geom_TrimmedCurve",R"#(Describes a portion of a curve (termed the "basis curve") limited by two parameter values inside the parametric domain of the basis curve. The trimmed curve is defined by: - the basis curve, and - the two parameter values which limit it. The trimmed curve can either have the same orientation as the basis curve or the opposite orientation.Describes a portion of a curve (termed the "basis curve") limited by two parameter values inside the parametric domain of the basis curve. The trimmed curve is defined by: - the basis curve, and - the two parameter values which limit it. The trimmed curve can either have the same orientation as the basis curve or the opposite orientation.Describes a portion of a curve (termed the "basis curve") limited by two parameter values inside the parametric domain of the basis curve. The trimmed curve is defined by: - the basis curve, and - the two parameter values which limit it. The trimmed curve can either have the same orientation as the basis curve or the opposite orientation.)#");

};

// user-defined post-inclusion per module

// user-defined post
