# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
QEMU_SYSTEM_RISCV64 ?= $(if $(value SNAP_INSTANCE_NAME),$$(test -z "$${SNAP_INSTANCE_NAME-}" && echo $(SNAP_INSTANCE_NAME).)qemu-system-riscv64,$(or $(shell command -v qemu-system-riscv64),$(warning program qemu-system-riscv64 is required)qemu-system-riscv64))
QEMU_SYSTEM_RISCV64_MACHINE = virt,acpi=off
QEMU_CPU_RISCV64 = max
QEMU_SMP_RISCV64 = 1
QEMU_DEFAULT_NET_OPTION_RISCV64 ?= \
	-netdev user,id=netdev0$(QEMU_DEFAULT_NETDEV_SYS_EXTRA)$${QEMU_NETDEV_USER_EXTRA:-} \
	-device virtio-net-pci,netdev=netdev0,id=net0
QEMU_SYSTEM_RISCV64_EFI_CMDLINE = \
	$(QEMU_ENV_QUIRKS) \
	exec $(QEMU_SYSTEM_RISCV64) \
	-cpu $(QEMU_CPU_RISCV64) \
	-machine $(QEMU_SYSTEM_RISCV64_MACHINE)$${QEMU_ACCEL_MACHINE_PROP=,accel=`$(QEMU_SYSTEM_RISCV64) -accel help | tail -n +2 | sort | paste -sd :`} \
	$${QEMU_MEM_OPTION=$(QEMU_DEFAULT_MEM_OPTION)} \
	$${QEMU_SMP_OPTION=-smp $(QEMU_SMP_RISCV64)} \
	$${QEMU_DISPLAY_OPTION=$(QEMU_DEFAULT_DISPLAY_OPTION)} \
	$${QEMU_BOOT_FIRMWARE_OPTION=-drive if=pflash,format=raw,unit=0,file=$(2),readonly=on \
		-drive if=pflash,format=raw,unit=1,file=$(3)} \
	$${QEMU_STORAGE_OPTION=-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
		-device virtio-blk,drive=drive0,bootindex=0} \
	$${QEMU_RNG_OPTION=$(QEMU_DEFAULT_RNG_OPTION)} \
	$${QEMU_NET_OPTION=$(QEMU_DEFAULT_NET_OPTION_RISCV64)}
QEMU_EDK2_CODE_RISCV64 ?= \
	/usr/share/qemu-efi-riscv64/RISCV_VIRT_CODE.fd \
	/usr/share/edk2/riscv/RISCV_VIRT_CODE.fd \
	/usr/share/qemu/ovmf-riscv64-code.bin
QEMU_EDK2_VARS_RISCV64 ?= \
	/usr/share/qemu-efi-riscv64/RISCV_VIRT_VARS.fd \
	/usr/share/edk2/riscv/RISCV_VIRT_VARS.fd \
	/usr/share/qemu/ovmf-riscv64-vars.bin

ifneq (,$(value SNAP))
QEMU_EDK2_CODE_RISCV64 += $(SNAP)/components/qemu-riscv64/share/qemu/edk2-riscv-code.fd
QEMU_EDK2_VARS_RISCV64 += $(SNAP)/components/qemu-riscv64/share/qemu/edk2-riscv-vars.fd
endif

ifneq (,$(value GARDEN_RISCV64_PREFIX))
QEMU_EDK2_CODE_RISCV64 += $(GARDEN_RISCV64_PREFIX)/share/qemu/edk2-riscv-code.fd
QEMU_EDK2_VARS_RISCV64 += $(GARDEN_RISCV64_PREFIX)/share/qemu/edk2-riscv-vars.fd
endif

efi-code.riscv64.img: $(or $(firstword $(wildcard $(QEMU_EDK2_CODE_RISCV64))),$(warning please install riscv64 edk2 firmware - not in $(QEMU_EDK2_CODE_RISCV64)))
	cp --preserve=timestamps $< $@
	# RISCV64 virtual machine requires 32MiB flash size.
	truncate --size 32MiB $@

efi-vars.riscv64.img: $(or $(firstword $(wildcard $(QEMU_EDK2_VARS_RISCV64))),$(warning please install riscv64 edk2 firmware - not in $(QEMU_EDK2_VARS_RISCV64)))
	cp --preserve=timestamps $< $@
	# RISCV64 virtual machine requires 32MiB flash size.
	truncate --size 32MiB $@

%.riscv64.efi-code.img: | efi-code.riscv64.img
	ln -sf $(firstword $|) $@

%.riscv64.efi-vars.img: efi-vars.riscv64.img
	cp --preserve=timestamps $< $@

.PHONY: clean
clean::
	rm -f efi-code.riscv64.img efi-vars.riscv64.img
	rm -f *.riscv64.qcow2 *.riscv64.efi-code.img *.riscv64.efi-vars.img
