//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// KustoPoolPrincipalAssignmentsServer is a fake server for instances of the armsynapse.KustoPoolPrincipalAssignmentsClient type.
type KustoPoolPrincipalAssignmentsServer struct {
	// CheckNameAvailability is the fake for method KustoPoolPrincipalAssignmentsClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, principalAssignmentName armsynapse.ClusterPrincipalAssignmentCheckNameRequest, options *armsynapse.KustoPoolPrincipalAssignmentsClientCheckNameAvailabilityOptions) (resp azfake.Responder[armsynapse.KustoPoolPrincipalAssignmentsClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method KustoPoolPrincipalAssignmentsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, workspaceName string, kustoPoolName string, principalAssignmentName string, resourceGroupName string, parameters armsynapse.ClusterPrincipalAssignment, options *armsynapse.KustoPoolPrincipalAssignmentsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method KustoPoolPrincipalAssignmentsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, workspaceName string, kustoPoolName string, principalAssignmentName string, resourceGroupName string, options *armsynapse.KustoPoolPrincipalAssignmentsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method KustoPoolPrincipalAssignmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, workspaceName string, kustoPoolName string, principalAssignmentName string, resourceGroupName string, options *armsynapse.KustoPoolPrincipalAssignmentsClientGetOptions) (resp azfake.Responder[armsynapse.KustoPoolPrincipalAssignmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method KustoPoolPrincipalAssignmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolPrincipalAssignmentsClientListOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientListResponse])
}

// NewKustoPoolPrincipalAssignmentsServerTransport creates a new instance of KustoPoolPrincipalAssignmentsServerTransport with the provided implementation.
// The returned KustoPoolPrincipalAssignmentsServerTransport instance is connected to an instance of armsynapse.KustoPoolPrincipalAssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewKustoPoolPrincipalAssignmentsServerTransport(srv *KustoPoolPrincipalAssignmentsServer) *KustoPoolPrincipalAssignmentsServerTransport {
	return &KustoPoolPrincipalAssignmentsServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientListResponse]](),
	}
}

// KustoPoolPrincipalAssignmentsServerTransport connects instances of armsynapse.KustoPoolPrincipalAssignmentsClient to instances of KustoPoolPrincipalAssignmentsServer.
// Don't use this type directly, use NewKustoPoolPrincipalAssignmentsServerTransport instead.
type KustoPoolPrincipalAssignmentsServerTransport struct {
	srv                 *KustoPoolPrincipalAssignmentsServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armsynapse.KustoPoolPrincipalAssignmentsClientListResponse]]
}

// Do implements the policy.Transporter interface for KustoPoolPrincipalAssignmentsServerTransport.
func (k *KustoPoolPrincipalAssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "KustoPoolPrincipalAssignmentsClient.CheckNameAvailability":
		resp, err = k.dispatchCheckNameAvailability(req)
	case "KustoPoolPrincipalAssignmentsClient.BeginCreateOrUpdate":
		resp, err = k.dispatchBeginCreateOrUpdate(req)
	case "KustoPoolPrincipalAssignmentsClient.BeginDelete":
		resp, err = k.dispatchBeginDelete(req)
	case "KustoPoolPrincipalAssignmentsClient.Get":
		resp, err = k.dispatchGet(req)
	case "KustoPoolPrincipalAssignmentsClient.NewListPager":
		resp, err = k.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (k *KustoPoolPrincipalAssignmentsServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if k.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkPrincipalAssignmentNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.ClusterPrincipalAssignmentCheckNameRequest](req)
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.CheckNameAvailability(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolPrincipalAssignmentsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if k.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := k.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/principalAssignments/(?P<principalAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.ClusterPrincipalAssignment](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		principalAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("principalAssignmentName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginCreateOrUpdate(req.Context(), workspaceNameParam, kustoPoolNameParam, principalAssignmentNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		k.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		k.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		k.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolPrincipalAssignmentsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if k.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := k.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/principalAssignments/(?P<principalAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		principalAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("principalAssignmentName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginDelete(req.Context(), workspaceNameParam, kustoPoolNameParam, principalAssignmentNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		k.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		k.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		k.beginDelete.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolPrincipalAssignmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if k.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/principalAssignments/(?P<principalAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
	if err != nil {
		return nil, err
	}
	principalAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("principalAssignmentName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.Get(req.Context(), workspaceNameParam, kustoPoolNameParam, principalAssignmentNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterPrincipalAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolPrincipalAssignmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := k.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/principalAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := k.srv.NewListPager(workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		newListPager = &resp
		k.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		k.newListPager.remove(req)
	}
	return resp, nil
}
