//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedDatabaseMoveOperationResultList.json
func ExampleManagedDatabaseMoveOperationsClient_NewListByLocationPager_getsAllManagedDatabaseMoveOperationsForSpecifiedSubscriptionResourceGroupAndLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedDatabaseMoveOperationsClient().NewListByLocationPager("rg1", "westeurope", &armsql.ManagedDatabaseMoveOperationsClientListByLocationOptions{OnlyLatestPerDatabase: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedDatabaseMoveOperationListResult = armsql.ManagedDatabaseMoveOperationListResult{
		// 	Value: []*armsql.ManagedDatabaseMoveOperationResult{
		// 		{
		// 			Name: to.Ptr("15961324-d809-46ed-86b9-d786953140e2"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
		// 			ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/15961324-d809-46ed-86b9-d786953140e2"),
		// 			Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
		// 				IsCancellable: to.Ptr(false),
		// 				Operation: to.Ptr("startManagedInstanceDatabaseMove"),
		// 				OperationFriendlyName: to.Ptr("Start Azure SQL Managed Instance database move"),
		// 				OperationMode: to.Ptr(armsql.MoveOperationModeMove),
		// 				SourceDatabaseName: to.Ptr("db1"),
		// 				SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
		// 				SourceManagedInstanceName: to.Ptr("mi1"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T12:54:29.720Z"); return t}()),
		// 				State: to.Ptr(armsql.ManagementOperationStateSucceeded),
		// 				TargetDatabaseName: to.Ptr("db1"),
		// 				TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
		// 				TargetManagedInstanceName: to.Ptr("mi2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("12341324-e123-45cd-86b9-d786953131a5"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
		// 			ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/12341324-e123-45cd-86b9-d786953131a5"),
		// 			Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
		// 				IsCancellable: to.Ptr(true),
		// 				Operation: to.Ptr("ContinueManagedInstanceDatabaseMove"),
		// 				OperationFriendlyName: to.Ptr("Complete Azure SQL Managed Instance database move"),
		// 				OperationMode: to.Ptr(armsql.MoveOperationModeMove),
		// 				SourceDatabaseName: to.Ptr("db1"),
		// 				SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
		// 				SourceManagedInstanceName: to.Ptr("mi1"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T12:54:29.720Z"); return t}()),
		// 				State: to.Ptr(armsql.ManagementOperationStateInProgress),
		// 				TargetDatabaseName: to.Ptr("db1"),
		// 				TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
		// 				TargetManagedInstanceName: to.Ptr("mi2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("87654321-30a2-f39a-z171-b78695fg32a8"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
		// 			ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/87654321-30a2-f39a-z171-b78695fg32a8"),
		// 			Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
		// 				IsCancellable: to.Ptr(true),
		// 				Operation: to.Ptr("StartManagedInstanceDatabaseMove"),
		// 				OperationFriendlyName: to.Ptr("Start Azure SQL Managed Instance database move"),
		// 				OperationMode: to.Ptr(armsql.MoveOperationModeCopy),
		// 				SourceDatabaseName: to.Ptr("db2"),
		// 				SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
		// 				SourceManagedInstanceName: to.Ptr("mi1"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T13:37:19.710Z"); return t}()),
		// 				State: to.Ptr(armsql.ManagementOperationStateInProgress),
		// 				TargetDatabaseName: to.Ptr("db2"),
		// 				TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
		// 				TargetManagedInstanceName: to.Ptr("mi2"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedDatabaseMoveOperationResultListMax.json
func ExampleManagedDatabaseMoveOperationsClient_NewListByLocationPager_getsTheLatestManagedDatabaseMoveOperationsForEachDatabaseUnderSpecifiedSubscriptionResourceGroupAndLocationFilteredByOperationType() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedDatabaseMoveOperationsClient().NewListByLocationPager("rg1", "westeurope", &armsql.ManagedDatabaseMoveOperationsClientListByLocationOptions{OnlyLatestPerDatabase: nil,
		Filter: to.Ptr("Properties/Operation eq 'StartManagedInstanceDatabaseMove'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedDatabaseMoveOperationListResult = armsql.ManagedDatabaseMoveOperationListResult{
		// 	Value: []*armsql.ManagedDatabaseMoveOperationResult{
		// 		{
		// 			Name: to.Ptr("87654321-30a2-f39a-z171-b78695fg32a8"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
		// 			ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/87654321-30a2-f39a-z171-b78695fg32a8"),
		// 			Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
		// 				IsCancellable: to.Ptr(true),
		// 				Operation: to.Ptr("StartManagedInstanceDatabaseMove"),
		// 				OperationFriendlyName: to.Ptr("Start Azure SQL Managed Instance database move"),
		// 				OperationMode: to.Ptr(armsql.MoveOperationModeCopy),
		// 				SourceDatabaseName: to.Ptr("db1"),
		// 				SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
		// 				SourceManagedInstanceName: to.Ptr("mi1"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T12:54:29.720Z"); return t}()),
		// 				State: to.Ptr(armsql.ManagementOperationStateInProgress),
		// 				TargetDatabaseName: to.Ptr("db1"),
		// 				TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
		// 				TargetManagedInstanceName: to.Ptr("mi2"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedDatabaseMoveOperationResultListLastOperations.json
func ExampleManagedDatabaseMoveOperationsClient_NewListByLocationPager_getsTheLatestManagedDatabaseMoveOperationsForEachDatabaseUnderSpecifiedSubscriptionResourceGroupAndLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedDatabaseMoveOperationsClient().NewListByLocationPager("rg1", "westeurope", &armsql.ManagedDatabaseMoveOperationsClientListByLocationOptions{OnlyLatestPerDatabase: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedDatabaseMoveOperationListResult = armsql.ManagedDatabaseMoveOperationListResult{
		// 	Value: []*armsql.ManagedDatabaseMoveOperationResult{
		// 		{
		// 			Name: to.Ptr("12341324-e123-45cd-86b9-d786953131a5"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
		// 			ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/12341324-e123-45cd-86b9-d786953131a5"),
		// 			Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
		// 				IsCancellable: to.Ptr(true),
		// 				Operation: to.Ptr("ContinueManagedInstanceDatabaseMove"),
		// 				OperationFriendlyName: to.Ptr("Complete Azure SQL Managed Instance database move"),
		// 				OperationMode: to.Ptr(armsql.MoveOperationModeMove),
		// 				SourceDatabaseName: to.Ptr("db1"),
		// 				SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
		// 				SourceManagedInstanceName: to.Ptr("mi1"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T12:54:29.720Z"); return t}()),
		// 				State: to.Ptr(armsql.ManagementOperationStateInProgress),
		// 				TargetDatabaseName: to.Ptr("db1"),
		// 				TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
		// 				TargetManagedInstanceName: to.Ptr("mi2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("87654321-30a2-f39a-z171-b78695fg32a8"),
		// 			Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
		// 			ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/87654321-30a2-f39a-z171-b78695fg32a8"),
		// 			Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
		// 				IsCancellable: to.Ptr(true),
		// 				Operation: to.Ptr("StartManagedInstanceDatabaseMove"),
		// 				OperationFriendlyName: to.Ptr("Start Azure SQL Managed Instance database move"),
		// 				OperationMode: to.Ptr(armsql.MoveOperationModeCopy),
		// 				SourceDatabaseName: to.Ptr("db2"),
		// 				SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
		// 				SourceManagedInstanceName: to.Ptr("mi1"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T13:37:19.710Z"); return t}()),
		// 				State: to.Ptr(armsql.ManagementOperationStateInProgress),
		// 				TargetDatabaseName: to.Ptr("db2"),
		// 				TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
		// 				TargetManagedInstanceName: to.Ptr("mi2"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2022-05-01-preview/examples/ManagedDatabaseMoveOperationResultGet.json
func ExampleManagedDatabaseMoveOperationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedDatabaseMoveOperationsClient().Get(ctx, "rg1", "westeurope", "15961324-d809-46ed-86b9-d786953140e2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedDatabaseMoveOperationResult = armsql.ManagedDatabaseMoveOperationResult{
	// 	Name: to.Ptr("15961324-d809-46ed-86b9-d786953140e2"),
	// 	Type: to.Ptr("Microsoft.Sql/locations/managedDatabaseMoveOperationResults"),
	// 	ID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/locations/westeurope/managedDatabaseMoveOperationResults/15961324-d809-46ed-86b9-d786953140e2"),
	// 	Properties: &armsql.ManagedDatabaseMoveOperationResultProperties{
	// 		IsCancellable: to.Ptr(true),
	// 		Operation: to.Ptr("StartManagedInstanceDatabaseMove"),
	// 		OperationFriendlyName: to.Ptr("Start Azure SQL Managed Instance database move"),
	// 		OperationMode: to.Ptr(armsql.MoveOperationModeMove),
	// 		SourceDatabaseName: to.Ptr("db1"),
	// 		SourceManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg1/providers/Microsoft.Sql/managedInstances/mi1"),
	// 		SourceManagedInstanceName: to.Ptr("mi1"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-05-24T12:54:29.720Z"); return t}()),
	// 		State: to.Ptr(armsql.ManagementOperationStateInProgress),
	// 		TargetDatabaseName: to.Ptr("db1"),
	// 		TargetManagedInstanceID: to.Ptr("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/rg2/providers/Microsoft.Sql/managedInstances/mi2"),
	// 		TargetManagedInstanceName: to.Ptr("mi2"),
	// 	},
	// }
}
