//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplace

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PrivateStoreCollectionClient contains the methods for the PrivateStoreCollection group.
// Don't use this type directly, use NewPrivateStoreCollectionClient() instead.
type PrivateStoreCollectionClient struct {
	internal *arm.Client
}

// NewPrivateStoreCollectionClient creates a new instance of PrivateStoreCollectionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPrivateStoreCollectionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PrivateStoreCollectionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PrivateStoreCollectionClient{
		internal: cl,
	}
	return client, nil
}

// CreateOrUpdate - Create or update private store collection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - privateStoreID - The store ID - must use the tenant ID
//   - collectionID - The collection ID
//   - options - PrivateStoreCollectionClientCreateOrUpdateOptions contains the optional parameters for the PrivateStoreCollectionClient.CreateOrUpdate
//     method.
func (client *PrivateStoreCollectionClient) CreateOrUpdate(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientCreateOrUpdateOptions) (PrivateStoreCollectionClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "PrivateStoreCollectionClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, privateStoreID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateStoreCollectionClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateStoreCollectionClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PrivateStoreCollectionClient) createOrUpdateCreateRequest(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		if err := runtime.MarshalAsJSON(req, *options.Payload); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *PrivateStoreCollectionClient) createOrUpdateHandleResponse(resp *http.Response) (PrivateStoreCollectionClientCreateOrUpdateResponse, error) {
	result := PrivateStoreCollectionClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Collection); err != nil {
		return PrivateStoreCollectionClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a collection from the given private store.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - privateStoreID - The store ID - must use the tenant ID
//   - collectionID - The collection ID
//   - options - PrivateStoreCollectionClientDeleteOptions contains the optional parameters for the PrivateStoreCollectionClient.Delete
//     method.
func (client *PrivateStoreCollectionClient) Delete(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientDeleteOptions) (PrivateStoreCollectionClientDeleteResponse, error) {
	var err error
	const operationName = "PrivateStoreCollectionClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, privateStoreID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateStoreCollectionClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PrivateStoreCollectionClientDeleteResponse{}, err
	}
	return PrivateStoreCollectionClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PrivateStoreCollectionClient) deleteCreateRequest(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets private store collection
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - privateStoreID - The store ID - must use the tenant ID
//   - collectionID - The collection ID
//   - options - PrivateStoreCollectionClientGetOptions contains the optional parameters for the PrivateStoreCollectionClient.Get
//     method.
func (client *PrivateStoreCollectionClient) Get(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientGetOptions) (PrivateStoreCollectionClientGetResponse, error) {
	var err error
	const operationName = "PrivateStoreCollectionClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, privateStoreID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateStoreCollectionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateStoreCollectionClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *PrivateStoreCollectionClient) getCreateRequest(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PrivateStoreCollectionClient) getHandleResponse(resp *http.Response) (PrivateStoreCollectionClientGetResponse, error) {
	result := PrivateStoreCollectionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Collection); err != nil {
		return PrivateStoreCollectionClientGetResponse{}, err
	}
	return result, nil
}

// List - Gets private store collections list
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - privateStoreID - The store ID - must use the tenant ID
//   - options - PrivateStoreCollectionClientListOptions contains the optional parameters for the PrivateStoreCollectionClient.List
//     method.
func (client *PrivateStoreCollectionClient) List(ctx context.Context, privateStoreID string, options *PrivateStoreCollectionClientListOptions) (PrivateStoreCollectionClientListResponse, error) {
	var err error
	const operationName = "PrivateStoreCollectionClient.List"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCreateRequest(ctx, privateStoreID, options)
	if err != nil {
		return PrivateStoreCollectionClientListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateStoreCollectionClientListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateStoreCollectionClientListResponse{}, err
	}
	resp, err := client.listHandleResponse(httpResp)
	return resp, err
}

// listCreateRequest creates the List request.
func (client *PrivateStoreCollectionClient) listCreateRequest(ctx context.Context, privateStoreID string, options *PrivateStoreCollectionClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *PrivateStoreCollectionClient) listHandleResponse(resp *http.Response) (PrivateStoreCollectionClientListResponse, error) {
	result := PrivateStoreCollectionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CollectionsList); err != nil {
		return PrivateStoreCollectionClientListResponse{}, err
	}
	return result, nil
}

// Post - Delete Private store collection. This is a workaround.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - privateStoreID - The store ID - must use the tenant ID
//   - collectionID - The collection ID
//   - options - PrivateStoreCollectionClientPostOptions contains the optional parameters for the PrivateStoreCollectionClient.Post
//     method.
func (client *PrivateStoreCollectionClient) Post(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientPostOptions) (PrivateStoreCollectionClientPostResponse, error) {
	var err error
	const operationName = "PrivateStoreCollectionClient.Post"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.postCreateRequest(ctx, privateStoreID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionClientPostResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateStoreCollectionClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateStoreCollectionClientPostResponse{}, err
	}
	return PrivateStoreCollectionClientPostResponse{}, nil
}

// postCreateRequest creates the Post request.
func (client *PrivateStoreCollectionClient) postCreateRequest(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientPostOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		if err := runtime.MarshalAsJSON(req, *options.Payload); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// TransferOffers - transferring offers (copy or move) from source collection to target collection(s)
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01
//   - privateStoreID - The store ID - must use the tenant ID
//   - collectionID - The collection ID
//   - options - PrivateStoreCollectionClientTransferOffersOptions contains the optional parameters for the PrivateStoreCollectionClient.TransferOffers
//     method.
func (client *PrivateStoreCollectionClient) TransferOffers(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientTransferOffersOptions) (PrivateStoreCollectionClientTransferOffersResponse, error) {
	var err error
	const operationName = "PrivateStoreCollectionClient.TransferOffers"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.transferOffersCreateRequest(ctx, privateStoreID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionClientTransferOffersResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateStoreCollectionClientTransferOffersResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateStoreCollectionClientTransferOffersResponse{}, err
	}
	resp, err := client.transferOffersHandleResponse(httpResp)
	return resp, err
}

// transferOffersCreateRequest creates the TransferOffers request.
func (client *PrivateStoreCollectionClient) transferOffersCreateRequest(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionClientTransferOffersOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/transferOffers"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		if err := runtime.MarshalAsJSON(req, *options.Payload); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// transferOffersHandleResponse handles the TransferOffers response.
func (client *PrivateStoreCollectionClient) transferOffersHandleResponse(resp *http.Response) (PrivateStoreCollectionClientTransferOffersResponse, error) {
	result := PrivateStoreCollectionClientTransferOffersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TransferOffersResponse); err != nil {
		return PrivateStoreCollectionClientTransferOffersResponse{}, err
	}
	return result, nil
}
