//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
	"net/http"
	"net/url"
	"regexp"
)

// SharesServer is a fake server for instances of the armdatashare.SharesClient type.
type SharesServer struct {
	// Create is the fake for method SharesClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, accountName string, shareName string, share armdatashare.Share, options *armdatashare.SharesClientCreateOptions) (resp azfake.Responder[armdatashare.SharesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SharesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, shareName string, options *armdatashare.SharesClientBeginDeleteOptions) (resp azfake.PollerResponder[armdatashare.SharesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SharesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, shareName string, options *armdatashare.SharesClientGetOptions) (resp azfake.Responder[armdatashare.SharesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAccountPager is the fake for method SharesClient.NewListByAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAccountPager func(resourceGroupName string, accountName string, options *armdatashare.SharesClientListByAccountOptions) (resp azfake.PagerResponder[armdatashare.SharesClientListByAccountResponse])

	// NewListSynchronizationDetailsPager is the fake for method SharesClient.NewListSynchronizationDetailsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSynchronizationDetailsPager func(resourceGroupName string, accountName string, shareName string, shareSynchronization armdatashare.ShareSynchronization, options *armdatashare.SharesClientListSynchronizationDetailsOptions) (resp azfake.PagerResponder[armdatashare.SharesClientListSynchronizationDetailsResponse])

	// NewListSynchronizationsPager is the fake for method SharesClient.NewListSynchronizationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSynchronizationsPager func(resourceGroupName string, accountName string, shareName string, options *armdatashare.SharesClientListSynchronizationsOptions) (resp azfake.PagerResponder[armdatashare.SharesClientListSynchronizationsResponse])
}

// NewSharesServerTransport creates a new instance of SharesServerTransport with the provided implementation.
// The returned SharesServerTransport instance is connected to an instance of armdatashare.SharesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSharesServerTransport(srv *SharesServer) *SharesServerTransport {
	return &SharesServerTransport{
		srv:                                srv,
		beginDelete:                        newTracker[azfake.PollerResponder[armdatashare.SharesClientDeleteResponse]](),
		newListByAccountPager:              newTracker[azfake.PagerResponder[armdatashare.SharesClientListByAccountResponse]](),
		newListSynchronizationDetailsPager: newTracker[azfake.PagerResponder[armdatashare.SharesClientListSynchronizationDetailsResponse]](),
		newListSynchronizationsPager:       newTracker[azfake.PagerResponder[armdatashare.SharesClientListSynchronizationsResponse]](),
	}
}

// SharesServerTransport connects instances of armdatashare.SharesClient to instances of SharesServer.
// Don't use this type directly, use NewSharesServerTransport instead.
type SharesServerTransport struct {
	srv                                *SharesServer
	beginDelete                        *tracker[azfake.PollerResponder[armdatashare.SharesClientDeleteResponse]]
	newListByAccountPager              *tracker[azfake.PagerResponder[armdatashare.SharesClientListByAccountResponse]]
	newListSynchronizationDetailsPager *tracker[azfake.PagerResponder[armdatashare.SharesClientListSynchronizationDetailsResponse]]
	newListSynchronizationsPager       *tracker[azfake.PagerResponder[armdatashare.SharesClientListSynchronizationsResponse]]
}

// Do implements the policy.Transporter interface for SharesServerTransport.
func (s *SharesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SharesClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SharesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SharesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SharesClient.NewListByAccountPager":
		resp, err = s.dispatchNewListByAccountPager(req)
	case "SharesClient.NewListSynchronizationDetailsPager":
		resp, err = s.dispatchNewListSynchronizationDetailsPager(req)
	case "SharesClient.NewListSynchronizationsPager":
		resp, err = s.dispatchNewListSynchronizationsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SharesServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatashare.Share](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Share, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SharesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SharesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, shareNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Share, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SharesServerTransport) dispatchNewListByAccountPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAccountPager not implemented")}
	}
	newListByAccountPager := s.newListByAccountPager.get(req)
	if newListByAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdatashare.SharesClientListByAccountOptions
		if skipTokenParam != nil || filterParam != nil || orderbyParam != nil {
			options = &armdatashare.SharesClientListByAccountOptions{
				SkipToken: skipTokenParam,
				Filter:    filterParam,
				Orderby:   orderbyParam,
			}
		}
		resp := s.srv.NewListByAccountPager(resourceGroupNameParam, accountNameParam, options)
		newListByAccountPager = &resp
		s.newListByAccountPager.add(req, newListByAccountPager)
		server.PagerResponderInjectNextLinks(newListByAccountPager, req, func(page *armdatashare.SharesClientListByAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAccountPager) {
		s.newListByAccountPager.remove(req)
	}
	return resp, nil
}

func (s *SharesServerTransport) dispatchNewListSynchronizationDetailsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSynchronizationDetailsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSynchronizationDetailsPager not implemented")}
	}
	newListSynchronizationDetailsPager := s.newListSynchronizationDetailsPager.get(req)
	if newListSynchronizationDetailsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSynchronizationDetails`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armdatashare.ShareSynchronization](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdatashare.SharesClientListSynchronizationDetailsOptions
		if skipTokenParam != nil || filterParam != nil || orderbyParam != nil {
			options = &armdatashare.SharesClientListSynchronizationDetailsOptions{
				SkipToken: skipTokenParam,
				Filter:    filterParam,
				Orderby:   orderbyParam,
			}
		}
		resp := s.srv.NewListSynchronizationDetailsPager(resourceGroupNameParam, accountNameParam, shareNameParam, body, options)
		newListSynchronizationDetailsPager = &resp
		s.newListSynchronizationDetailsPager.add(req, newListSynchronizationDetailsPager)
		server.PagerResponderInjectNextLinks(newListSynchronizationDetailsPager, req, func(page *armdatashare.SharesClientListSynchronizationDetailsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSynchronizationDetailsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSynchronizationDetailsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSynchronizationDetailsPager) {
		s.newListSynchronizationDetailsPager.remove(req)
	}
	return resp, nil
}

func (s *SharesServerTransport) dispatchNewListSynchronizationsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSynchronizationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSynchronizationsPager not implemented")}
	}
	newListSynchronizationsPager := s.newListSynchronizationsPager.get(req)
	if newListSynchronizationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shares/(?P<shareName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSynchronizations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdatashare.SharesClientListSynchronizationsOptions
		if skipTokenParam != nil || filterParam != nil || orderbyParam != nil {
			options = &armdatashare.SharesClientListSynchronizationsOptions{
				SkipToken: skipTokenParam,
				Filter:    filterParam,
				Orderby:   orderbyParam,
			}
		}
		resp := s.srv.NewListSynchronizationsPager(resourceGroupNameParam, accountNameParam, shareNameParam, options)
		newListSynchronizationsPager = &resp
		s.newListSynchronizationsPager.add(req, newListSynchronizationsPager)
		server.PagerResponderInjectNextLinks(newListSynchronizationsPager, req, func(page *armdatashare.SharesClientListSynchronizationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSynchronizationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSynchronizationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSynchronizationsPager) {
		s.newListSynchronizationsPager.remove(req)
	}
	return resp, nil
}
