//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// GremlinResourcesServer is a fake server for instances of the armcosmos.GremlinResourcesClient type.
type GremlinResourcesServer struct {
	// BeginCreateUpdateGremlinDatabase is the fake for method GremlinResourcesClient.BeginCreateUpdateGremlinDatabase
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateGremlinDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateGremlinDatabaseParameters armcosmos.GremlinDatabaseCreateUpdateParameters, options *armcosmos.GremlinResourcesClientBeginCreateUpdateGremlinDatabaseOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientCreateUpdateGremlinDatabaseResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateGremlinGraph is the fake for method GremlinResourcesClient.BeginCreateUpdateGremlinGraph
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateGremlinGraph func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, createUpdateGremlinGraphParameters armcosmos.GremlinGraphCreateUpdateParameters, options *armcosmos.GremlinResourcesClientBeginCreateUpdateGremlinGraphOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientCreateUpdateGremlinGraphResponse], errResp azfake.ErrorResponder)

	// BeginDeleteGremlinDatabase is the fake for method GremlinResourcesClient.BeginDeleteGremlinDatabase
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteGremlinDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.GremlinResourcesClientBeginDeleteGremlinDatabaseOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientDeleteGremlinDatabaseResponse], errResp azfake.ErrorResponder)

	// BeginDeleteGremlinGraph is the fake for method GremlinResourcesClient.BeginDeleteGremlinGraph
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteGremlinGraph func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, options *armcosmos.GremlinResourcesClientBeginDeleteGremlinGraphOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientDeleteGremlinGraphResponse], errResp azfake.ErrorResponder)

	// GetGremlinDatabase is the fake for method GremlinResourcesClient.GetGremlinDatabase
	// HTTP status codes to indicate success: http.StatusOK
	GetGremlinDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.GremlinResourcesClientGetGremlinDatabaseOptions) (resp azfake.Responder[armcosmos.GremlinResourcesClientGetGremlinDatabaseResponse], errResp azfake.ErrorResponder)

	// GetGremlinDatabaseThroughput is the fake for method GremlinResourcesClient.GetGremlinDatabaseThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetGremlinDatabaseThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.GremlinResourcesClientGetGremlinDatabaseThroughputOptions) (resp azfake.Responder[armcosmos.GremlinResourcesClientGetGremlinDatabaseThroughputResponse], errResp azfake.ErrorResponder)

	// GetGremlinGraph is the fake for method GremlinResourcesClient.GetGremlinGraph
	// HTTP status codes to indicate success: http.StatusOK
	GetGremlinGraph func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, options *armcosmos.GremlinResourcesClientGetGremlinGraphOptions) (resp azfake.Responder[armcosmos.GremlinResourcesClientGetGremlinGraphResponse], errResp azfake.ErrorResponder)

	// GetGremlinGraphThroughput is the fake for method GremlinResourcesClient.GetGremlinGraphThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetGremlinGraphThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, options *armcosmos.GremlinResourcesClientGetGremlinGraphThroughputOptions) (resp azfake.Responder[armcosmos.GremlinResourcesClientGetGremlinGraphThroughputResponse], errResp azfake.ErrorResponder)

	// NewListGremlinDatabasesPager is the fake for method GremlinResourcesClient.NewListGremlinDatabasesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGremlinDatabasesPager func(resourceGroupName string, accountName string, options *armcosmos.GremlinResourcesClientListGremlinDatabasesOptions) (resp azfake.PagerResponder[armcosmos.GremlinResourcesClientListGremlinDatabasesResponse])

	// NewListGremlinGraphsPager is the fake for method GremlinResourcesClient.NewListGremlinGraphsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListGremlinGraphsPager func(resourceGroupName string, accountName string, databaseName string, options *armcosmos.GremlinResourcesClientListGremlinGraphsOptions) (resp azfake.PagerResponder[armcosmos.GremlinResourcesClientListGremlinGraphsResponse])

	// BeginMigrateGremlinDatabaseToAutoscale is the fake for method GremlinResourcesClient.BeginMigrateGremlinDatabaseToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateGremlinDatabaseToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.GremlinResourcesClientBeginMigrateGremlinDatabaseToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinDatabaseToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateGremlinDatabaseToManualThroughput is the fake for method GremlinResourcesClient.BeginMigrateGremlinDatabaseToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateGremlinDatabaseToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.GremlinResourcesClientBeginMigrateGremlinDatabaseToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinDatabaseToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMigrateGremlinGraphToAutoscale is the fake for method GremlinResourcesClient.BeginMigrateGremlinGraphToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateGremlinGraphToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, options *armcosmos.GremlinResourcesClientBeginMigrateGremlinGraphToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinGraphToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateGremlinGraphToManualThroughput is the fake for method GremlinResourcesClient.BeginMigrateGremlinGraphToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateGremlinGraphToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, options *armcosmos.GremlinResourcesClientBeginMigrateGremlinGraphToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinGraphToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginRetrieveContinuousBackupInformation is the fake for method GremlinResourcesClient.BeginRetrieveContinuousBackupInformation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRetrieveContinuousBackupInformation func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, location armcosmos.ContinuousBackupRestoreLocation, options *armcosmos.GremlinResourcesClientBeginRetrieveContinuousBackupInformationOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientRetrieveContinuousBackupInformationResponse], errResp azfake.ErrorResponder)

	// BeginUpdateGremlinDatabaseThroughput is the fake for method GremlinResourcesClient.BeginUpdateGremlinDatabaseThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateGremlinDatabaseThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.GremlinResourcesClientBeginUpdateGremlinDatabaseThroughputOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientUpdateGremlinDatabaseThroughputResponse], errResp azfake.ErrorResponder)

	// BeginUpdateGremlinGraphThroughput is the fake for method GremlinResourcesClient.BeginUpdateGremlinGraphThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateGremlinGraphThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.GremlinResourcesClientBeginUpdateGremlinGraphThroughputOptions) (resp azfake.PollerResponder[armcosmos.GremlinResourcesClientUpdateGremlinGraphThroughputResponse], errResp azfake.ErrorResponder)
}

// NewGremlinResourcesServerTransport creates a new instance of GremlinResourcesServerTransport with the provided implementation.
// The returned GremlinResourcesServerTransport instance is connected to an instance of armcosmos.GremlinResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGremlinResourcesServerTransport(srv *GremlinResourcesServer) *GremlinResourcesServerTransport {
	return &GremlinResourcesServerTransport{
		srv:                                           srv,
		beginCreateUpdateGremlinDatabase:              newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientCreateUpdateGremlinDatabaseResponse]](),
		beginCreateUpdateGremlinGraph:                 newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientCreateUpdateGremlinGraphResponse]](),
		beginDeleteGremlinDatabase:                    newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientDeleteGremlinDatabaseResponse]](),
		beginDeleteGremlinGraph:                       newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientDeleteGremlinGraphResponse]](),
		newListGremlinDatabasesPager:                  newTracker[azfake.PagerResponder[armcosmos.GremlinResourcesClientListGremlinDatabasesResponse]](),
		newListGremlinGraphsPager:                     newTracker[azfake.PagerResponder[armcosmos.GremlinResourcesClientListGremlinGraphsResponse]](),
		beginMigrateGremlinDatabaseToAutoscale:        newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinDatabaseToAutoscaleResponse]](),
		beginMigrateGremlinDatabaseToManualThroughput: newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinDatabaseToManualThroughputResponse]](),
		beginMigrateGremlinGraphToAutoscale:           newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinGraphToAutoscaleResponse]](),
		beginMigrateGremlinGraphToManualThroughput:    newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinGraphToManualThroughputResponse]](),
		beginRetrieveContinuousBackupInformation:      newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientRetrieveContinuousBackupInformationResponse]](),
		beginUpdateGremlinDatabaseThroughput:          newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientUpdateGremlinDatabaseThroughputResponse]](),
		beginUpdateGremlinGraphThroughput:             newTracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientUpdateGremlinGraphThroughputResponse]](),
	}
}

// GremlinResourcesServerTransport connects instances of armcosmos.GremlinResourcesClient to instances of GremlinResourcesServer.
// Don't use this type directly, use NewGremlinResourcesServerTransport instead.
type GremlinResourcesServerTransport struct {
	srv                                           *GremlinResourcesServer
	beginCreateUpdateGremlinDatabase              *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientCreateUpdateGremlinDatabaseResponse]]
	beginCreateUpdateGremlinGraph                 *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientCreateUpdateGremlinGraphResponse]]
	beginDeleteGremlinDatabase                    *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientDeleteGremlinDatabaseResponse]]
	beginDeleteGremlinGraph                       *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientDeleteGremlinGraphResponse]]
	newListGremlinDatabasesPager                  *tracker[azfake.PagerResponder[armcosmos.GremlinResourcesClientListGremlinDatabasesResponse]]
	newListGremlinGraphsPager                     *tracker[azfake.PagerResponder[armcosmos.GremlinResourcesClientListGremlinGraphsResponse]]
	beginMigrateGremlinDatabaseToAutoscale        *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinDatabaseToAutoscaleResponse]]
	beginMigrateGremlinDatabaseToManualThroughput *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinDatabaseToManualThroughputResponse]]
	beginMigrateGremlinGraphToAutoscale           *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinGraphToAutoscaleResponse]]
	beginMigrateGremlinGraphToManualThroughput    *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientMigrateGremlinGraphToManualThroughputResponse]]
	beginRetrieveContinuousBackupInformation      *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientRetrieveContinuousBackupInformationResponse]]
	beginUpdateGremlinDatabaseThroughput          *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientUpdateGremlinDatabaseThroughputResponse]]
	beginUpdateGremlinGraphThroughput             *tracker[azfake.PollerResponder[armcosmos.GremlinResourcesClientUpdateGremlinGraphThroughputResponse]]
}

// Do implements the policy.Transporter interface for GremlinResourcesServerTransport.
func (g *GremlinResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GremlinResourcesClient.BeginCreateUpdateGremlinDatabase":
		resp, err = g.dispatchBeginCreateUpdateGremlinDatabase(req)
	case "GremlinResourcesClient.BeginCreateUpdateGremlinGraph":
		resp, err = g.dispatchBeginCreateUpdateGremlinGraph(req)
	case "GremlinResourcesClient.BeginDeleteGremlinDatabase":
		resp, err = g.dispatchBeginDeleteGremlinDatabase(req)
	case "GremlinResourcesClient.BeginDeleteGremlinGraph":
		resp, err = g.dispatchBeginDeleteGremlinGraph(req)
	case "GremlinResourcesClient.GetGremlinDatabase":
		resp, err = g.dispatchGetGremlinDatabase(req)
	case "GremlinResourcesClient.GetGremlinDatabaseThroughput":
		resp, err = g.dispatchGetGremlinDatabaseThroughput(req)
	case "GremlinResourcesClient.GetGremlinGraph":
		resp, err = g.dispatchGetGremlinGraph(req)
	case "GremlinResourcesClient.GetGremlinGraphThroughput":
		resp, err = g.dispatchGetGremlinGraphThroughput(req)
	case "GremlinResourcesClient.NewListGremlinDatabasesPager":
		resp, err = g.dispatchNewListGremlinDatabasesPager(req)
	case "GremlinResourcesClient.NewListGremlinGraphsPager":
		resp, err = g.dispatchNewListGremlinGraphsPager(req)
	case "GremlinResourcesClient.BeginMigrateGremlinDatabaseToAutoscale":
		resp, err = g.dispatchBeginMigrateGremlinDatabaseToAutoscale(req)
	case "GremlinResourcesClient.BeginMigrateGremlinDatabaseToManualThroughput":
		resp, err = g.dispatchBeginMigrateGremlinDatabaseToManualThroughput(req)
	case "GremlinResourcesClient.BeginMigrateGremlinGraphToAutoscale":
		resp, err = g.dispatchBeginMigrateGremlinGraphToAutoscale(req)
	case "GremlinResourcesClient.BeginMigrateGremlinGraphToManualThroughput":
		resp, err = g.dispatchBeginMigrateGremlinGraphToManualThroughput(req)
	case "GremlinResourcesClient.BeginRetrieveContinuousBackupInformation":
		resp, err = g.dispatchBeginRetrieveContinuousBackupInformation(req)
	case "GremlinResourcesClient.BeginUpdateGremlinDatabaseThroughput":
		resp, err = g.dispatchBeginUpdateGremlinDatabaseThroughput(req)
	case "GremlinResourcesClient.BeginUpdateGremlinGraphThroughput":
		resp, err = g.dispatchBeginUpdateGremlinGraphThroughput(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginCreateUpdateGremlinDatabase(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCreateUpdateGremlinDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateGremlinDatabase not implemented")}
	}
	beginCreateUpdateGremlinDatabase := g.beginCreateUpdateGremlinDatabase.get(req)
	if beginCreateUpdateGremlinDatabase == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.GremlinDatabaseCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCreateUpdateGremlinDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateGremlinDatabase = &respr
		g.beginCreateUpdateGremlinDatabase.add(req, beginCreateUpdateGremlinDatabase)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateGremlinDatabase, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginCreateUpdateGremlinDatabase.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateGremlinDatabase) {
		g.beginCreateUpdateGremlinDatabase.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginCreateUpdateGremlinGraph(req *http.Request) (*http.Response, error) {
	if g.srv.BeginCreateUpdateGremlinGraph == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateGremlinGraph not implemented")}
	}
	beginCreateUpdateGremlinGraph := g.beginCreateUpdateGremlinGraph.get(req)
	if beginCreateUpdateGremlinGraph == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.GremlinGraphCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginCreateUpdateGremlinGraph(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateGremlinGraph = &respr
		g.beginCreateUpdateGremlinGraph.add(req, beginCreateUpdateGremlinGraph)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateGremlinGraph, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginCreateUpdateGremlinGraph.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateGremlinGraph) {
		g.beginCreateUpdateGremlinGraph.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginDeleteGremlinDatabase(req *http.Request) (*http.Response, error) {
	if g.srv.BeginDeleteGremlinDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteGremlinDatabase not implemented")}
	}
	beginDeleteGremlinDatabase := g.beginDeleteGremlinDatabase.get(req)
	if beginDeleteGremlinDatabase == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginDeleteGremlinDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteGremlinDatabase = &respr
		g.beginDeleteGremlinDatabase.add(req, beginDeleteGremlinDatabase)
	}

	resp, err := server.PollerResponderNext(beginDeleteGremlinDatabase, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		g.beginDeleteGremlinDatabase.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteGremlinDatabase) {
		g.beginDeleteGremlinDatabase.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginDeleteGremlinGraph(req *http.Request) (*http.Response, error) {
	if g.srv.BeginDeleteGremlinGraph == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteGremlinGraph not implemented")}
	}
	beginDeleteGremlinGraph := g.beginDeleteGremlinGraph.get(req)
	if beginDeleteGremlinGraph == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginDeleteGremlinGraph(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteGremlinGraph = &respr
		g.beginDeleteGremlinGraph.add(req, beginDeleteGremlinGraph)
	}

	resp, err := server.PollerResponderNext(beginDeleteGremlinGraph, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		g.beginDeleteGremlinGraph.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteGremlinGraph) {
		g.beginDeleteGremlinGraph.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchGetGremlinDatabase(req *http.Request) (*http.Response, error) {
	if g.srv.GetGremlinDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetGremlinDatabase not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.GetGremlinDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GremlinDatabaseGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchGetGremlinDatabaseThroughput(req *http.Request) (*http.Response, error) {
	if g.srv.GetGremlinDatabaseThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetGremlinDatabaseThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.GetGremlinDatabaseThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchGetGremlinGraph(req *http.Request) (*http.Response, error) {
	if g.srv.GetGremlinGraph == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetGremlinGraph not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.GetGremlinGraph(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GremlinGraphGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchGetGremlinGraphThroughput(req *http.Request) (*http.Response, error) {
	if g.srv.GetGremlinGraphThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetGremlinGraphThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.GetGremlinGraphThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchNewListGremlinDatabasesPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListGremlinDatabasesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGremlinDatabasesPager not implemented")}
	}
	newListGremlinDatabasesPager := g.newListGremlinDatabasesPager.get(req)
	if newListGremlinDatabasesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListGremlinDatabasesPager(resourceGroupNameParam, accountNameParam, nil)
		newListGremlinDatabasesPager = &resp
		g.newListGremlinDatabasesPager.add(req, newListGremlinDatabasesPager)
	}
	resp, err := server.PagerResponderNext(newListGremlinDatabasesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListGremlinDatabasesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGremlinDatabasesPager) {
		g.newListGremlinDatabasesPager.remove(req)
	}
	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchNewListGremlinGraphsPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListGremlinGraphsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListGremlinGraphsPager not implemented")}
	}
	newListGremlinGraphsPager := g.newListGremlinGraphsPager.get(req)
	if newListGremlinGraphsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListGremlinGraphsPager(resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		newListGremlinGraphsPager = &resp
		g.newListGremlinGraphsPager.add(req, newListGremlinGraphsPager)
	}
	resp, err := server.PagerResponderNext(newListGremlinGraphsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListGremlinGraphsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListGremlinGraphsPager) {
		g.newListGremlinGraphsPager.remove(req)
	}
	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginMigrateGremlinDatabaseToAutoscale(req *http.Request) (*http.Response, error) {
	if g.srv.BeginMigrateGremlinDatabaseToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateGremlinDatabaseToAutoscale not implemented")}
	}
	beginMigrateGremlinDatabaseToAutoscale := g.beginMigrateGremlinDatabaseToAutoscale.get(req)
	if beginMigrateGremlinDatabaseToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginMigrateGremlinDatabaseToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateGremlinDatabaseToAutoscale = &respr
		g.beginMigrateGremlinDatabaseToAutoscale.add(req, beginMigrateGremlinDatabaseToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateGremlinDatabaseToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginMigrateGremlinDatabaseToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateGremlinDatabaseToAutoscale) {
		g.beginMigrateGremlinDatabaseToAutoscale.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginMigrateGremlinDatabaseToManualThroughput(req *http.Request) (*http.Response, error) {
	if g.srv.BeginMigrateGremlinDatabaseToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateGremlinDatabaseToManualThroughput not implemented")}
	}
	beginMigrateGremlinDatabaseToManualThroughput := g.beginMigrateGremlinDatabaseToManualThroughput.get(req)
	if beginMigrateGremlinDatabaseToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginMigrateGremlinDatabaseToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateGremlinDatabaseToManualThroughput = &respr
		g.beginMigrateGremlinDatabaseToManualThroughput.add(req, beginMigrateGremlinDatabaseToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateGremlinDatabaseToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginMigrateGremlinDatabaseToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateGremlinDatabaseToManualThroughput) {
		g.beginMigrateGremlinDatabaseToManualThroughput.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginMigrateGremlinGraphToAutoscale(req *http.Request) (*http.Response, error) {
	if g.srv.BeginMigrateGremlinGraphToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateGremlinGraphToAutoscale not implemented")}
	}
	beginMigrateGremlinGraphToAutoscale := g.beginMigrateGremlinGraphToAutoscale.get(req)
	if beginMigrateGremlinGraphToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginMigrateGremlinGraphToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateGremlinGraphToAutoscale = &respr
		g.beginMigrateGremlinGraphToAutoscale.add(req, beginMigrateGremlinGraphToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateGremlinGraphToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginMigrateGremlinGraphToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateGremlinGraphToAutoscale) {
		g.beginMigrateGremlinGraphToAutoscale.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginMigrateGremlinGraphToManualThroughput(req *http.Request) (*http.Response, error) {
	if g.srv.BeginMigrateGremlinGraphToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateGremlinGraphToManualThroughput not implemented")}
	}
	beginMigrateGremlinGraphToManualThroughput := g.beginMigrateGremlinGraphToManualThroughput.get(req)
	if beginMigrateGremlinGraphToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginMigrateGremlinGraphToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateGremlinGraphToManualThroughput = &respr
		g.beginMigrateGremlinGraphToManualThroughput.add(req, beginMigrateGremlinGraphToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateGremlinGraphToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginMigrateGremlinGraphToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateGremlinGraphToManualThroughput) {
		g.beginMigrateGremlinGraphToManualThroughput.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginRetrieveContinuousBackupInformation(req *http.Request) (*http.Response, error) {
	if g.srv.BeginRetrieveContinuousBackupInformation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRetrieveContinuousBackupInformation not implemented")}
	}
	beginRetrieveContinuousBackupInformation := g.beginRetrieveContinuousBackupInformation.get(req)
	if beginRetrieveContinuousBackupInformation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveContinuousBackupInformation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ContinuousBackupRestoreLocation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginRetrieveContinuousBackupInformation(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRetrieveContinuousBackupInformation = &respr
		g.beginRetrieveContinuousBackupInformation.add(req, beginRetrieveContinuousBackupInformation)
	}

	resp, err := server.PollerResponderNext(beginRetrieveContinuousBackupInformation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginRetrieveContinuousBackupInformation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRetrieveContinuousBackupInformation) {
		g.beginRetrieveContinuousBackupInformation.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginUpdateGremlinDatabaseThroughput(req *http.Request) (*http.Response, error) {
	if g.srv.BeginUpdateGremlinDatabaseThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateGremlinDatabaseThroughput not implemented")}
	}
	beginUpdateGremlinDatabaseThroughput := g.beginUpdateGremlinDatabaseThroughput.get(req)
	if beginUpdateGremlinDatabaseThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginUpdateGremlinDatabaseThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateGremlinDatabaseThroughput = &respr
		g.beginUpdateGremlinDatabaseThroughput.add(req, beginUpdateGremlinDatabaseThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateGremlinDatabaseThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginUpdateGremlinDatabaseThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateGremlinDatabaseThroughput) {
		g.beginUpdateGremlinDatabaseThroughput.remove(req)
	}

	return resp, nil
}

func (g *GremlinResourcesServerTransport) dispatchBeginUpdateGremlinGraphThroughput(req *http.Request) (*http.Response, error) {
	if g.srv.BeginUpdateGremlinGraphThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateGremlinGraphThroughput not implemented")}
	}
	beginUpdateGremlinGraphThroughput := g.beginUpdateGremlinGraphThroughput.get(req)
	if beginUpdateGremlinGraphThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/gremlinDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/graphs/(?P<graphName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		graphNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("graphName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := g.srv.BeginUpdateGremlinGraphThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, graphNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateGremlinGraphThroughput = &respr
		g.beginUpdateGremlinGraphThroughput.add(req, beginUpdateGremlinGraphThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateGremlinGraphThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		g.beginUpdateGremlinGraphThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateGremlinGraphThroughput) {
		g.beginUpdateGremlinGraphThroughput.remove(req)
	}

	return resp, nil
}
