//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerinstance

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// LocationClient contains the methods for the Location group.
// Don't use this type directly, use NewLocationClient() instead.
type LocationClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewLocationClient creates a new instance of LocationClient with the specified values.
//   - subscriptionID - Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewLocationClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*LocationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &LocationClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListCachedImagesPager - Get the list of cached images on specific OS type for a subscription in a region.
//
// Generated from API version 2023-05-01
//   - location - The identifier for the physical azure location.
//   - options - LocationClientListCachedImagesOptions contains the optional parameters for the LocationClient.NewListCachedImagesPager
//     method.
func (client *LocationClient) NewListCachedImagesPager(location string, options *LocationClientListCachedImagesOptions) *runtime.Pager[LocationClientListCachedImagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[LocationClientListCachedImagesResponse]{
		More: func(page LocationClientListCachedImagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LocationClientListCachedImagesResponse) (LocationClientListCachedImagesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LocationClient.NewListCachedImagesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCachedImagesCreateRequest(ctx, location, options)
			}, nil)
			if err != nil {
				return LocationClientListCachedImagesResponse{}, err
			}
			return client.listCachedImagesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCachedImagesCreateRequest creates the ListCachedImages request.
func (client *LocationClient) listCachedImagesCreateRequest(ctx context.Context, location string, options *LocationClientListCachedImagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/cachedImages"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCachedImagesHandleResponse handles the ListCachedImages response.
func (client *LocationClient) listCachedImagesHandleResponse(resp *http.Response) (LocationClientListCachedImagesResponse, error) {
	result := LocationClientListCachedImagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CachedImagesListResult); err != nil {
		return LocationClientListCachedImagesResponse{}, err
	}
	return result, nil
}

// NewListCapabilitiesPager - Get the list of CPU/memory/GPU capabilities of a region.
//
// Generated from API version 2023-05-01
//   - location - The identifier for the physical azure location.
//   - options - LocationClientListCapabilitiesOptions contains the optional parameters for the LocationClient.NewListCapabilitiesPager
//     method.
func (client *LocationClient) NewListCapabilitiesPager(location string, options *LocationClientListCapabilitiesOptions) *runtime.Pager[LocationClientListCapabilitiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[LocationClientListCapabilitiesResponse]{
		More: func(page LocationClientListCapabilitiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *LocationClientListCapabilitiesResponse) (LocationClientListCapabilitiesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LocationClient.NewListCapabilitiesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCapabilitiesCreateRequest(ctx, location, options)
			}, nil)
			if err != nil {
				return LocationClientListCapabilitiesResponse{}, err
			}
			return client.listCapabilitiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCapabilitiesCreateRequest creates the ListCapabilities request.
func (client *LocationClient) listCapabilitiesCreateRequest(ctx context.Context, location string, options *LocationClientListCapabilitiesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/capabilities"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCapabilitiesHandleResponse handles the ListCapabilities response.
func (client *LocationClient) listCapabilitiesHandleResponse(resp *http.Response) (LocationClientListCapabilitiesResponse, error) {
	result := LocationClientListCapabilitiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CapabilitiesListResult); err != nil {
		return LocationClientListCapabilitiesResponse{}, err
	}
	return result, nil
}

// NewListUsagePager - Get the usage for a subscription
//
// Generated from API version 2023-05-01
//   - location - The identifier for the physical azure location.
//   - options - LocationClientListUsageOptions contains the optional parameters for the LocationClient.NewListUsagePager method.
func (client *LocationClient) NewListUsagePager(location string, options *LocationClientListUsageOptions) *runtime.Pager[LocationClientListUsageResponse] {
	return runtime.NewPager(runtime.PagingHandler[LocationClientListUsageResponse]{
		More: func(page LocationClientListUsageResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *LocationClientListUsageResponse) (LocationClientListUsageResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "LocationClient.NewListUsagePager")
			req, err := client.listUsageCreateRequest(ctx, location, options)
			if err != nil {
				return LocationClientListUsageResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return LocationClientListUsageResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return LocationClientListUsageResponse{}, runtime.NewResponseError(resp)
			}
			return client.listUsageHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listUsageCreateRequest creates the ListUsage request.
func (client *LocationClient) listUsageCreateRequest(ctx context.Context, location string, options *LocationClientListUsageOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/usages"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listUsageHandleResponse handles the ListUsage response.
func (client *LocationClient) listUsageHandleResponse(resp *http.Response) (LocationClientListUsageResponse, error) {
	result := LocationClientListUsageResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsageListResult); err != nil {
		return LocationClientListUsageResponse{}, err
	}
	return result, nil
}
