---
stage: none
group: unassigned
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 'Learn how to use and administer GitLab, the most scalable Git-based fully integrated platform for software development.'
---

<!-- markdownlint-disable MD041 MD044-->

<div class="d-none">
  <h3>Visit <a href="https://docs.gitlab.com/ee/">docs.gitlab.com</a> for the latest version
  of this help information with enhanced navigation, formatting, and search.</h3>
</div>
<!-- the div above will not display on the docs site but will display on /help -->

<!-- markdownlint-enable MD044 -->

# GitLab Docs

Explore the different areas of the documentation:

|                         |                         |
|:------------------------|:------------------------|
| [**Use GitLab**](user/index.md)<br>Get started with GitLab features and functionality. | [**Administer GitLab**](administration/index.md)<br/>Administer a self-managed GitLab instance. |
| [**New to Git and GitLab?**](tutorials/index.md)<br/>Start learning about Git and GitLab. | [**Contribute to GitLab development**](#contribute-to-gitlab)<br/>Create new GitLab functionality and documentation. |
| [**Coming to GitLab from another platform?**](#coming-to-gitlab-from-another-platform)<br/>Learn how to move to GitLab. | [**Build an integration with GitLab**](#build-an-integration-with-gitlab)<br/>Integrate with Jira and other common applications. |
| [**Choose a subscription**](subscriptions/index.md)<br/>Determine which subscription tier makes sense for you. | [**Install GitLab**](install/index.md)<br/>Install GitLab on different platforms. |
| [**Reference architectures**](administration/reference_architectures/index.md)<br/>View recommended deployments at scale. | [**Upgrade GitLab**](update/index.md)<br/>Upgrade your GitLab self-managed instance to the latest version. |

## Popular topics

View some of the most popular topics:

| Popular topic                                                                  | Description |
|:-------------------------------------------------------------------------------|:------------|
| [CI/CD YAML syntax reference](ci/yaml/index.md)                                | Available configuration options for `.gitlab-ci.yml` files. |
| [REST API](api/rest/index.md)                                                  | Use the REST API to extend GitLab. |
| [Environments and deployments](ci/environments/index.md)                       | Deploy your application to different environments. |
| [Configuring runners](ci/runners/configure_runners.md)                         | Get started using runners. |
| [Two-factor authentication](user/profile/account/two_factor_authentication.md) | Improve the security of your GitLab account. |
| [Back up and restore GitLab](administration/backup_restore/index.md)           | Back up and restore a GitLab self-managed instance. |
| [GitLab release and maintenance policy](policy/maintenance.md)                 | Determine how and when to upgrade. |
| [SSH keys](user/ssh.md)                                                        | Use SSH keys to communicate with GitLab. |

## User accounts

Learn about GitLab account management:

| Topic                                                      | Description |
|:-----------------------------------------------------------|:------------|
| [User account](user/profile/index.md)                      | Manage your account. |
| [Authentication](administration/auth/index.md)           | Account security with two-factor authentication, set up your SSH keys, and deploy keys for secure access to your projects. |
| [User settings](user/profile/index.md#access-your-user-settings) | Manage your user settings, two factor authentication, and more. |
| [User permissions](user/permissions.md)                    | Learn what each role in a project can do. |

## Coming to GitLab from another platform

If you are coming to GitLab from another platform:

| Topic                                                                                  | Description |
|:---------------------------------------------------------------------------------------|:------------|
| [Import to GitLab](user/project/import/index.md)                                       | Import your projects from GitHub, Bitbucket, GitLab.com, FogBugz, and SVN into GitLab. |
| [Migrate from SVN](user/project/import/index.md#import-repositories-from-subversion)   | Convert a SVN repository to Git and GitLab. |

## Build an integration with GitLab

To build integrations with GitLab:

| Topic                                      | Description |
|:-------------------------------------------|:------------|
| [GitLab REST API](api/rest/index.md)           | Integrate with GitLab using our REST API. |
| [GitLab GraphQL API](api/graphql/index.md) | Integrate with GitLab using our GraphQL API. |
| [Integrations](integration/index.md)      | Integrations with third-party products. |

## Contribute to GitLab

To contribute to GitLab:

| Topic                                                       | Description |
|:------------------------------------------------------------|:------------|
| [Contribute to GitLab development](development/index.md).  | Contribute to GitLab development. |
| [Contribute to the documentation](development/documentation/index.md) | Contribute to GitLab documentation. |
