# SPDX-License-Identifier: GPL-3.0-or-later
"""
Base worker class to build EFI images.
"""

from .. import library
from ..builder import ImageBuilder


class EFIImageBuilder(ImageBuilder):
    """Base image builder for all EFI based targets."""
    efi_architecture: str | None = None
    partition_table_type: str = 'gpt'
    efi_filesystem_type: str = 'vfat'
    efi_size: str | None = '512MiB'
    boot_loader: str | None = None
    grub_target: str | None = None
    secure_boot: bool = False

    def __init__(self, *args, **kwargs):
        """Initialize the object."""
        super().__init__(*args, **kwargs)
        if not self.efi_architecture:
            raise Exception('EFI architecture is not specified')

    @classmethod
    def install_boot_loader(cls, state):
        """Install the DTB files and boot manager."""
        library.install_grub(state,
                             target=cls.grub_target,
                             is_efi=True,
                             secure_boot=cls.secure_boot)
