/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */


#pragma once

#include "eckit/geo/area/BoundingBoxXY.h"
#include "eckit/geo/grid/Regular.h"
#include "eckit/geo/range/Regular.h"


namespace eckit::geo::grid::regular {


class RegularXY : public Regular {
public:

    // -- Types

    struct Increments : public std::array<double, 2> {
        Increments(value_type dx, value_type dy) : array{dx, dy} {}

        using array::array;

        bool operator==(const Increments&) const;
        bool operator!=(const Increments& other) const { return !operator==(other); }

        const value_type& dx = array::operator[](0);
        const value_type& dy = array::operator[](1);
    };

    using BoundingBoxXY = area::BoundingBoxXY;

    // -- Constructors

    explicit RegularXY(const Spec&);
    explicit RegularXY(const Increments&, BoundingBoxXY);

    // -- Overridden methods

    const std::string& type() const override;

    [[nodiscard]] Point first_point() const override;
    [[nodiscard]] Point last_point() const override;

    double dx() const override { return x_.increment(); }
    double dy() const override { return y_.increment(); }

    size_t nx() const override { return x_.size(); }
    size_t ny() const override { return y_.size(); }

    const Range& x() const override { return x_; }
    const Range& y() const override { return y_; }


    // -- Class methods

    static Increments make_increments_from_spec(const Spec&);

private:

    // -- Overriden methods

    void fill_spec(spec::Custom&) const override;

    // -- Members

    const range::RegularXY x_;
    const range::RegularXY y_;

    // -- Friends

    friend class geo::iterator::Regular;
};


}  // namespace eckit::geo::grid::regular
